/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sqs.xml;

import com.google.common.hash.HashCode;
import com.google.common.io.BaseEncoding;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.sqs.domain.Message;
import org.jclouds.util.SaxUtils;

public class MessageHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<Message> {
    private StringBuilder currentText = new StringBuilder();
    private Message.Builder builder = Message.builder();
    private String name;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message getResult() {
        try {
            Message message = this.builder.build();
            return message;
        }
        catch (NullPointerException e) {
            Message message = null;
            return message;
        }
        finally {
            this.builder = Message.builder();
        }
    }

    public void endElement(String uri, String name, String qName) {
        if (qName.equals("MessageId")) {
            this.builder.id(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (qName.equals("ReceiptHandle")) {
            this.builder.receiptHandle(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (qName.equals("MD5OfBody")) {
            this.builder.md5(HashCode.fromBytes((byte[])BaseEncoding.base16().lowerCase().decode((CharSequence)SaxUtils.currentOrNull((StringBuilder)this.currentText))));
        } else if (qName.equals("Body")) {
            this.builder.body(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (qName.equals("Name")) {
            this.name = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("Value")) {
            this.builder.addAttribute(this.name, SaxUtils.currentOrNull((StringBuilder)this.currentText));
            this.name = null;
        }
        this.currentText.setLength(0);
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

