/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeAutoScalingGroupsRequestMarshaller
implements Marshaller<Request<DescribeAutoScalingGroupsRequest>, DescribeAutoScalingGroupsRequest> {
    public Request<DescribeAutoScalingGroupsRequest> marshall(DescribeAutoScalingGroupsRequest describeAutoScalingGroupsRequest) {
        if (describeAutoScalingGroupsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeAutoScalingGroupsRequest, "AmazonAutoScaling");
        request.addParameter("Action", "DescribeAutoScalingGroups");
        request.addParameter("Version", "2011-01-01");
        List<String> autoScalingGroupNamesList = describeAutoScalingGroupsRequest.getAutoScalingGroupNames();
        int autoScalingGroupNamesListIndex = 1;
        for (String autoScalingGroupNamesListValue : autoScalingGroupNamesList) {
            if (autoScalingGroupNamesListValue != null) {
                request.addParameter("AutoScalingGroupNames.member." + autoScalingGroupNamesListIndex, StringUtils.fromString((String)autoScalingGroupNamesListValue));
            }
            ++autoScalingGroupNamesListIndex;
        }
        if (describeAutoScalingGroupsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeAutoScalingGroupsRequest.getNextToken()));
        }
        if (describeAutoScalingGroupsRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeAutoScalingGroupsRequest.getMaxRecords()));
        }
        return request;
    }
}

