/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob;

import com.google.inject.Provides;
import java.io.Closeable;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.azure.storage.domain.BoundedSet;
import org.jclouds.azure.storage.filters.SharedKeyLiteAuthentication;
import org.jclouds.azure.storage.options.ListOptions;
import org.jclouds.azureblob.AzureBlobFallbacks;
import org.jclouds.azureblob.binders.BindAzureBlobMetadataToMultipartRequest;
import org.jclouds.azureblob.binders.BindAzureBlobMetadataToRequest;
import org.jclouds.azureblob.binders.BindAzureBlocksToRequest;
import org.jclouds.azureblob.binders.BindAzureContentMetadataToRequest;
import org.jclouds.azureblob.binders.BindAzureCopyOptionsToRequest;
import org.jclouds.azureblob.binders.BindPublicAccessToRequest;
import org.jclouds.azureblob.domain.AzureBlob;
import org.jclouds.azureblob.domain.BlobProperties;
import org.jclouds.azureblob.domain.ContainerProperties;
import org.jclouds.azureblob.domain.ListBlobBlocksResponse;
import org.jclouds.azureblob.domain.ListBlobsResponse;
import org.jclouds.azureblob.domain.PublicAccess;
import org.jclouds.azureblob.functions.BlobName;
import org.jclouds.azureblob.functions.ParseBlobFromHeadersAndHttpContent;
import org.jclouds.azureblob.functions.ParseBlobPropertiesFromHeaders;
import org.jclouds.azureblob.functions.ParseContainerPropertiesFromHeaders;
import org.jclouds.azureblob.functions.ParsePublicAccessHeader;
import org.jclouds.azureblob.options.CopyBlobOptions;
import org.jclouds.azureblob.options.CreateContainerOptions;
import org.jclouds.azureblob.options.ListBlobsOptions;
import org.jclouds.azureblob.predicates.validators.BlockIdValidator;
import org.jclouds.azureblob.predicates.validators.ContainerNameValidator;
import org.jclouds.azureblob.xml.AccountNameEnumerationResultsHandler;
import org.jclouds.azureblob.xml.BlobBlocksResultsHandler;
import org.jclouds.azureblob.xml.ContainerNameEnumerationResultsHandler;
import org.jclouds.blobstore.BlobStoreFallbacks;
import org.jclouds.blobstore.binders.BindMapToHeadersWithPrefix;
import org.jclouds.http.functions.ParseETagHeader;
import org.jclouds.http.options.GetOptions;
import org.jclouds.io.ContentMetadata;
import org.jclouds.io.Payload;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Headers;
import org.jclouds.rest.annotations.ParamParser;
import org.jclouds.rest.annotations.ParamValidators;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.annotations.XMLResponseParser;

@RequestFilters(value={SharedKeyLiteAuthentication.class})
@Headers(keys={"x-ms-version"}, values={"{jclouds.api-version}"})
@SkipEncoding(value={47, 36})
@Path(value="/")
public interface AzureBlobClient
extends Closeable {
    @Provides
    public AzureBlob newBlob();

    @Named(value="ListContainers")
    @GET
    @XMLResponseParser(value=AccountNameEnumerationResultsHandler.class)
    @QueryParams(keys={"comp"}, values={"list"})
    public BoundedSet<ContainerProperties> listContainers(ListOptions ... var1);

    @Named(value="CreateContainer")
    @PUT
    @Path(value="{container}")
    @Fallback(value=AzureBlobFallbacks.FalseIfContainerAlreadyExists.class)
    @QueryParams(keys={"restype"}, values={"container"})
    public boolean createContainer(@PathParam(value="container") @ParamValidators(value={ContainerNameValidator.class}) String var1, CreateContainerOptions ... var2);

    @Named(value="GetContainerProperties")
    @HEAD
    @Path(value="{container}")
    @QueryParams(keys={"restype"}, values={"container"})
    @ResponseParser(value=ParseContainerPropertiesFromHeaders.class)
    @Fallback(value=BlobStoreFallbacks.NullOnContainerNotFound.class)
    public ContainerProperties getContainerProperties(@PathParam(value="container") @ParamValidators(value={ContainerNameValidator.class}) String var1);

    @Named(value="GetContainerProperties")
    @HEAD
    @Path(value="{container}")
    @QueryParams(keys={"restype"}, values={"container"})
    @Fallback(value=BlobStoreFallbacks.FalseOnContainerNotFound.class)
    public boolean containerExists(@PathParam(value="container") @ParamValidators(value={ContainerNameValidator.class}) String var1);

    @Named(value="SetContainerMetadata")
    @PUT
    @Path(value="{container}")
    @QueryParams(keys={"restype", "comp"}, values={"container", "metadata"})
    public void setResourceMetadata(@PathParam(value="container") @ParamValidators(value={ContainerNameValidator.class}) String var1, @BinderParam(value=BindMapToHeadersWithPrefix.class) Map<String, String> var2);

    @Named(value="DeleteContainer")
    @DELETE
    @Path(value="{container}")
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    @QueryParams(keys={"restype"}, values={"container"})
    public void deleteContainer(@PathParam(value="container") @ParamValidators(value={ContainerNameValidator.class}) String var1);

    @Named(value="CreateContainer")
    @PUT
    @Path(value="$root")
    @Fallback(value=AzureBlobFallbacks.FalseIfContainerAlreadyExists.class)
    @QueryParams(keys={"restype"}, values={"container"})
    public boolean createRootContainer(CreateContainerOptions ... var1);

    @Named(value="GetContainerACL")
    @HEAD
    @Path(value="{container}")
    @QueryParams(keys={"restype", "comp"}, values={"container", "acl"})
    @ResponseParser(value=ParsePublicAccessHeader.class)
    @Fallback(value=BlobStoreFallbacks.NullOnContainerNotFound.class)
    public PublicAccess getPublicAccessForContainer(@PathParam(value="container") @ParamValidators(value={ContainerNameValidator.class}) String var1);

    @Named(value="SetContainerACL")
    @PUT
    @Path(value="{container}")
    @QueryParams(keys={"restype", "comp"}, values={"container", "acl"})
    @ResponseParser(value=ParseETagHeader.class)
    public String setPublicAccessForContainer(@PathParam(value="container") @ParamValidators(value={ContainerNameValidator.class}) String var1, @BinderParam(value=BindPublicAccessToRequest.class) PublicAccess var2);

    @Named(value="DeleteContainer")
    @DELETE
    @Path(value="$root")
    @Fallback(value=Fallbacks.TrueOnNotFoundOr404.class)
    @QueryParams(keys={"restype"}, values={"container"})
    public void deleteRootContainer();

    @Named(value="ListBlobs")
    @GET
    @XMLResponseParser(value=ContainerNameEnumerationResultsHandler.class)
    @Path(value="{container}")
    @QueryParams(keys={"restype", "comp"}, values={"container", "list"})
    public ListBlobsResponse listBlobs(@PathParam(value="container") @ParamValidators(value={ContainerNameValidator.class}) String var1, ListBlobsOptions ... var2);

    @Named(value="ListBlobs")
    @GET
    @XMLResponseParser(value=ContainerNameEnumerationResultsHandler.class)
    @Path(value="$root")
    @QueryParams(keys={"restype", "comp"}, values={"container", "list"})
    public ListBlobsResponse listBlobs(ListBlobsOptions ... var1);

    @Named(value="PutBlob")
    @PUT
    @Path(value="{container}/{name}")
    @Headers(keys={"Expect"}, values={"100-continue"})
    @ResponseParser(value=ParseETagHeader.class)
    public String putBlob(@PathParam(value="container") @ParamValidators(value={ContainerNameValidator.class}) String var1, @PathParam(value="name") @ParamParser(value=BlobName.class) @BinderParam(value=BindAzureBlobMetadataToRequest.class) AzureBlob var2);

    @Named(value="GetBlob")
    @GET
    @ResponseParser(value=ParseBlobFromHeadersAndHttpContent.class)
    @Fallback(value=BlobStoreFallbacks.NullOnKeyNotFound.class)
    @Path(value="{container}/{name}")
    public AzureBlob getBlob(@PathParam(value="container") @ParamValidators(value={ContainerNameValidator.class}) String var1, @PathParam(value="name") String var2, GetOptions ... var3);

    @Named(value="PutBlock")
    @PUT
    @Path(value="{container}/{name}")
    @QueryParams(keys={"comp"}, values={"block"})
    public void putBlock(@PathParam(value="container") @ParamValidators(value={ContainerNameValidator.class}) String var1, @PathParam(value="name") String var2, @QueryParam(value="blockid") @ParamValidators(value={BlockIdValidator.class}) String var3, Payload var4);

    @Deprecated
    @Named(value="PutBlockList")
    @PUT
    @Path(value="{container}/{name}")
    @ResponseParser(value=ParseETagHeader.class)
    @QueryParams(keys={"comp"}, values={"blocklist"})
    public String putBlockList(@PathParam(value="container") @ParamValidators(value={ContainerNameValidator.class}) String var1, @PathParam(value="name") String var2, @BinderParam(value=BindAzureBlocksToRequest.class) List<String> var3);

    @Named(value="PutBlockList")
    @PUT
    @Path(value="{container}/{name}")
    @ResponseParser(value=ParseETagHeader.class)
    @QueryParams(keys={"comp"}, values={"blocklist"})
    public String putBlockList(@PathParam(value="container") @ParamValidators(value={ContainerNameValidator.class}) String var1, @PathParam(value="name") @ParamParser(value=BlobName.class) @BinderParam(value=BindAzureBlobMetadataToMultipartRequest.class) AzureBlob var2, @BinderParam(value=BindAzureBlocksToRequest.class) List<String> var3);

    @Named(value="GetBlockList")
    @GET
    @Path(value="{container}/{name}")
    @XMLResponseParser(value=BlobBlocksResultsHandler.class)
    @QueryParams(keys={"comp"}, values={"blocklist"})
    public ListBlobBlocksResponse getBlockList(@PathParam(value="container") @ParamValidators(value={ContainerNameValidator.class}) String var1, @PathParam(value="name") String var2);

    @Named(value="GetBlobProperties")
    @HEAD
    @ResponseParser(value=ParseBlobPropertiesFromHeaders.class)
    @Fallback(value=BlobStoreFallbacks.NullOnKeyNotFound.class)
    @Path(value="{container}/{name}")
    public BlobProperties getBlobProperties(@PathParam(value="container") @ParamValidators(value={ContainerNameValidator.class}) String var1, @PathParam(value="name") String var2);

    @Named(value="SetBlobProperties")
    @PUT
    @Path(value="{container}/{name}")
    @QueryParams(keys={"comp"}, values={"metadata"})
    @ResponseParser(value=ParseETagHeader.class)
    public String setBlobProperties(@PathParam(value="container") @ParamValidators(value={ContainerNameValidator.class}) String var1, @PathParam(value="name") String var2, @BinderParam(value=BindAzureContentMetadataToRequest.class) ContentMetadata var3);

    @Named(value="SetBlobMetadata")
    @PUT
    @Path(value="{container}/{name}")
    @QueryParams(keys={"comp"}, values={"metadata"})
    @ResponseParser(value=ParseETagHeader.class)
    public String setBlobMetadata(@PathParam(value="container") @ParamValidators(value={ContainerNameValidator.class}) String var1, @PathParam(value="name") String var2, @BinderParam(value=BindMapToHeadersWithPrefix.class) Map<String, String> var3);

    @Named(value="DeleteBlob")
    @DELETE
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    @Path(value="{container}/{name}")
    public void deleteBlob(@PathParam(value="container") @ParamValidators(value={ContainerNameValidator.class}) String var1, @PathParam(value="name") String var2);

    @Named(value="GetBlobProperties")
    @HEAD
    @Fallback(value=BlobStoreFallbacks.FalseOnKeyNotFound.class)
    @Path(value="{container}/{name}")
    public boolean blobExists(@PathParam(value="container") @ParamValidators(value={ContainerNameValidator.class}) String var1, @PathParam(value="name") String var2);

    @Named(value="CopyBlob")
    @PUT
    @Path(value="{toContainer}/{toName}")
    @Headers(keys={"x-ms-copy-source"}, values={"{copySource}"})
    public void copyBlob(@PathParam(value="copySource") URI var1, @PathParam(value="toContainer") @ParamValidators(value={ContainerNameValidator.class}) String var2, @PathParam(value="toName") String var3, @BinderParam(value=BindAzureCopyOptionsToRequest.class) CopyBlobOptions var4);
}

