/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.xml;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.date.DateService;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.ultradns.ws.domain.Zone;
import org.jclouds.ultradns.ws.domain.ZoneProperties;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class ZonePropertiesHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<ZoneProperties> {
    private final DateService dateService;
    private ZoneProperties zone;

    @Inject
    ZonePropertiesHandler(DateService dateService) {
        this.dateService = dateService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZoneProperties getResult() {
        try {
            ZoneProperties zoneProperties = this.zone;
            return zoneProperties;
        }
        finally {
            this.zone = null;
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) {
        Map attributes = SaxUtils.cleanseAttributes((Attributes)attrs);
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"GeneralZoneProperties")) {
            Zone.Type type = Zone.Type.valueOf(((String)Preconditions.checkNotNull(attributes.get("zoneType"), (Object)"zoneType")).toUpperCase());
            int count = Integer.parseInt((String)Preconditions.checkNotNull(attributes.get("resourceRecordCount"), (Object)"resourceRecordCount"));
            this.zone = ZoneProperties.builder().name((String)attributes.get("name")).typeCode(type.getCode()).resourceRecordCount(count).modified(this.dateService.iso8601DateParse((String)attributes.get("modified"))).build();
        }
    }
}

