/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.domain;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;

public final class Zone {
    private final String id;
    private final String name;
    private final Type type;
    private final int typeCode;
    private final String accountId;
    private final String ownerId;
    private final DNSSECStatus dnssecStatus;
    private final Optional<String> primarySrc;

    private Zone(String id, String name, Type type, int typeCode, String accountId, String ownerId, DNSSECStatus dnssecStatus, Optional<String> primarySrc) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.name = (String)Preconditions.checkNotNull((Object)name, (String)"name for %s", (Object[])new Object[]{id});
        Preconditions.checkArgument((typeCode >= 0 ? 1 : 0) != 0, (String)"typeCode of %s must be >= 0", (Object[])new Object[]{id});
        this.typeCode = typeCode;
        this.type = (Type)((Object)Preconditions.checkNotNull((Object)((Object)type), (String)"type for %s", (Object[])new Object[]{name}));
        this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (String)"accountId for %s", (Object[])new Object[]{name});
        this.ownerId = (String)Preconditions.checkNotNull((Object)ownerId, (String)"ownerId for %s", (Object[])new Object[]{name});
        this.dnssecStatus = (DNSSECStatus)((Object)Preconditions.checkNotNull((Object)((Object)dnssecStatus), (String)"dnssecStatus for %s", (Object[])new Object[]{name}));
        this.primarySrc = (Optional)Preconditions.checkNotNull(primarySrc, (String)"primarySrc for %s", (Object[])new Object[]{primarySrc});
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public int getTypeCode() {
        return this.typeCode;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public DNSSECStatus getDNSSECStatus() {
        return this.dnssecStatus;
    }

    public Optional<String> getPrimarySrc() {
        return this.primarySrc;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.name, this.accountId});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Zone that = (Zone)Zone.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.accountId, (Object)that.accountId);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("type", (Object)this.type).add("accountId", (Object)this.accountId).add("ownerId", (Object)this.ownerId).add("dnssecStatus", (Object)this.dnssecStatus).add("primarySrc", this.primarySrc.orNull()).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return Zone.builder().from(this);
    }

    public static final class Builder {
        private String id;
        private String name;
        private Type type;
        private int typeCode = -1;
        private String accountId;
        private String ownerId;
        private DNSSECStatus dnssecStatus;
        private Optional<String> primarySrc = Optional.absent();

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        public Builder typeCode(int typeCode) {
            this.typeCode = typeCode;
            this.type = Type.fromValue(typeCode);
            return this;
        }

        public Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public Builder dnssecStatus(DNSSECStatus dnssecStatus) {
            this.dnssecStatus = dnssecStatus;
            return this;
        }

        public Builder primarySrc(String primarySrc) {
            this.primarySrc = Optional.fromNullable((Object)primarySrc);
            return this;
        }

        public Zone build() {
            return new Zone(this.id, this.name, this.type, this.typeCode, this.accountId, this.ownerId, this.dnssecStatus, this.primarySrc);
        }

        public Builder from(Zone in) {
            return this.id(in.id).name(in.name).typeCode(in.typeCode).type(in.type).accountId(in.accountId).ownerId(in.ownerId).dnssecStatus(in.dnssecStatus).primarySrc((String)in.primarySrc.orNull());
        }
    }

    public static enum DNSSECStatus {
        SIGNED,
        UNSIGNED,
        UNRECOGNIZED;


        public static DNSSECStatus fromValue(String status) {
            try {
                return DNSSECStatus.valueOf((String)Preconditions.checkNotNull((Object)status, (Object)"status"));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }

    public static enum Type {
        PRIMARY(1),
        SECONDARY(2),
        ALIAS(3),
        UNRECOGNIZED(-1);

        private final int code;

        private Type(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        public static Type fromValue(String type) {
            return Type.fromValue(Integer.parseInt((String)Preconditions.checkNotNull((Object)type, (Object)"type")));
        }

        public static Type fromValue(int code) {
            switch (code) {
                case 1: {
                    return PRIMARY;
                }
                case 2: {
                    return SECONDARY;
                }
                case 3: {
                    return ALIAS;
                }
            }
            return UNRECOGNIZED;
        }
    }
}

