/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.clouddns.v1.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Date;
import org.jclouds.rackspace.clouddns.v1.domain.Record;

public class RecordDetail {
    private final String id;
    private final Date created;
    private final Date updated;
    private final Record record;

    private RecordDetail(String id, Date created, Date updated, Record record) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id required");
        this.created = (Date)Preconditions.checkNotNull((Object)created, (Object)"created required");
        this.updated = (Date)Preconditions.checkNotNull((Object)updated, (Object)"updated required");
        this.record = (Record)Preconditions.checkNotNull((Object)record, (Object)"record required");
    }

    public String getId() {
        return this.id;
    }

    public Date getCreated() {
        return this.created;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public Record getRecord() {
        return this.record;
    }

    public String getName() {
        return this.record.getName();
    }

    public String getType() {
        return this.record.getType();
    }

    public int getTTL() {
        return (Integer)this.record.getTTL().get();
    }

    public String getData() {
        return this.record.getData();
    }

    public Integer getPriority() {
        return this.record.getPriority();
    }

    public String getComment() {
        return this.record.getComment();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RecordDetail that = (RecordDetail)RecordDetail.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.id).add("created", (Object)this.created).add("updated", (Object)this.updated).add("record", (Object)this.record);
    }

    public String toString() {
        return this.string().toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return RecordDetail.builder().from(this);
    }

    public static final class Builder {
        private String id;
        private Date created;
        private Date updated;
        private Record record;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder created(Date created) {
            this.created = created;
            return this;
        }

        public Builder updated(Date updated) {
            this.updated = updated;
            return this;
        }

        public Builder record(Record record) {
            this.record = record;
            return this;
        }

        public Builder record(Record.Builder recordBuilder) {
            this.record = recordBuilder.build();
            return this;
        }

        public RecordDetail build() {
            return new RecordDetail(this.id, this.created, this.updated, this.record);
        }

        public Builder from(RecordDetail in) {
            return this.id(in.getId()).created(in.getCreated()).updated(in.getUpdated()).record(in.getRecord());
        }
    }
}

