/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.dynect.v3.domain.rdata;

import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ImmutableMap;
import java.beans.ConstructorProperties;
import java.util.Map;

public class SRVData
extends ForwardingMap<String, Object> {
    private final int priority;
    private final int weight;
    private final int port;
    private final String target;
    private final transient ImmutableMap<String, Object> delegate;

    @ConstructorProperties(value={"priority", "weight", "port", "target"})
    private SRVData(int priority, int weight, int port, String target) {
        Preconditions.checkArgument(((Integer)Preconditions.checkNotNull((Object)priority, (String)"priority of %s", (Object[])new Object[]{target}) <= 65535 ? 1 : 0) != 0, (Object)"priority must be 0-65535");
        this.priority = priority;
        Preconditions.checkArgument(((Integer)Preconditions.checkNotNull((Object)weight, (String)"weight of %s", (Object[])new Object[]{target}) <= 65535 ? 1 : 0) != 0, (Object)"weight must be 0-65535");
        this.weight = weight;
        Preconditions.checkArgument(((Integer)Preconditions.checkNotNull((Object)port, (String)"port of %s", (Object[])new Object[]{target}) <= 65535 ? 1 : 0) != 0, (Object)"port must be 0-65535");
        this.port = port;
        this.target = (String)Preconditions.checkNotNull((Object)target, (Object)"target");
        this.delegate = ImmutableMap.builder().put((Object)"priority", (Object)priority).put((Object)"weight", (Object)weight).put((Object)"port", (Object)port).put((Object)"target", (Object)target).build();
    }

    public int getPriority() {
        return this.priority;
    }

    public int getWeight() {
        return this.weight;
    }

    public int getPort() {
        return this.port;
    }

    public String getTarget() {
        return this.target;
    }

    protected Map<String, Object> delegate() {
        return this.delegate;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return SRVData.builder().from(this);
    }

    public static final class Builder {
        private int priority = -1;
        private int weight = -1;
        private int port = -1;
        private String target;

        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        public Builder weight(int weight) {
            this.weight = weight;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder target(String target) {
            this.target = target;
            return this;
        }

        public SRVData build() {
            return new SRVData(this.priority, this.weight, this.port, this.target);
        }

        public Builder from(SRVData in) {
            return this.priority(in.getPriority()).weight(in.getWeight()).port(in.getPort()).target(in.getTarget());
        }
    }
}

