/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.cinder.v1.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class VolumeQuota {
    private final String id;
    private final int volumes;
    private final int gigabytes;
    private final int snapshots;

    protected VolumeQuota(String id, int volumes, int gigabytes, int snapshots) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.volumes = volumes;
        this.gigabytes = gigabytes;
        this.snapshots = snapshots;
    }

    public String getId() {
        return this.id;
    }

    public int getVolumes() {
        return this.volumes;
    }

    public int getGigabytes() {
        return this.gigabytes;
    }

    public int getSnapshots() {
        return this.snapshots;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.volumes, this.gigabytes, this.snapshots});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        VolumeQuota that = (VolumeQuota)VolumeQuota.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.volumes, (Object)that.volumes) && Objects.equal((Object)this.gigabytes, (Object)that.gigabytes) && Objects.equal((Object)this.snapshots, (Object)that.snapshots);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id).add("volumes", this.volumes).add("gigabytes", this.gigabytes).add("snapshots", this.snapshots);
    }

    public String toString() {
        return this.string().toString();
    }

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromVolumeQuota(this);
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected int volumes;
        protected int gigabytes;
        protected int snapshots;

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T volumes(int volumes) {
            this.volumes = volumes;
            return this.self();
        }

        public T gigabytes(int gigabytes) {
            this.gigabytes = gigabytes;
            return this.self();
        }

        public T snapshots(int snapshots) {
            this.snapshots = snapshots;
            return this.self();
        }

        public VolumeQuota build() {
            return new VolumeQuota(this.id, this.volumes, this.gigabytes, this.snapshots);
        }

        public T fromVolumeQuota(VolumeQuota in) {
            return ((Builder)((Builder)((Builder)this.id(in.getId())).volumes(in.getVolumes())).gigabytes(in.getGigabytes())).snapshots(in.getSnapshots());
        }
    }
}

