/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.cinder.v1.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import org.jclouds.openstack.cinder.v1.domain.ZoneState;

public class AvailabilityZone {
    private final String name;
    private final ZoneState state;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().fromAvailabilityZone(this);
    }

    @ConstructorProperties(value={"zoneName", "zoneState"})
    protected AvailabilityZone(String name, ZoneState zoneState) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.state = (ZoneState)Preconditions.checkNotNull((Object)zoneState);
    }

    public String getName() {
        return this.name;
    }

    public ZoneState getZoneState() {
        return this.state;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.state});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AvailabilityZone that = (AvailabilityZone)AvailabilityZone.class.cast(obj);
        return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.state, (Object)that.state);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.name).add("state", (Object)this.state);
    }

    public String toString() {
        return this.string().toString();
    }

    public static class Builder {
        protected boolean available;
        protected String name;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder available(boolean available) {
            this.available = available;
            return this;
        }

        public AvailabilityZone build() {
            return new AvailabilityZone(this.name, new ZoneState(this.available));
        }

        public Builder fromAvailabilityZone(AvailabilityZone in) {
            return this.name(in.getName()).available(in.getZoneState().available());
        }
    }
}

