/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.blobstore.functions;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.atmos.domain.BoundedSet;
import org.jclouds.atmos.domain.DirectoryEntry;
import org.jclouds.atmos.domain.FileType;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.domain.internal.BlobMetadataImpl;
import org.jclouds.blobstore.domain.internal.MutableBlobMetadataImpl;
import org.jclouds.blobstore.domain.internal.PageSetImpl;
import org.jclouds.blobstore.domain.internal.StorageMetadataImpl;
import org.jclouds.domain.Location;
import org.jclouds.io.ContentMetadata;
import org.jclouds.io.payloads.BaseMutableContentMetadata;

@Singleton
public class DirectoryEntryListToResourceMetadataList
implements Function<BoundedSet<? extends DirectoryEntry>, PageSet<? extends StorageMetadata>> {
    private Supplier<Location> defaultLocation;

    @Inject
    DirectoryEntryListToResourceMetadataList(Supplier<Location> defaultLocation) {
        this.defaultLocation = defaultLocation;
    }

    public PageSet<? extends StorageMetadata> apply(BoundedSet<? extends DirectoryEntry> from) {
        return new PageSetImpl(Iterables.transform(from, (Function)new Function<DirectoryEntry, StorageMetadata>(){

            public StorageMetadata apply(DirectoryEntry from) {
                StorageType type;
                StorageType storageType = type = from.getType() == FileType.DIRECTORY ? StorageType.FOLDER : StorageType.BLOB;
                if (type == StorageType.FOLDER) {
                    return new StorageMetadataImpl(type, from.getObjectID(), from.getObjectName(), (Location)DirectoryEntryListToResourceMetadataList.this.defaultLocation.get(), null, null, null, null, (Map)ImmutableMap.of());
                }
                BlobMetadataImpl metadata = new BlobMetadataImpl(from.getObjectID(), from.getObjectName(), (Location)DirectoryEntryListToResourceMetadataList.this.defaultLocation.get(), null, null, null, null, (Map)ImmutableMap.of(), null, null, (ContentMetadata)new BaseMutableContentMetadata());
                MutableBlobMetadataImpl mutable = new MutableBlobMetadataImpl((BlobMetadata)metadata);
                mutable.setSize(Long.valueOf(from.getSize()));
                return mutable;
            }
        }), from.getToken());
    }
}

