/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DescribeReservedInstancesModificationsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeReservedInstancesModificationsRequestMarshaller
implements Marshaller<Request<DescribeReservedInstancesModificationsRequest>, DescribeReservedInstancesModificationsRequest> {
    public Request<DescribeReservedInstancesModificationsRequest> marshall(DescribeReservedInstancesModificationsRequest describeReservedInstancesModificationsRequest) {
        if (describeReservedInstancesModificationsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeReservedInstancesModificationsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeReservedInstancesModifications");
        request.addParameter("Version", "2015-03-01");
        List<String> reservedInstancesModificationIdsList = describeReservedInstancesModificationsRequest.getReservedInstancesModificationIds();
        int reservedInstancesModificationIdsListIndex = 1;
        for (String reservedInstancesModificationIdsListValue : reservedInstancesModificationIdsList) {
            if (reservedInstancesModificationIdsListValue != null) {
                request.addParameter("ReservedInstancesModificationId." + reservedInstancesModificationIdsListIndex, StringUtils.fromString((String)reservedInstancesModificationIdsListValue));
            }
            ++reservedInstancesModificationIdsListIndex;
        }
        if (describeReservedInstancesModificationsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeReservedInstancesModificationsRequest.getNextToken()));
        }
        List<Filter> filtersList = describeReservedInstancesModificationsRequest.getFilters();
        int filtersListIndex = 1;
        for (Filter filtersListValue : filtersList) {
            Filter filterMember = filtersListValue;
            if (filterMember != null) {
                if (filterMember.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filterMember.getName()));
                }
                List<String> valuesList = filterMember.getValues();
                int valuesListIndex = 1;
                for (String valuesListValue : valuesList) {
                    if (valuesListValue != null) {
                        request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                    }
                    ++valuesListIndex;
                }
            }
            ++filtersListIndex;
        }
        return request;
    }
}

