/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.osgi;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.jclouds.util.Strings2;
import org.osgi.framework.Bundle;

public final class Bundles {
    private Bundles() {
    }

    public static <T> ImmutableSet<T> instantiateAvailableClasses(Bundle bundle, Iterable<String> classNames, Class<T> type) {
        Preconditions.checkNotNull((Object)bundle, (Object)"bundle");
        Preconditions.checkNotNull(classNames, (Object)"classNames");
        Preconditions.checkNotNull(type, (Object)"type");
        return FluentIterable.from(classNames).transform(Bundles.loadClassIfAssignableFrom(bundle, type)).filter(Predicates.notNull()).transform(Bundles.instantiateIfPossible(type)).filter(Predicates.notNull()).toSet();
    }

    private static Function<String, Class<?>> loadClassIfAssignableFrom(final Bundle bundle, final Class<?> clazz) {
        Preconditions.checkNotNull((Object)bundle, (Object)"bundle");
        Preconditions.checkNotNull(clazz, (Object)"clazz");
        return new Function<String, Class<?>>(){

            public Class<?> apply(String in) {
                Preconditions.checkNotNull((Object)in, (Object)"classname");
                try {
                    Class thing = bundle.loadClass(in);
                    if (clazz.isAssignableFrom(thing)) {
                        return thing.asSubclass(clazz);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                return null;
            }
        };
    }

    private static <T> Function<Class<?>, T> instantiateIfPossible(final Class<T> clazz) {
        return new Function<Class<?>, T>(){

            public T apply(Class<?> in) {
                Preconditions.checkNotNull(in, (Object)"input class");
                try {
                    return clazz.cast(in.newInstance());
                }
                catch (InstantiationException e) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
                return null;
            }
        };
    }

    public static ImmutableSet<String> stringsForResourceInBundle(String resourcePath, Bundle bundle) {
        Preconditions.checkNotNull((Object)resourcePath, (Object)"resourcePath");
        Preconditions.checkNotNull((Object)bundle, (Object)"bundle");
        URL resource = bundle.getEntry(resourcePath);
        if (resource == null) {
            return ImmutableSet.of();
        }
        try {
            return ImmutableSet.copyOf(Bundles.splitOrEmptyAndClose(resource.openStream()));
        }
        catch (IOException e) {
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return ImmutableSet.of();
    }

    private static Iterable<String> splitOrEmptyAndClose(InputStream in) throws IOException {
        return Splitter.onPattern((String)"\r?\n").omitEmptyStrings().split((CharSequence)Strings2.toStringAndClose(in));
    }
}

