/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.query;

import java.util.regex.Pattern;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.util.ObjectUtils;

public enum MongoRegexCreator {
    INSTANCE;

    private static final Pattern PUNCTATION_PATTERN;

    public String toRegularExpression(String source, Part.Type type) {
        if (type == null || source == null) {
            return source;
        }
        String regex = this.prepareAndEscapeStringBeforeApplyingLikeRegex(source, type);
        switch (type) {
            case STARTING_WITH: {
                regex = "^" + regex;
                break;
            }
            case ENDING_WITH: {
                regex = regex + "$";
                break;
            }
            case CONTAINING: 
            case NOT_CONTAINING: {
                regex = ".*" + regex + ".*";
                break;
            }
            case SIMPLE_PROPERTY: 
            case NEGATING_SIMPLE_PROPERTY: {
                regex = "^" + regex + "$";
            }
        }
        return regex;
    }

    private String prepareAndEscapeStringBeforeApplyingLikeRegex(String source, Part.Type type) {
        boolean trailingWildcard;
        if (ObjectUtils.nullSafeEquals((Object)Part.Type.REGEX, (Object)type)) {
            return source;
        }
        if (!ObjectUtils.nullSafeEquals((Object)Part.Type.LIKE, (Object)type)) {
            return PUNCTATION_PATTERN.matcher(source).find() ? Pattern.quote(source) : source;
        }
        if (source.equals("*")) {
            return ".*";
        }
        StringBuilder sb = new StringBuilder();
        boolean leadingWildcard = source.startsWith("*");
        String valueToUse = source.substring(leadingWildcard ? 1 : 0, (trailingWildcard = source.endsWith("*")) ? source.length() - 1 : source.length());
        if (PUNCTATION_PATTERN.matcher(valueToUse).find()) {
            valueToUse = Pattern.quote(valueToUse);
        }
        if (leadingWildcard) {
            sb.append(".*");
        }
        sb.append(valueToUse);
        if (trailingWildcard) {
            sb.append(".*");
        }
        return sb.toString();
    }

    static {
        PUNCTATION_PATTERN = Pattern.compile("\\p{Punct}");
    }
}

