/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.lang.reflect.Method;
import org.springframework.data.mongodb.util.MongoClientVersion;
import org.springframework.util.ReflectionUtils;

class ReflectiveDBCollectionInvoker {
    private static final Method GEN_INDEX_NAME_METHOD = ReflectionUtils.findMethod(DBCollection.class, (String)"genIndexName", (Class[])new Class[]{DBObject.class});
    private static final Method RESET_INDEX_CHACHE_METHOD = ReflectionUtils.findMethod(DBCollection.class, (String)"resetIndexCache");

    private ReflectiveDBCollectionInvoker() {
    }

    public static String generateIndexName(DBObject keys) {
        if (MongoClientVersion.isMongo3Driver()) {
            return ReflectiveDBCollectionInvoker.genIndexName(keys);
        }
        return (String)ReflectionUtils.invokeMethod((Method)GEN_INDEX_NAME_METHOD, null, (Object[])new Object[]{keys});
    }

    public static void resetIndexCache(DBCollection dbCollection) {
        if (MongoClientVersion.isMongo3Driver()) {
            throw new UnsupportedOperationException("The mongo java driver 3 does no loger support resetIndexCache!");
        }
        ReflectionUtils.invokeMethod((Method)RESET_INDEX_CHACHE_METHOD, (Object)dbCollection);
    }

    private static String genIndexName(DBObject keys) {
        StringBuilder name = new StringBuilder();
        for (String s : keys.keySet()) {
            if (name.length() > 0) {
                name.append('_');
            }
            name.append(s).append('_');
            Object val = keys.get(s);
            if (!(val instanceof Number) && !(val instanceof String)) continue;
            name.append(val.toString().replace(' ', '_'));
        }
        return name.toString();
    }
}

