/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.css;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSRule;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleSheet;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;

@JsxClass
public class CSSRuleList
extends SimpleScriptable {
    private final List<CSSRule> rules_ = new ArrayList<CSSRule>();

    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.EDGE)})
    public CSSRuleList() {
    }

    public CSSRuleList(CSSStyleSheet stylesheet) {
        this.setParentScope(stylesheet.getParentScope());
        this.setPrototype(this.getPrototype(this.getClass()));
    }

    protected void addRule(CSSRule rule) {
        this.rules_.add(rule);
    }

    protected void clearRules() {
        this.rules_.clear();
    }

    @JsxGetter
    public int getLength() {
        if (this.rules_ != null) {
            return this.rules_.size();
        }
        return 0;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF)})
    public Object item(int index) {
        return null;
    }

    public Object[] getIds() {
        ArrayList<String> idList = new ArrayList<String>();
        int length = this.getLength();
        for (int i = 0; i < length; ++i) {
            idList.add(Integer.toString(i));
        }
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_CSSRULELIST_ENUM_ITEM_LENGTH)) {
            idList.add("item");
            idList.add("length");
        } else {
            idList.add("length");
            idList.add("item");
        }
        return idList.toArray();
    }

    @Override
    public boolean has(int index, Scriptable start) {
        return index >= 0 && index < this.getLength();
    }

    public boolean has(String name, Scriptable start) {
        if ("length".equals(name) || "item".equals(name)) {
            return true;
        }
        try {
            return this.has(Integer.parseInt(name), start);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Object get(int index, Scriptable start) {
        if (index < 0 || this.getLength() <= index) {
            return NOT_FOUND;
        }
        return this.rules_.get(index);
    }
}

