/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.udc.service.impl;

import com.parablu.bluvault.ah.service.AuditHistoryService;
import com.parablu.bluvault.sync.element.SyncOverviewElement;
import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.cloud.security.service.impl.UserValidateService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.helper.exceptions.BaseException;
import com.parablu.helper.utils.MD5Generator;
import com.parablu.mail.service.CloudMailService;
import com.parablu.mt.service.LdapService;
import com.parablu.paracloud.constant.PCActionTypes;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.AADUserElement;
import com.parablu.paracloud.element.BackupFolderElement;
import com.parablu.paracloud.element.BackupPoliciesAdminList;
import com.parablu.paracloud.element.BackupPolicyElement;
import com.parablu.paracloud.element.EmailProps;
import com.parablu.paracloud.element.EmailRecipent;
import com.parablu.paracloud.element.LdapUserElement;
import com.parablu.paracloud.element.MiniCloudElement;
import com.parablu.paracloud.element.MiniCloudElementList;
import com.parablu.paracloud.element.PrivacyGatewayMappingElement;
import com.parablu.paracloud.element.SearchUserElement;
import com.parablu.paracloud.element.SyncPoliciesAdminList;
import com.parablu.paracloud.element.SyncPolicyElement;
import com.parablu.paracloud.element.UserElement;
import com.parablu.paracloud.element.UserGroupElement;
import com.parablu.paracloud.element.UserListElement;
import com.parablu.paracloud.element.response.UserErrorReponse;
import com.parablu.pcbd.dao.AuditHistoryDao;
import com.parablu.pcbd.dao.AuthorizationDao;
import com.parablu.pcbd.dao.BackupPolicyDao;
import com.parablu.pcbd.dao.DeletedUserDao;
import com.parablu.pcbd.dao.DeviceDao;
import com.parablu.pcbd.dao.FileRevisionDao;
import com.parablu.pcbd.dao.MigrationStatusDao;
import com.parablu.pcbd.dao.MiniCloudDao;
import com.parablu.pcbd.dao.PciAuthorizationTokensDao;
import com.parablu.pcbd.dao.PersonDao;
import com.parablu.pcbd.dao.UserDao;
import com.parablu.pcbd.dao.UserGroupDao;
import com.parablu.pcbd.dao.UserMiniCloudMappingDao;
import com.parablu.pcbd.domain.AdCredentials;
import com.parablu.pcbd.domain.AuditHistory;
import com.parablu.pcbd.domain.BackupFolders;
import com.parablu.pcbd.domain.BackupPolicy;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.DailySyncOverView;
import com.parablu.pcbd.domain.DeletedUser;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.FailedLogin;
import com.parablu.pcbd.domain.Group;
import com.parablu.pcbd.domain.InclusionFilter;
import com.parablu.pcbd.domain.MigrationStatus;
import com.parablu.pcbd.domain.MiniCloud;
import com.parablu.pcbd.domain.NetworkThrottling;
import com.parablu.pcbd.domain.PciAuthorizationTokens;
import com.parablu.pcbd.domain.Person;
import com.parablu.pcbd.domain.PrivacyGateway;
import com.parablu.pcbd.domain.Schedule;
import com.parablu.pcbd.domain.SyncOverView;
import com.parablu.pcbd.domain.User;
import com.parablu.pcbd.domain.UserCloudAccessControl;
import com.parablu.pcbd.domain.UserGroup;
import com.parablu.pcsd.dao.SyncPolicyDao;
import com.parablu.pcsd.domain.SyncPolicy;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.validator.routines.EmailValidator;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.util.CollectionUtils;

public class UserManagementServiceImpl
extends UserValidateService
implements UserManagementService {
    private static Logger logger = LoggerFactory.getLogger(UserManagementServiceImpl.class);
    private UserDao userDao;
    private MiniCloudDao miniCloudDao;
    private UserMiniCloudMappingDao userMiniCloudMappingDao;
    private DeviceDao deviceDao;
    private AuthorizationDao authorizationDao;
    private PciAuthorizationTokensDao pciAuthorizationTokensDao;
    private BackupPolicyDao backupPolicyDao;
    private SyncPolicyDao syncPolicyDao;
    private DeletedUserDao deletedUserDao;
    private UserGroupDao userGroupDao;
    private FileRevisionDao fileRevisionDao;
    private PersonDao personDao;
    private MigrationStatusDao migrationStatusDao;
    @Autowired
    private CloudMailService cloudMailService;
    @Autowired
    private AuditHistoryService auditHistoryService;
    @Resource
    private AuditHistoryDao auditHistoryDao;
    @Autowired
    private LdapService ldapService;
    private static final int NO_OF_HASHES = 5;
    private static final String USER_NOT_FOUND = "User not found.";
    private static final String BASE_EXCEPTION = " BaseException  :";
    private static final String EXCEPTION = " Exception  :";
    private static final String NUMBER_FORMAT_EXCEPTION = "NumberFormatException  ";
    private static final String MM_DD_YYYY_HH_MM_SS = "MM/dd/yyyy HH:mm:ss";
    private static final String SYNC_ENABLED = "Sync Enabled";
    private static final String BACKUP_ENABLED = "Backup Enabled";
    private static final int AD_CONNECTION_FAILED = 400;

    public void setLdapService(LdapService ldapService) {
        this.ldapService = ldapService;
    }

    public SyncPolicyDao getSyncPolicyDao() {
        return this.syncPolicyDao;
    }

    public void setSyncPolicyDao(SyncPolicyDao syncPolicyDao) {
        this.syncPolicyDao = syncPolicyDao;
    }

    public void setFileRevisionDao(FileRevisionDao fileRevisionDao) {
        this.fileRevisionDao = fileRevisionDao;
    }

    public void setUserGroupDao(UserGroupDao userGroupDao) {
        this.userGroupDao = userGroupDao;
    }

    public MiniCloudDao getMiniCloudDao() {
        return this.miniCloudDao;
    }

    public void setMiniCloudDao(MiniCloudDao miniCloudDao) {
        this.miniCloudDao = miniCloudDao;
    }

    public UserMiniCloudMappingDao getUserMiniCloudMappingDao() {
        return this.userMiniCloudMappingDao;
    }

    public void setUserMiniCloudMappingDao(UserMiniCloudMappingDao userMiniCloudMappingDao) {
        this.userMiniCloudMappingDao = userMiniCloudMappingDao;
    }

    public void setDeviceDao(DeviceDao deviceDao) {
        this.deviceDao = deviceDao;
    }

    public void setAuthorizationDao(AuthorizationDao authorizationDao) {
        this.authorizationDao = authorizationDao;
    }

    public PciAuthorizationTokensDao getPciAuthorizationTokensDao() {
        return this.pciAuthorizationTokensDao;
    }

    public void setPciAuthorizationTokensDao(PciAuthorizationTokensDao pciAuthorizationTokensDao) {
        this.pciAuthorizationTokensDao = pciAuthorizationTokensDao;
    }

    public void setBackupPolicyDao(BackupPolicyDao backupPolicyDao) {
        this.backupPolicyDao = backupPolicyDao;
    }

    public void setPersonDao(PersonDao personDao) {
        this.personDao = personDao;
    }

    public void setUserDao(UserDao userDao) {
        this.userDao = userDao;
    }

    @Override
    public UserElement createUser(int cloudId, String cloudName, UserElement userElement, String currentUserName) {
        String recoveryKey;
        UserElement userResponse;
        block5: {
            userResponse = new UserElement();
            UUID uuid = UUID.randomUUID();
            recoveryKey = String.valueOf(uuid);
            try {
                User user = new User();
                UserElement createdUser = this.createUser(cloudId, cloudName, userElement, false, this.userDao);
                if (createdUser != null) {
                    BeanUtils.copyProperties((Object)createdUser, (Object)userResponse);
                    userResponse.setShareEnabled(createdUser.isShareEnabled());
                    BeanUtils.copyProperties((Object)createdUser, (Object)user);
                    this.deviceDao.updateUserInfoInDeviceBkpOverview(cloudId, user);
                } else {
                    logger.debug("user  creation failed....");
                }
            }
            catch (BaseException e) {
                logger.trace(BASE_EXCEPTION + (Object)((Object)e));
                logger.error(BASE_EXCEPTION + e.getMessage());
                if (e.getErrorStatus() != 1200) break block5;
                throw new DataIntegrityViolationException(e.getMessage());
            }
        }
        String recoveryKeyHash = recoveryKey;
        for (int i = 0; i < 5; ++i) {
            recoveryKeyHash = MD5Generator.generateMD5OfString((String)recoveryKeyHash);
        }
        userResponse.setSecurityRecoveryKey(recoveryKeyHash);
        this.sendCreateUserMail(cloudName, currentUserName, userElement.getUserName(), userElement.getEmailId());
        return userResponse;
    }

    @Override
    public List<UserErrorReponse> createMultipleUsers(Cloud cloud, UserListElement usersListElement, String currentUserName) throws Exception {
        String cloudName = cloud.getCloudName();
        int cloudId = cloud.getCloudId();
        List userListElement = usersListElement.getUserList();
        ArrayList<UserErrorReponse> responseUserElementList = new ArrayList<UserErrorReponse>();
        UserErrorReponse errorReponse = new UserErrorReponse();
        Pattern pattern = Pattern.compile("^.+@.+\\..+$");
        Pattern userNamePattern = Pattern.compile("^[!\\._\\'A-Za-z0-9@.]{3,104}$");
        ArrayList<String> unsupportedEmailIdCharacters = new ArrayList<String>();
        unsupportedEmailIdCharacters.add("/");
        unsupportedEmailIdCharacters.add("|");
        unsupportedEmailIdCharacters.add("=");
        unsupportedEmailIdCharacters.add("+");
        unsupportedEmailIdCharacters.add("*");
        unsupportedEmailIdCharacters.add("?");
        boolean syncEnabled = false;
        boolean o365BkpEnabled = false;
        boolean backupEnabled = false;
        boolean sendSetPasswordLink = false;
        List list = cloud.getCloudCustomisableDetails();
        List users = this.userDao.getAllUsers(cloudId);
        List<Object> userNames = new ArrayList();
        List<Object> emailIds = new ArrayList();
        for (CloudCustomisableDetails customisableDetails : list) {
            if (SYNC_ENABLED.equalsIgnoreCase(customisableDetails.getName())) {
                syncEnabled = true;
            }
            if (BACKUP_ENABLED.equalsIgnoreCase(customisableDetails.getName())) {
                backupEnabled = true;
            }
            if (!"OneDrive Backup Enabled".equalsIgnoreCase(customisableDetails.getName())) continue;
            o365BkpEnabled = true;
        }
        if (!CollectionUtils.isEmpty((Collection)users)) {
            userNames = users.stream().filter(existingUser -> Objects.nonNull(existingUser.getUserName())).map(existingUser -> existingUser.getUserName()).collect(Collectors.toList());
            emailIds = users.stream().filter(existingUser -> Objects.nonNull(existingUser.getEmailId())).map(existingUser -> existingUser.getEmailId()).collect(Collectors.toList());
        }
        for (UserElement ue : userListElement) {
            User createdUser;
            block42: {
                UserElement createUserElement;
                String recoveryKey;
                User user;
                block41: {
                    Matcher matcher = pattern.matcher(ue.getEmailId());
                    Matcher userNameMatcher = userNamePattern.matcher(ue.getUserName());
                    errorReponse = new UserErrorReponse();
                    sendSetPasswordLink = false;
                    boolean skip = false;
                    if (StringUtils.isEmpty((String)ue.getUserName()) || StringUtils.isEmpty((String)ue.getEmailId())) {
                        errorReponse.setUserName(ue.getUserName());
                        errorReponse.setEmailId(ue.getEmailId());
                        errorReponse.setErrorMessage("User name / Email Id empty");
                        responseUserElementList.add(errorReponse);
                        continue;
                    }
                    if (!matcher.find()) {
                        errorReponse.setUserName(ue.getUserName());
                        errorReponse.setEmailId(ue.getEmailId());
                        errorReponse.setErrorMessage("Invalid Email Id");
                        responseUserElementList.add(errorReponse);
                        continue;
                    }
                    for (String unsupportedEmailIdCharacter : unsupportedEmailIdCharacters) {
                        if (!ue.getEmailId().contains(unsupportedEmailIdCharacter)) continue;
                        errorReponse.setUserName(ue.getUserName());
                        errorReponse.setEmailId(ue.getEmailId());
                        errorReponse.setErrorMessage("Unsupported character found in email ID");
                        responseUserElementList.add(errorReponse);
                        skip = true;
                        break;
                    }
                    if (skip) continue;
                    if (!EmailValidator.getInstance().isValid(ue.getEmailId())) {
                        errorReponse.setUserName(ue.getUserName());
                        errorReponse.setEmailId(ue.getEmailId());
                        errorReponse.setErrorMessage("Unsupported character found in email ID");
                        responseUserElementList.add(errorReponse);
                        continue;
                    }
                    if (!userNameMatcher.find()) {
                        errorReponse.setUserName(ue.getUserName());
                        errorReponse.setEmailId(ue.getEmailId());
                        errorReponse.setErrorMessage("Unsupported character found in user name");
                        responseUserElementList.add(errorReponse);
                        continue;
                    }
                    if (userNames.contains(ue.getUserName())) {
                        errorReponse.setUserName(ue.getUserName());
                        errorReponse.setEmailId(ue.getEmailId());
                        errorReponse.setErrorMessage("UserName already exist");
                        responseUserElementList.add(errorReponse);
                        continue;
                    }
                    if (emailIds.contains(ue.getEmailId())) {
                        errorReponse.setUserName(ue.getUserName());
                        errorReponse.setEmailId(ue.getEmailId());
                        errorReponse.setErrorMessage("Email Id already exist");
                        responseUserElementList.add(errorReponse);
                        continue;
                    }
                    if (emailIds.contains(ue.getUserName())) {
                        errorReponse.setUserName(ue.getUserName());
                        errorReponse.setEmailId(ue.getEmailId());
                        errorReponse.setErrorMessage("Email Id already exist");
                        responseUserElementList.add(errorReponse);
                        continue;
                    }
                    if (!StringUtils.isEmpty((String)ue.getPasswdHash()) && ue.getPasswdHash().length() < 6) {
                        errorReponse.setUserName(ue.getUserName());
                        errorReponse.setEmailId(ue.getEmailId());
                        errorReponse.setErrorMessage("Invalid password");
                        responseUserElementList.add(errorReponse);
                        continue;
                    }
                    if (backupEnabled && !StringUtils.isEmpty((String)ue.getPolicyName()) && !this.backupPolicyDao.checkIfBackupPolicyNameExists(cloudId, ue.getPolicyName())) {
                        errorReponse.setUserName(ue.getUserName());
                        errorReponse.setEmailId(ue.getEmailId());
                        errorReponse.setErrorMessage("Backup policy doesn\u2019t exist");
                        responseUserElementList.add(errorReponse);
                        continue;
                    }
                    if (syncEnabled && !StringUtils.isEmpty((String)ue.getSyncPolicyName()) && !this.syncPolicyDao.checkIfSyncPolicyNameExists(cloudId, ue.getSyncPolicyName())) {
                        errorReponse.setUserName(ue.getUserName());
                        errorReponse.setEmailId(ue.getEmailId());
                        errorReponse.setErrorMessage("Sync policy doesn\u2019t exist");
                        responseUserElementList.add(errorReponse);
                        continue;
                    }
                    if (o365BkpEnabled && !StringUtils.isEmpty((String)ue.getOdbPolicyName()) && !this.backupPolicyDao.checkIfODBBackupPolicyNameExists(cloudId, ue.getOdbPolicyName())) {
                        errorReponse.setUserName(ue.getUserName());
                        errorReponse.setEmailId(ue.getEmailId());
                        errorReponse.setErrorMessage("Office 365 policy doesn\u2019t exist");
                        responseUserElementList.add(errorReponse);
                        continue;
                    }
                    user = new User();
                    user.setMigratedBy(currentUserName);
                    user.setActive(true);
                    if (StringUtils.isEmpty((String)ue.getPasswdHash())) {
                        sendSetPasswordLink = true;
                        user.setPasswdHash("9b94cc93bf6f35792aa5c97c741303f3a66f320bfe952b9e533d1e330f91d6ee7b9f157cff0023d43474207eecd891a1cf48cf0b2285c74ff27945c72079e4e3");
                    } else {
                        String passwdHash = this.generatePassWordhash(ue.getPasswdHash());
                        user.setPasswdHash(passwdHash);
                    }
                    user.setUserName(ue.getUserName());
                    user.setEmailId(ue.getEmailId());
                    user.setBackupEnabled(backupEnabled);
                    user.setOnedriveBkpEnabled(o365BkpEnabled);
                    user.setSyncEnabled(syncEnabled);
                    if (backupEnabled) {
                        if (StringUtils.isEmpty((String)ue.getPolicyName())) {
                            user.setPolicyName(PCHelperConstant.getPropertyFileValueDefaultBkpPolicy());
                        } else {
                            user.setPolicyName(ue.getPolicyName());
                        }
                    }
                    if (syncEnabled) {
                        if (StringUtils.isEmpty((String)ue.getSyncPolicyName())) {
                            user.setSyncPolicyName(PCHelperConstant.getPropertyFileValueDefaultSyncPolicy());
                        } else {
                            user.setSyncPolicyName(ue.getSyncPolicyName());
                        }
                    }
                    if (o365BkpEnabled) {
                        if (StringUtils.isEmpty((String)ue.getOdbPolicyName())) {
                            user.setOdbPolicyName(PCHelperConstant.getPropertyFileValueDefaultO365PolicyName());
                        } else {
                            user.setOdbPolicyName(ue.getOdbPolicyName());
                        }
                    }
                    UUID uuid = UUID.randomUUID();
                    recoveryKey = String.valueOf(uuid);
                    user.setSecurityRecoveryKey(recoveryKey);
                    if (!StringUtils.isEmpty((String)ue.getDepartment())) {
                        user.setDepartment(ue.getDepartment());
                    }
                    if (!StringUtils.isEmpty((String)ue.getLocation())) {
                        user.setLocation(ue.getLocation());
                    }
                    if (!StringUtils.isEmpty((String)ue.getDisplayName())) {
                        user.setDisplayName(ue.getDisplayName());
                    }
                    if (!StringUtils.isEmpty((String)ue.getOdbLoginId())) {
                        user.setOdbLoginId(ue.getOdbLoginId());
                    }
                    user.setFirstLogin(true);
                    user.setCreatedTimestamp(String.valueOf(System.currentTimeMillis()));
                    user.setUserNameLowerCase(ue.getUserName().toLowerCase());
                    UserElement userElement = new UserElement();
                    BeanUtils.copyProperties((Object)user, (Object)userElement);
                    createUserElement = null;
                    try {
                        createUserElement = this.createUser(cloudId, cloudName, userElement, false, this.userDao);
                    }
                    catch (BaseException e) {
                        logger.trace(BASE_EXCEPTION + (Object)((Object)e));
                        logger.error(BASE_EXCEPTION + e.getMessage());
                        if (e.getErrorStatus() != 1200) break block41;
                        errorReponse.setUserName(ue.getUserName());
                        errorReponse.setEmailId(ue.getEmailId());
                        errorReponse.setErrorMessage("UserName already exist");
                        responseUserElementList.add(errorReponse);
                        continue;
                    }
                }
                if (createUserElement == null) {
                    errorReponse.setUserName(ue.getUserName());
                    errorReponse.setEmailId(ue.getEmailId());
                    errorReponse.setErrorMessage("Unable to create");
                    responseUserElementList.add(errorReponse);
                    continue;
                }
                createdUser = new User();
                BeanUtils.copyProperties((Object)createUserElement, (Object)createdUser);
                if (sendSetPasswordLink) {
                    try {
                        this.sendMail(cloudName, currentUserName, ue.getUserName(), ue.getEmailId(), recoveryKey);
                        break block42;
                    }
                    catch (Exception e) {
                        logger.debug("Exception " + e);
                        errorReponse.setUserName(ue.getUserName());
                        errorReponse.setEmailId(ue.getEmailId());
                        errorReponse.setErrorMessage("Unable to create");
                        responseUserElementList.add(errorReponse);
                        this.userDao.deleteUser(cloudId, cloudName, createdUser);
                        continue;
                    }
                }
                try {
                    this.sendCreateUserMail(cloudName, currentUserName, user.getUserName(), user.getEmailId());
                }
                catch (Exception e) {
                    logger.debug("Exception " + e);
                    errorReponse.setUserName(ue.getUserName());
                    errorReponse.setEmailId(ue.getEmailId());
                    errorReponse.setErrorMessage("Unable to create");
                    responseUserElementList.add(errorReponse);
                    this.userDao.deleteUser(cloudId, cloudName, createdUser);
                    continue;
                }
            }
            this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "created  a new user", currentUserName, createdUser.getUserName(), "Portal", System.currentTimeMillis(), PCActionTypes.USER_CREATE.getActionTypeValue());
            errorReponse.setUserName(ue.getUserName());
            errorReponse.setEmailId(ue.getEmailId());
            errorReponse.setErrorMessage("User created");
            responseUserElementList.add(errorReponse);
            if (!userNames.contains(ue.getUserName())) {
                userNames.add(ue.getUserName());
            }
            if (emailIds.contains(ue.getEmailId())) continue;
            emailIds.add(ue.getEmailId());
        }
        return responseUserElementList;
    }

    @Override
    public long countOfPresentUsers(int cloudId) {
        return this.userDao.countOfPresentUsers(cloudId, "", true);
    }

    public void sendCreateUserMail(String cloudName, String actionBy, String actionOn, String emailId) {
        if (!StringUtils.isEmpty((String)actionBy)) {
            EmailProps email = new EmailProps();
            email.setAction("create-user");
            email.setActionOn(actionOn);
            email.setActionBy(actionBy);
            email.setCloudName(cloudName);
            email.setCloudURL(PCHelperConstant.getPropertyFileValueParacloudUrl());
            EmailRecipent emailRecipent = new EmailRecipent();
            emailRecipent.setUserName(actionOn);
            emailRecipent.setEmail(emailId);
            ArrayList<EmailRecipent> recipentsList = new ArrayList<EmailRecipent>();
            recipentsList.add(emailRecipent);
            logger.debug("calling email..");
            email.setRecipents(recipentsList);
            this.cloudMailService.sendMail(email);
        }
    }

    public void sendMail(String cloudName, String currentUserName, String userName, String emailId, String recoveryKey) {
        EmailProps email = new EmailProps();
        email.setAction("new-user-first-time-password-set");
        email.setActionOn(userName);
        email.setDownloadLink(PCHelperConstant.getPropertyFileValueParacloudUrl() + "/portal/restPassword?tok=" + recoveryKey + "&user=" + userName + "&cloudname=" + cloudName + "&setpassword=true");
        email.setActionBy(currentUserName);
        email.setCloudName(cloudName);
        email.setToAdmins(false);
        email.setCloudURL(PCHelperConstant.getPropertyFileValueParacloudUrl());
        EmailRecipent emailRecipent = new EmailRecipent();
        emailRecipent.setUserName(userName);
        emailRecipent.setEmail(emailId);
        ArrayList<EmailRecipent> recipentsList = new ArrayList<EmailRecipent>();
        recipentsList.add(emailRecipent);
        logger.debug("calling email..");
        email.setRecipents(recipentsList);
        this.cloudMailService.sendMail(email);
    }

    @Override
    public void multipleUserBlockOrDeleteMail(String cloudName, int cloudId, String blockOrDeletedBy, String userName, String emailId, String action) {
        EmailProps email = new EmailProps();
        email.setAction(action);
        email.setActionOn(userName);
        email.setActionBy(blockOrDeletedBy);
        email.setCloudName(cloudName);
        email.setToAdmins(false);
        EmailRecipent emailRecipent = new EmailRecipent();
        emailRecipent.setUserName(userName);
        emailRecipent.setEmail(emailId);
        ArrayList<EmailRecipent> recipentsList = new ArrayList<EmailRecipent>();
        recipentsList.add(emailRecipent);
        logger.debug("calling email..");
        email.setRecipents(recipentsList);
        this.cloudMailService.sendMail(email);
    }

    @Override
    public List<UserElement> getAllUsers(int cloudId, String cloudName) {
        ArrayList<UserElement> userElementList = new ArrayList<UserElement>();
        List usersList = this.userDao.getAllUsers(cloudId, cloudName);
        for (User user : usersList) {
            if (user == null) continue;
            UserElement ue = new UserElement();
            BeanUtils.copyProperties((Object)user, (Object)ue);
            ue.setShareEnabled(user.isShareEnabled());
            BackupPoliciesAdminList backupPolicyList = new BackupPoliciesAdminList();
            if (user.getBackupPoliciesAdmin() != null) {
                backupPolicyList.setBackupPoliciesAdmin(user.getBackupPoliciesAdmin());
                ue.setBackupPoliciesAdminList(backupPolicyList);
            }
            SyncPoliciesAdminList syncPolicyList = new SyncPoliciesAdminList();
            if (user.getSyncPoliciesAdmin() != null) {
                syncPolicyList.setSyncPoliciesAdmin(user.getSyncPoliciesAdmin());
                ue.setSyncPoliciesAdminList(syncPolicyList);
            }
            userElementList.add(ue);
        }
        return userElementList;
    }

    @Override
    public UserElement getUserInfo(int cloudId, String cloudName, String userName) {
        ArrayList<MiniCloudElement> cloudElements = new ArrayList<MiniCloudElement>();
        UserElement usrElement = new UserElement();
        User user = this.userDao.getUserInfoByName(cloudId, cloudName, userName);
        if (user != null) {
            logger.debug(userName + "&&@@@$$$$$$@@..sync disabled.....");
            List ucacList = this.userMiniCloudMappingDao.getAccessControlMappingsByUser(cloudId, cloudName, user.getUserId());
            if (!CollectionUtils.isEmpty((Collection)ucacList)) {
                for (UserCloudAccessControl ucac : ucacList) {
                    MiniCloudElement cloudElement = new MiniCloudElement();
                    MiniCloud cloud = this.miniCloudDao.getMiniCloudByID(cloudId, cloudName, ucac.getMiniCloudFK());
                    if (cloud == null) continue;
                    BeanUtils.copyProperties((Object)cloud, (Object)cloudElement);
                    cloudElements.add(cloudElement);
                }
            }
            if (StringUtils.isEmpty((String)user.getLastModifiedTimestamp())) {
                usrElement.setLastModifiedTimestamp(user.getCreatedTimestamp());
            }
            MiniCloudElementList miniCloudElementList = new MiniCloudElementList();
            miniCloudElementList.setMiniClouds(cloudElements);
            usrElement.setMiniCloudElementList(miniCloudElementList);
            BeanUtils.copyProperties((Object)user, (Object)usrElement);
            usrElement.setShareEnabled(user.isShareEnabled());
            PciAuthorizationTokens authorizationTokens = this.pciAuthorizationTokensDao.getPciAuthorizationTokensForUserId(cloudId, cloudName, user.getUserId());
            if (authorizationTokens != null) {
                usrElement.setExternalStorageAuthorized(true);
            } else {
                usrElement.setExternalStorageAuthorized(false);
            }
            logger.debug(".....policy name.... " + usrElement.getPolicyName() + "...sync..." + usrElement.getSyncPolicyName());
            if (StringUtils.isEmpty((String)usrElement.getPolicyName()) && StringUtils.isEmpty((String)usrElement.getSyncPolicyName())) {
                usrElement.setSyncPolicyName(usrElement.getSyncPolicyName());
                usrElement.setPolicyName(usrElement.getPolicyName());
            }
        } else {
            throw new EmptyResultDataAccessException(1);
        }
        return usrElement;
    }

    @Override
    public UserElement getUserInfoLatest(Cloud cloud, String userName) {
        ArrayList<MiniCloudElement> cloudElements = new ArrayList<MiniCloudElement>();
        UserElement usrElement = new UserElement();
        int cloudId = cloud.getCloudId();
        String cloudName = cloud.getCloudName();
        User user = this.userDao.getUserInfoByName(cloudId, cloudName, userName);
        List list = cloud.getCloudCustomisableDetails();
        list.removeAll(Collections.singleton(null));
        boolean isCloudLevelSyncEnabled = this.isCloudLevelSyncEnabled(list);
        if (user != null) {
            List ucacList;
            if (user.isReadOnlyAdmin()) {
                BackupPoliciesAdminList backupPolicyAdminList = new BackupPoliciesAdminList();
                backupPolicyAdminList.setBackupPoliciesAdmin(user.getBackupPoliciesAdmin());
                usrElement.setBackupPoliciesAdminList(backupPolicyAdminList);
                SyncPoliciesAdminList syncPolicyAdminList = new SyncPoliciesAdminList();
                syncPolicyAdminList.setSyncPoliciesAdmin(user.getSyncPoliciesAdmin());
                usrElement.setSyncPoliciesAdminList(syncPolicyAdminList);
            }
            logger.debug(userName + "&&@@@$$$$$$@@..sync ....." + isCloudLevelSyncEnabled);
            if (isCloudLevelSyncEnabled && !CollectionUtils.isEmpty((Collection)(ucacList = this.userMiniCloudMappingDao.getAccessControlMappingsByUser(cloudId, cloudName, user.getUserId())))) {
                for (UserCloudAccessControl ucac : ucacList) {
                    MiniCloudElement cloudElement = new MiniCloudElement();
                    MiniCloud mc = this.miniCloudDao.getMiniCloudByID(cloudId, cloudName, ucac.getMiniCloudFK());
                    if (mc == null) continue;
                    BeanUtils.copyProperties((Object)mc, (Object)cloudElement);
                    cloudElements.add(cloudElement);
                }
            }
            if (StringUtils.isEmpty((String)user.getLastModifiedTimestamp())) {
                usrElement.setLastModifiedTimestamp(user.getCreatedTimestamp());
            }
            MiniCloudElementList miniCloudElementList = new MiniCloudElementList();
            miniCloudElementList.setMiniClouds(cloudElements);
            usrElement.setMiniCloudElementList(miniCloudElementList);
            BeanUtils.copyProperties((Object)user, (Object)usrElement);
            usrElement.setShareEnabled(user.isShareEnabled());
            PciAuthorizationTokens authorizationTokens = this.pciAuthorizationTokensDao.getPciAuthorizationTokensForUserId(cloudId, cloudName, user.getUserId());
            if (authorizationTokens != null) {
                usrElement.setExternalStorageAuthorized(true);
            } else {
                usrElement.setExternalStorageAuthorized(false);
            }
        } else {
            throw new EmptyResultDataAccessException(1);
        }
        logger.debug(".....policy name.... " + usrElement.getPolicyName() + "...sync..." + usrElement.getSyncPolicyName());
        usrElement.setSyncPolicyName(user.getSyncPolicyName());
        usrElement.setPolicyName(user.getPolicyName());
        return usrElement;
    }

    private boolean isCloudLevelSyncEnabled(List<CloudCustomisableDetails> list) {
        for (CloudCustomisableDetails customisableDetails : list) {
            if (!SYNC_ENABLED.equalsIgnoreCase(customisableDetails.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public UserElement getUserByUserNameOrEmail(Cloud cloud, String userName) {
        ArrayList<MiniCloudElement> cloudElements = new ArrayList<MiniCloudElement>();
        int cloudId = cloud.getCloudId();
        String cloudName = cloud.getCloudName();
        UserElement usrElement = new UserElement();
        logger.debug("........userName......." + userName);
        User user = this.userDao.getUserByUserNameOrEmail(cloud.getCloudId(), userName);
        if (user == null && this.isAADEnabled(cloud.getCloudCustomisableDetails())) {
            user = this.userDao.getUserByUserNameOrAADLoginId(cloudId, userName);
        }
        if (user != null) {
            SyncPolicyElement syncPolicyElement;
            BackupPolicyElement backupPolicyElement;
            logger.debug("USer not null :" + user.getUserName());
            List ucacList = this.userMiniCloudMappingDao.getAccessControlMappingsByUser(cloudId, cloud.getCloudName(), user.getUserId());
            if (!CollectionUtils.isEmpty((Collection)ucacList)) {
                for (UserCloudAccessControl ucac : ucacList) {
                    MiniCloudElement cloudElement = new MiniCloudElement();
                    if (cloud == null) continue;
                    BeanUtils.copyProperties((Object)cloud, (Object)cloudElement);
                    cloudElements.add(cloudElement);
                }
            }
            logger.debug(".....loading policy.......");
            if (StringUtils.isEmpty((String)user.getLastModifiedTimestamp())) {
                usrElement.setLastModifiedTimestamp(user.getCreatedTimestamp());
            }
            MiniCloudElementList miniCloudElementList = new MiniCloudElementList();
            miniCloudElementList.setMiniClouds(cloudElements);
            usrElement.setMiniCloudElementList(miniCloudElementList);
            BeanUtils.copyProperties((Object)user, (Object)usrElement);
            usrElement.setShareEnabled(user.isShareEnabled());
            PciAuthorizationTokens authorizationTokens = this.pciAuthorizationTokensDao.getPciAuthorizationTokensForUserId(cloudId, cloudName, user.getUserId());
            logger.debug(".....loading policy.......");
            if (!StringUtils.isEmpty((String)usrElement.getPolicyName()) && (backupPolicyElement = this.getBackupPolicyElement(cloudId, this.backupPolicyDao.getBackupPolicy(cloudId, cloudName, user.getPolicyName()))) != null) {
                usrElement.setBackupPolicyElement(this.getBackupPolicyElement(cloudId, this.backupPolicyDao.getBackupPolicy(cloudId, cloudName, user.getPolicyName())));
            }
            if (!StringUtils.isEmpty((String)usrElement.getSyncPolicyName()) && (syncPolicyElement = this.getSyncPolicyElement(cloudId, this.syncPolicyDao.getSyncPolicy(cloudId, cloudName, user.getSyncPolicyName()))) != null) {
                usrElement.setSyncPolicyElement(this.getSyncPolicyElement(cloudId, this.syncPolicyDao.getSyncPolicy(cloudId, cloudName, user.getSyncPolicyName())));
            }
            if (user.isReadOnlyAdmin()) {
                BackupPoliciesAdminList backupPolicyAdminList = new BackupPoliciesAdminList();
                backupPolicyAdminList.setBackupPoliciesAdmin(user.getBackupPoliciesAdmin());
                usrElement.setBackupPoliciesAdminList(backupPolicyAdminList);
                SyncPoliciesAdminList syncPolicyAdminList = new SyncPoliciesAdminList();
                syncPolicyAdminList.setSyncPoliciesAdmin(user.getSyncPoliciesAdmin());
                usrElement.setSyncPoliciesAdminList(syncPolicyAdminList);
            }
            if (authorizationTokens != null) {
                usrElement.setExternalStorageAuthorized(true);
            } else {
                usrElement.setExternalStorageAuthorized(false);
            }
        } else {
            logger.debug("....user is null......." + userName);
            return null;
        }
        logger.debug(".....loading getUserByUserNameOrEmail.......");
        return usrElement;
    }

    private BackupPolicyElement getBackupPolicyElement(int cloudId, BackupPolicy backupPolicy) {
        BackupPolicyElement element = null;
        ArrayList<String> folderPaths = new ArrayList<String>();
        ArrayList<String> scheduleNames = new ArrayList<String>();
        ArrayList<String> networkThrottlingNames = new ArrayList<String>();
        ArrayList calloutScriptStrs = new ArrayList();
        if (backupPolicy == null) {
            return null;
        }
        for (Schedule schedule : backupPolicy.getSchedules()) {
            scheduleNames.add(schedule.getScheduleName());
        }
        for (NetworkThrottling networkThrottling : backupPolicy.getNetworkThrottlings()) {
            networkThrottlingNames.add(networkThrottling.getNetworkThrottlingName());
        }
        for (BackupFolders backupFolder : backupPolicy.getBackupFolders()) {
            BackupFolderElement backupFolderElement = new BackupFolderElement();
            if (backupFolder == null) continue;
            backupFolderElement.setFolderPath(backupFolder.getFolderPath());
            backupFolderElement.setOsType(backupFolder.getOs());
            folderPaths.add(backupFolder.getFolderPath());
        }
        if (backupPolicy != null) {
            element = new BackupPolicyElement();
            BeanUtils.copyProperties((Object)backupPolicy, (Object)element);
            element.setPolicygroupName(backupPolicy.getPolicyName());
            element.setExceptionsToExclusions(new ArrayList());
            element.setBackupFolderPaths(new ArrayList());
            element.getBackupFolderPaths().addAll(folderPaths);
            if (element.getNwFromClientToPGMB() <= 0.0) {
                element.setNwFromClientToPGMB((double)element.getNwFromClientToPG().longValue());
            }
            element.setCalloutScripts(calloutScriptStrs);
            InclusionFilter inclusionFilter = backupPolicy.getInclusionFilter();
            if (inclusionFilter != null) {
                element.setFilterInclusionName(inclusionFilter.getFilterName());
            }
            element.setNetworkThrottlingNames(new ArrayList());
            element.setScheduleNames(new ArrayList());
            element.getNetworkThrottlingNames().addAll(networkThrottlingNames);
            element.getScheduleNames().addAll(scheduleNames);
            element.setEndpointUiPreferences((List)backupPolicy.getEndpointUiPreferences());
            element.setEndpointDisabledUiPreferences(backupPolicy.getEndpointDisabledUiPreferences());
            ArrayList list = backupPolicy.getPrivacyGateways();
            PrivacyGatewayMappingElement mappingElement = new PrivacyGatewayMappingElement();
            ArrayList<String> pgList = new ArrayList<String>();
            for (PrivacyGateway privacyGateway : list) {
                if (privacyGateway == null) continue;
                mappingElement.setGatewayNwThrottlingName("PGThrottle-name");
                pgList.add(privacyGateway.getGatewayName());
            }
            mappingElement.setPrivacyGatewayNames(new ArrayList());
            mappingElement.setPrivacyGatewayNames(pgList);
            element.setPrivacyGatewayMappingElement(mappingElement);
            element.setSearchAlgoForPg(backupPolicy.getSearchAlgoForPg());
            if (backupPolicy.getCloudCredentials() != null) {
                element.setCloudCredential(backupPolicy.getCloudCredentials().getIdentity());
            }
        }
        logger.debug(".....loading policy.......");
        return element;
    }

    public SyncPolicyElement getSyncPolicyElement(int cloudId, SyncPolicy syncPolicy) {
        ArrayList<String> netWorkThrottlingNames = new ArrayList<String>();
        if (syncPolicy == null) {
            return null;
        }
        for (NetworkThrottling netWorkThrottling : syncPolicy.getNetworkThrottlings()) {
            netWorkThrottlingNames.add(netWorkThrottling.getNetworkThrottlingName());
        }
        SyncPolicyElement element = new SyncPolicyElement();
        BeanUtils.copyProperties((Object)syncPolicy, (Object)element);
        element.setPolicygroupName(syncPolicy.getPolicyName());
        element.setNetworkThrottlingNames(new ArrayList());
        element.getNetworkThrottlingNames().addAll(netWorkThrottlingNames);
        ArrayList list = syncPolicy.getPrivacyGateways();
        PrivacyGatewayMappingElement mappingElement = new PrivacyGatewayMappingElement();
        if (element.getNwFromClientToPGMB() <= 0.0) {
            element.setNwFromClientToPGMB((double)element.getNwFromClientToPG().longValue());
        }
        if (!CollectionUtils.isEmpty((Collection)list)) {
            ArrayList<String> pgList = new ArrayList<String>();
            for (PrivacyGateway privacyGateway : list) {
                if (privacyGateway == null) continue;
                mappingElement.setGatewayNwThrottlingName("PGThrottle-name");
                pgList.add(privacyGateway.getGatewayName());
            }
            mappingElement.setPrivacyGatewayNames(new ArrayList());
            mappingElement.setPrivacyGatewayNames(pgList);
            element.setPrivacyGatewayMappingElement(mappingElement);
        } else {
            element.setPrivacyGatewayMappingElement(mappingElement);
        }
        if (syncPolicy.getCloudCredentials() != null) {
            element.setCloudCredential(syncPolicy.getCloudCredentials().getIdentity());
        }
        element.setSearchAlgoForPg(syncPolicy.getSearchAlgoForPg());
        element.setEndpointUiPreferences((List)syncPolicy.getEndpointUiPreferences());
        element.setEndpointDisabledUiPreferences(syncPolicy.getEndpointDisabledUiPreferences());
        return element;
    }

    @Override
    public UserElement updateUserInfo(int cloudId, String cloudName, UserElement userElement) {
        SyncPoliciesAdminList syncPolicyAdminList;
        BackupPolicy bkpPolicy;
        UserElement usrResponse = new UserElement();
        User user = this.userDao.getUserInfoByName(cloudId, cloudName, userElement.getUserName());
        ObjectId userId = user.getUserId();
        BeanUtils.copyProperties((Object)userElement, (Object)user);
        user.setShareEnabled(userElement.isShareEnabled());
        user.setServerBackupEnabled(userElement.isServerBackupEnabled());
        user.setUserId(userId);
        user.setLastModifiedTimestamp(String.valueOf(System.currentTimeMillis()));
        if (StringUtils.isNotEmpty((String)user.getPolicyName()) && (bkpPolicy = this.userDao.getBackupPolicyByPolicyName(cloudId, user.getPolicyName())) != null && bkpPolicy.isLegalHoldEnabled()) {
            user.setAdmin(false);
        }
        logger.debug(" @@@@@@@@@@@@@@@ before updated USER .... " + userId);
        BackupPoliciesAdminList backupPolicyAdminList = userElement.getBackupPoliciesAdminList();
        if (backupPolicyAdminList != null) {
            List backupPoliciesAdmin = backupPolicyAdminList.getBackupPoliciesAdmin();
            user.setBackupPoliciesAdmin(backupPoliciesAdmin);
        }
        if ((syncPolicyAdminList = userElement.getSyncPoliciesAdminList()) != null) {
            List syncPoliciesAdmin = syncPolicyAdminList.getSyncPoliciesAdmin();
            user.setSyncPoliciesAdmin(syncPoliciesAdmin);
        }
        user.setPolicyModifiedTime(System.currentTimeMillis());
        User updatedUser = this.userDao.updateUser(cloudId, cloudName, user);
        this.deviceDao.updateUserInfoInDeviceBkpOverview(cloudId, updatedUser);
        logger.debug(" @@@@@@@@@@@@@@@ updated USER .... " + updatedUser);
        if (updatedUser != null) {
            List ucacList = this.userMiniCloudMappingDao.getAccessControlMappingsByUser(cloudId, cloudName, updatedUser.getUserId());
            logger.debug("mapping found: " + ucacList.size());
            for (UserCloudAccessControl userCloudAccessControl : ucacList) {
            }
            MiniCloudElementList cloudElementLists = userElement.getMiniCloudElementList();
            List cloudElements = cloudElementLists.getMiniClouds();
            for (MiniCloudElement cloudElement : cloudElements) {
                MiniCloud miniCloud;
                if (StringUtils.isEmpty((String)cloudElement.getMiniCloudName()) || (miniCloud = this.miniCloudDao.getMiniCloudByName(cloudId, cloudName, cloudElement.getMiniCloudName())) == null) continue;
                UserCloudAccessControl accessControl = new UserCloudAccessControl();
                accessControl.setMiniCloudFK(miniCloud.getId());
                accessControl.setUserFK(updatedUser.getUserId());
                this.userMiniCloudMappingDao.saveMiniCloud(cloudId, cloudName, accessControl);
            }
            BeanUtils.copyProperties((Object)updatedUser, (Object)usrResponse);
            usrResponse.setShareEnabled(updatedUser.isShareEnabled());
            usrResponse.setMiniCloudElementList(cloudElementLists);
        }
        return usrResponse;
    }

    @Override
    public UserElement deleteUser(int cloudId, String cloudName, String userId) {
        UserElement usrResponse = new UserElement();
        User user = this.userDao.getUserInfo(cloudId, userId);
        if (user == null) {
            throw new BaseException(USER_NOT_FOUND);
        }
        List ucacList = this.userMiniCloudMappingDao.getAccessControlMappingsByUser(cloudId, cloudName, user.getUserId());
        logger.debug("mapping found: " + ucacList.size());
        for (UserCloudAccessControl ucac : ucacList) {
            this.userMiniCloudMappingDao.deleteUserCloudAccessControlMapping(cloudId, cloudName, ucac);
        }
        this.deviceDao.deleteAllDeviceByUser(cloudId, cloudName, user);
        this.deviceDao.deleteAllDeviceBkpoverviewByUser(cloudId, user);
        this.authorizationDao.deleteAllTokensForUser(cloudId, cloudName, user);
        BeanUtils.copyProperties((Object)user, (Object)usrResponse);
        usrResponse.setShareEnabled(user.isShareEnabled());
        this.userDao.deleteUser(cloudId, cloudName, user);
        return usrResponse;
    }

    @Override
    public List<Device> blockUnblockDevicebyUserName(int cloudId, String cloudName, String userName, boolean toBlock) {
        List devices = new ArrayList();
        ArrayList<Device> blockedDevice = new ArrayList<Device>();
        devices = this.deviceDao.getDeviceByUserName(cloudId, userName);
        if (!CollectionUtils.isEmpty(devices)) {
            for (Device device : devices) {
                if (device.isBlocked()) continue;
                this.deviceDao.blockUnblockDevice(cloudId, cloudName, device, toBlock);
                this.deviceDao.updateDeviceStatusInOverview(cloudId, device.getDeviceUUID(), toBlock);
                if (toBlock) {
                    User user = this.userDao.getUserByName(cloudId, device.getUserName());
                    this.authorizationDao.deleteAuthTokenByUserAndUniqueID(cloudId, user, device.getDeviceUUID());
                }
                blockedDevice.add(device);
            }
        }
        return blockedDevice;
    }

    @Override
    public User authenticate(int cloudId, String cloudName, String username, String passowrd) {
        User user = this.userDao.getUserInfoByName(cloudId, cloudName, username);
        if (user == null) {
            throw new BaseException(USER_NOT_FOUND, 401);
        }
        if (StringUtils.isEmpty((String)user.getPasswdHash()) || !user.getPasswdHash().equals(passowrd)) {
            throw new BaseException("Bad Credentials.", 401);
        }
        if (!user.isActive()) {
            throw new BaseException("User is not active", 403);
        }
        return user;
    }

    @Override
    public User authenticateV2(int cloudId, String cloudName, String username) {
        User user = this.userDao.getUserInfoByName(cloudId, cloudName, username);
        if (user == null) {
            throw new BaseException(USER_NOT_FOUND, 401);
        }
        if (!user.isActive()) {
            throw new BaseException("User is not active", 403);
        }
        return user;
    }

    @Override
    public void verifyRecoveryKey(int cloudId, String cloudName, String userName, String key) {
        User user = this.userDao.getUserInfoByName(cloudId, cloudName, userName);
        if (user == null) {
            throw new BaseException(USER_NOT_FOUND);
        }
        String recoveryKey = user.getSecurityRecoveryKey();
        for (int i = 0; i < 5; ++i) {
            recoveryKey = MD5Generator.generateMD5OfString((String)recoveryKey);
        }
        if (recoveryKey.equals(key)) {
            return;
        }
        throw new BaseException("Bad Credentials.");
    }

    @Override
    public User updateUserInfo(int cloudId, String cloudName, User user) {
        this.deviceDao.updateUserInfoInDeviceBkpOverview(cloudId, user);
        return this.userDao.updateUser(cloudId, cloudName, user);
    }

    @Override
    public UserElement validateRecoveryParams(int cloudId, String cloudName, UserElement userElement) {
        String userName = userElement.getUserName();
        String email = userElement.getEmailId();
        User user = this.userDao.getUserInfoByName(cloudId, cloudName, userName);
        if (user != null && userName.equalsIgnoreCase(user.getUserName()) && email.equalsIgnoreCase(user.getEmailId()) && user.isActive()) {
            BeanUtils.copyProperties((Object)user, (Object)userElement);
            userElement.setShareEnabled(user.isShareEnabled());
            return userElement;
        }
        return null;
    }

    @Override
    public User getUserDetails(int cloudId, String cloudName, String userName) {
        return this.userDao.getUserInfoByName(cloudId, cloudName, userName);
    }

    @Override
    public List<User> getAllActiveUsers(int cloudId) {
        return this.userDao.getAllActiveUsers(cloudId);
    }

    @Override
    public List<User> getAllUsersDetails(int cloudId, String cloudName) {
        return this.userDao.getAllUsers(cloudId, cloudName);
    }

    @Override
    public List<User> getAllAdmins(int cloudId, String cloudName) {
        return this.userDao.getAllAdmins(cloudId, cloudName);
    }

    @Override
    public UserElement createUser(int cloudId, String cloudName, User user) {
        UserElement userResponse = new UserElement();
        UUID uuid = UUID.randomUUID();
        String recoveryKey = String.valueOf(uuid);
        user.setSecurityRecoveryKey(recoveryKey);
        user.setActive(true);
        user.setFirstLogin(true);
        user.setUserNameLowerCase(user.getUserName().toLowerCase());
        user.setCreatedTimestamp(String.valueOf(System.currentTimeMillis()));
        UserElement userElement = new UserElement();
        BeanUtils.copyProperties((Object)user, (Object)userElement);
        UserElement createduserElement = this.createUser(cloudId, cloudName, userElement, false, this.userDao);
        if (createduserElement != null) {
            logger.debug(user.isShareEnabled() + "&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&" + createduserElement.isShareEnabled());
            userResponse.setShareEnabled(createduserElement.isShareEnabled());
            BeanUtils.copyProperties((Object)createduserElement, (Object)userResponse);
        }
        String recoveryKeyHash = recoveryKey;
        for (int i = 0; i < 5; ++i) {
            recoveryKeyHash = MD5Generator.generateMD5OfString((String)recoveryKeyHash);
        }
        userResponse.setSecurityRecoveryKey(recoveryKeyHash);
        return userResponse;
    }

    @Override
    public boolean createUserFromLdap(int cloudId, String cloudName, LdapUserElement ldapUserElement, String migratedBy, boolean isSyncEnabled, boolean isBackupEnabled, boolean iso365BkpEnabled) throws Exception {
        boolean userMigrated = false;
        try {
            User user = new User();
            UUID uuid = UUID.randomUUID();
            String recoveryKey = String.valueOf(uuid);
            user.setSecurityRecoveryKey(recoveryKey);
            user.setActive(true);
            user.setAdmin(false);
            user.setBackupEnabled(isBackupEnabled);
            user.setSyncEnabled(isSyncEnabled);
            user.setOnedriveBkpEnabled(iso365BkpEnabled);
            user.setFirstLogin(true);
            user.setShareEnabled(true);
            user.setUserName(ldapUserElement.getUserName());
            user.setEmailId(ldapUserElement.getEmailId());
            user.setCreatedTimestamp(String.valueOf(System.currentTimeMillis()));
            user.setDisplayName(ldapUserElement.getDisplayName());
            user.setMigratedBy(migratedBy);
            user.setlocalUser(false);
            user.setLocation(ldapUserElement.getLocation());
            user.setDepartment(ldapUserElement.getDepartment());
            user.setAccountStatus(ldapUserElement.isAccountStatus());
            user.setUserNameLowerCase(ldapUserElement.getUserName().toLowerCase());
            if (!StringUtils.isEmpty((String)ldapUserElement.getDefaultPolicy())) {
                user.setPolicyName(ldapUserElement.getDefaultPolicy());
            }
            if (!StringUtils.isEmpty((String)ldapUserElement.getDefaultSyncPolicy())) {
                user.setSyncPolicyName(ldapUserElement.getDefaultSyncPolicy());
            }
            if (!StringUtils.isEmpty((String)ldapUserElement.getDefaultO365Policy())) {
                user.setOdbPolicyName(ldapUserElement.getDefaultO365Policy());
            }
            UserElement userElement = new UserElement();
            BeanUtils.copyProperties((Object)user, (Object)userElement);
            UserElement createduserElement = this.createUser(cloudId, cloudName, userElement, false, this.userDao);
            if (createduserElement != null) {
                userMigrated = true;
                MigrationStatus migrationStatus = new MigrationStatus();
                migrationStatus.setMigratedBy(migratedBy);
                migrationStatus.setMigratededTimestamp(System.currentTimeMillis());
                migrationStatus.setMigrated(true);
                migrationStatus.setUserName(user.getUserName());
                migrationStatus.setEmailId(user.getEmailId());
                this.migrationStatusDao.saveMigrationStatus(cloudId, migrationStatus);
            }
        }
        catch (Exception e) {
            logger.error(EXCEPTION + e);
            logger.debug(EXCEPTION + e.getMessage());
            throw new Exception(e);
        }
        return userMigrated;
    }

    @Override
    public List<User> getAllShareEnabledActiveUsers(int cloudId, String cloudName) {
        return this.userDao.getAllShareEnabledActiveUsers(cloudId, cloudName);
    }

    @Override
    public void saveFailedLogin(int cloudId, String cloudName, FailedLogin failedLogin) {
        this.userDao.saveFailedLogin(cloudId, cloudName, failedLogin);
    }

    @Override
    public User getUserInfoById(int cloudId, String cloudName, String userId) {
        return this.userDao.getUserInfo(cloudId, userId);
    }

    @Override
    public List<UserElement> searchUsers(int cloudId, String userName) {
        ArrayList<UserElement> userElementList = new ArrayList<UserElement>();
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(userName.split(",")));
        HashSet<String> removeSet = new HashSet<String>();
        removeSet.addAll(list);
        list.clear();
        list.addAll(removeSet);
        List users = this.userDao.searchUsers(cloudId, list);
        for (User user : users) {
            if (user == null) continue;
            UserElement ue = new UserElement();
            BeanUtils.copyProperties((Object)user, (Object)ue);
            ue.setShareEnabled(user.isShareEnabled());
            userElementList.add(ue);
        }
        return userElementList;
    }

    @Override
    public List<UserElement> searchUserbyUsernameOrDisplaynameOrEmailId(int cloudId, String userName) {
        ArrayList<UserElement> userElementList = new ArrayList<UserElement>();
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(userName.split(",")));
        HashSet<String> removeSet = new HashSet<String>();
        removeSet.addAll(list);
        list.clear();
        list.addAll(removeSet);
        List users = this.userDao.searchUserbyUsernameOrDisplaynameOrEmailId(cloudId, list);
        for (User user : users) {
            if (user == null) continue;
            UserElement ue = new UserElement();
            BeanUtils.copyProperties((Object)user, (Object)ue);
            ue.setShareEnabled(user.isShareEnabled());
            BackupPoliciesAdminList backupPolicyList = new BackupPoliciesAdminList();
            if (user.getBackupPoliciesAdmin() != null) {
                backupPolicyList.setBackupPoliciesAdmin(user.getBackupPoliciesAdmin());
                ue.setBackupPoliciesAdminList(backupPolicyList);
            }
            SyncPoliciesAdminList syncPolicyList = new SyncPoliciesAdminList();
            if (user.getSyncPoliciesAdmin() != null) {
                syncPolicyList.setSyncPoliciesAdmin(user.getSyncPoliciesAdmin());
                ue.setSyncPoliciesAdminList(syncPolicyList);
            }
            userElementList.add(ue);
        }
        return userElementList;
    }

    @Override
    public List<UserElement> getAllUsers(int cloudId, int skipValue) {
        ArrayList<UserElement> userElementList = new ArrayList<UserElement>();
        List usersList = this.userDao.getAllUsers(cloudId, "", skipValue);
        logger.debug(" user names list ... " + usersList.size());
        for (User user : usersList) {
            logger.debug(" user names ... " + user.getUserName());
            UserElement ue = new UserElement();
            BeanUtils.copyProperties((Object)user, (Object)ue);
            ue.setShareEnabled(user.isShareEnabled());
            userElementList.add(ue);
        }
        return userElementList;
    }

    @Override
    public void markUserAsDelete(int cloudId, String cloudName, String userName, String deletedBy) {
        User user = this.userDao.getUserInfoByName(cloudId, cloudName, userName);
        if (user == null) {
            throw new BaseException(USER_NOT_FOUND);
        }
        this.userMiniCloudMappingDao.deleteUserCloudAccessControlMappingWithUserFK(cloudId, cloudName, user.getUserId());
        this.deviceDao.markAllDevicesAsDeletedForUser(cloudId, cloudName, user);
        this.authorizationDao.deleteAllTokensForUser(cloudId, cloudName, user);
        user.setDeleted(true);
        this.userDao.updateUser(cloudId, cloudName, user);
        this.deviceDao.markUserAndDeviceAsDeleteInDeviceBkpOverview(cloudId, user);
        this.saveDeletedUser(cloudId, cloudName, userName, user);
        this.multipleUserBlockOrDeleteMail(cloudName, cloudId, deletedBy, user.getUserName(), user.getEmailId(), "user-delete");
    }

    public void saveDeletedUser(int cloudId, String cloudName, String userName, User user) {
        logger.debug("saving deleted user on database");
        DeletedUser deletedUser = new DeletedUser();
        ArrayList<String> deviceUUIDs = new ArrayList<String>();
        List allDevicesForUser = this.deviceDao.getAllDevicesByUser(cloudId, user);
        if (allDevicesForUser != null) {
            for (Device device : allDevicesForUser) {
                if (device == null || device.getDeviceUUID() == null) continue;
                deviceUUIDs.add(device.getDeviceUUID());
            }
        }
        deletedUser.setUserName(userName);
        deletedUser.setLastModifiedTimestamp(String.valueOf(System.currentTimeMillis()));
        deletedUser.setDeviceUUIDs(deviceUUIDs);
        deletedUser.setUserId(user.getUserId());
        this.deletedUserDao.saveDeletedUser(cloudId, cloudName, deletedUser);
        logger.debug("saved deleted user on database");
    }

    @Override
    public List<DeletedUser> getAllDeletedUsers(int cloudId, String cloudName) {
        return this.deletedUserDao.getAllDeletedUsers(cloudId, cloudName);
    }

    @Override
    public List<User> getAllDeletedUsers(int cloudId) {
        return this.userDao.getAllDeletedUsers(cloudId);
    }

    @Override
    public List<UserElement> getAllDeletedUsersById(int cloudId, String cloudName, List<ObjectId> userIds) {
        ArrayList<UserElement> userElementList = new ArrayList<UserElement>();
        List usersList = this.userDao.getAllDeletedUsersById(cloudId, cloudName, userIds);
        for (User user : usersList) {
            UserElement ue = new UserElement();
            BeanUtils.copyProperties((Object)user, (Object)ue);
            ue.setShareEnabled(user.isShareEnabled());
            userElementList.add(ue);
        }
        return userElementList;
    }

    public void setDeletedUserDao(DeletedUserDao deletedUserDao) {
        this.deletedUserDao = deletedUserDao;
    }

    @Override
    public boolean isUserUnderLegalHold(int cloudId, String userId) {
        User user = this.userDao.getUserInfo(cloudId, userId);
        BackupPolicy backupPolicy = this.userDao.getBackupPolicyByPolicyName(cloudId, user.getPolicyName());
        return backupPolicy != null && backupPolicy.isLegalHoldEnabled();
    }

    @Override
    public boolean isUserUnderLegalHoldForUserName(int cloudId, String userName) {
        boolean userUnderLegalHold = false;
        User user = this.userDao.getUserByName(cloudId, userName);
        BackupPolicy backupPolicy = this.userDao.getBackupPolicyByPolicyName(cloudId, user.getPolicyName());
        if (backupPolicy != null && backupPolicy.isLegalHoldEnabled()) {
            logger.debug("User cannot be admin He/She is under legal hold .......");
            userUnderLegalHold = true;
        }
        return userUnderLegalHold;
    }

    @Override
    public List<UserElement> getAllLegalHoldUsers(int cloudId, String cloudName) {
        List legalHoldPolicies = this.backupPolicyDao.getAllLegalHoldBackupPolicies(cloudId, cloudName);
        ArrayList<UserElement> legalHoldUserElements = new ArrayList<UserElement>();
        for (BackupPolicy backupPolicy : legalHoldPolicies) {
            List userList = this.userDao.getUsersByBackupPolicyName(cloudId, backupPolicy.getPolicyName());
            for (User user : userList) {
                UserElement element = new UserElement();
                if (user == null) continue;
                BeanUtils.copyProperties((Object)user, (Object)element);
                legalHoldUserElements.add(element);
            }
        }
        return legalHoldUserElements;
    }

    @Override
    public boolean isUserOwnerOfAnyMiniCloud(int cloudId, String userName) {
        List list = this.miniCloudDao.getAllMiniCloudForUser(cloudId, userName);
        return !CollectionUtils.isEmpty((Collection)list);
    }

    @Override
    public boolean checkIfEmailAlreadyExists(int cloudId, String emailId) {
        return this.userDao.checkIfEmailAlreadyExists(cloudId, emailId);
    }

    @Override
    public List<User> getAllUsersForNames(int cloudId, List<String> usersNames) {
        return this.userDao.getAllUsersForNames(cloudId, usersNames);
    }

    @Override
    public Group getGroupByName(int cloudId, String groupName) {
        return this.userGroupDao.getGroupByName(cloudId, groupName);
    }

    @Override
    public List<UserGroup> getAllUsersForGroup(int cloudId, String groupName, String groupId) {
        return this.userGroupDao.getAllUsersForGroup(cloudId, null, groupId);
    }

    @Override
    public void saveGroup(int cloudId, List<String> list, String groupName) {
        Group group = this.getGroupByName(cloudId, groupName);
        if (group == null) {
            group = new Group();
            group.setGroupName(groupName);
            this.userGroupDao.saveGroup(cloudId, group, list);
        }
    }

    @Override
    public List<Group> getAllGroups(int cloudId) {
        return this.userGroupDao.getAllGroups(cloudId);
    }

    @Override
    public UserGroupElement getGroupElement(int cloudId, String groupName) {
        UserGroupElement groupElement = new UserGroupElement();
        Group group = this.userGroupDao.getGroupByName(cloudId, groupName);
        StringBuilder userNames = new StringBuilder("");
        if (group != null) {
            groupElement.setGroupName(group.getGroupName());
            List<UserGroup> allUserGroups = this.getAllUsersForGroup(cloudId, null, group.getId().toString());
            for (UserGroup userGroup : allUserGroups) {
                userNames.append(userGroup.getUser().getUserName() + ",");
            }
            if (userNames.length() > 0) {
                userNames.append(userNames.substring(0, userNames.length() - 1));
                groupElement.setAssignedUsers(userNames.toString());
            }
        }
        return groupElement;
    }

    @Override
    public void deleteGroup(int cloudId, Group group) {
        this.userGroupDao.deleteGroup(cloudId, group);
    }

    @Override
    public List<Group> getAllGroups(int cloudId, int skipValue) {
        return this.userGroupDao.getAllGroups(cloudId, skipValue);
    }

    @Override
    public List<Group> searchGroups(int cloudId, String groupName) {
        return this.userGroupDao.searchGroups(cloudId, groupName);
    }

    @Override
    public Group getUserGroup(int cloudId, User user) {
        logger.debug("Group getUserGroup(int cloudId, User user) > BEGIN");
        Group group = this.userGroupDao.getUserGroup(cloudId, user);
        logger.debug("Group getUserGroup(int cloudId, User user) > BEFORE RETURN");
        return group;
    }

    @Override
    public User getAdminUserWithServerBackupEnabled(int cloudId) {
        logger.debug("User getAdminUserWithServerBackupEnableerd(int cloudId) > BEGIN");
        User user = this.userDao.getAdminUserWithServerBackupEnabled(cloudId);
        logger.debug("User getAdminUserWithServerBackupEnableerd(int cloudId) > BEFORE");
        return user;
    }

    @Override
    public User getUserDetailsForEmail(int cloudId, String email) {
        return this.userDao.getUserDetailsForEmail(cloudId, email);
    }

    @Override
    public SyncOverviewElement getSyncOverview(int cloudId) {
        SyncOverView syncOverview = this.fileRevisionDao.getSyncOverview(cloudId);
        SyncOverviewElement syncOverviewElement = new SyncOverviewElement();
        long noOfUsers = this.userDao.countOfPresentSyncUsers(cloudId, "", true);
        syncOverviewElement.setTotalUsers(Long.toString(noOfUsers));
        if (syncOverview != null) {
            syncOverviewElement.setTotalFilesShared(Long.toString(syncOverview.getTotalFilesShared()));
            syncOverviewElement.setTotalFilesDownloaded(Long.toString(syncOverview.getTotalFilesDownloaded()));
            syncOverviewElement.setTotalSizeUploaded(UserManagementServiceImpl.formatFileSize(syncOverview.getTotalSizeUploaded()));
            syncOverviewElement.setTotalSizeDownloaded(UserManagementServiceImpl.formatFileSize(syncOverview.getTotalSizeDownloaded()));
        }
        return syncOverviewElement;
    }

    @Override
    public void saveSyncOverview(int cloudId, long totalSizeUploaded, long totalSizeDownloaded, long filesShared, long filesDownloaded) {
        SyncOverView syncOverview = this.fileRevisionDao.getSyncOverview(cloudId);
        if (syncOverview == null) {
            syncOverview = new SyncOverView();
            syncOverview.setTotalFilesShared(filesShared);
            syncOverview.setTotalSizeUploaded(totalSizeUploaded);
            syncOverview.setTotalFilesDownloaded(totalSizeDownloaded);
            syncOverview.setTotalSizeUploaded(totalSizeUploaded);
        } else {
            syncOverview.setTotalFilesShared(syncOverview.getTotalFilesShared() + filesShared);
            syncOverview.setTotalSizeUploaded(syncOverview.getTotalSizeUploaded() + totalSizeUploaded);
            syncOverview.setTotalFilesDownloaded(syncOverview.getTotalFilesDownloaded() + totalSizeDownloaded);
            syncOverview.setTotalSizeUploaded(syncOverview.getTotalSizeUploaded() + totalSizeUploaded);
        }
        this.fileRevisionDao.saveSyncOverview(cloudId, syncOverview);
        long currentTimeMillis = UserManagementServiceImpl.getStartofDay(System.currentTimeMillis());
        DailySyncOverView dailySyncOverview = this.fileRevisionDao.getDailySyncOverview(cloudId, currentTimeMillis);
        if (dailySyncOverview == null) {
            dailySyncOverview = new DailySyncOverView();
            dailySyncOverview.setTotalFilesShared(filesShared);
            dailySyncOverview.setTotalFilesDownloaded(totalSizeDownloaded);
            dailySyncOverview.setTotalSizeUploaded(totalSizeUploaded);
            dailySyncOverview.setTotalSizeDownloaded(totalSizeDownloaded);
            dailySyncOverview.setOverViewDate(UserManagementServiceImpl.getStartofDay(currentTimeMillis));
        } else {
            dailySyncOverview.setTotalFilesShared(dailySyncOverview.getTotalFilesShared() + filesShared);
            dailySyncOverview.setTotalFilesDownloaded(dailySyncOverview.getTotalFilesDownloaded() + filesDownloaded);
            dailySyncOverview.setTotalSizeUploaded(dailySyncOverview.getTotalSizeUploaded() + totalSizeUploaded);
            dailySyncOverview.setTotalSizeDownloaded(dailySyncOverview.getTotalSizeDownloaded() + totalSizeDownloaded);
            dailySyncOverview.setOverViewDate(UserManagementServiceImpl.getStartofDay(currentTimeMillis));
        }
        this.fileRevisionDao.saveDailySyncOverview(cloudId, dailySyncOverview);
    }

    private static long getStartofDay(long millis) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(millis);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }

    public static String formatFileSize(long size) {
        double m = (double)size / 1024.0;
        double g = (double)size / 1024.0 / 1024.0;
        double t = (double)size / 1024.0 / 1024.0 / 1024.0;
        DecimalFormat dec = new DecimalFormat("0.00");
        String hrSize = t > 1.0 ? dec.format(t).concat(" TB") : (g > 1.0 ? dec.format(g).concat(" GB") : dec.format(m).concat(" MB"));
        return hrSize;
    }

    @Override
    public void deleteOldSyncOverView(int cloudId) {
        this.fileRevisionDao.deleteOldSyncOverView(cloudId);
    }

    @Override
    public void updateUserLoggedInTime(int cloudId, String userName) {
        this.userDao.updateUserLoggedInTime(cloudId, userName);
    }

    @Override
    public void syncExistingUsersAttributes(Cloud cloud) {
        block16: {
            int cloudId = cloud.getCloudId();
            List allAdcredentials = this.personDao.getAllAdCredentials(cloudId);
            boolean result = this.checkADCredentialsHaveGroupName(allAdcredentials);
            if (CollectionUtils.isEmpty((Collection)allAdcredentials) && result) {
                logger.debug("allAdcredentials is empty Ad creadentails have no group name don't sync");
                return;
            }
            List ldapUsers = this.userDao.getAllLdapUser(cloud.getCloudId());
            long countOfPresentUsers = this.userDao.countOfPresentUsers(cloudId, cloud.getCloudName(), true);
            int noOfUsersAllowed = cloud.getNoOfUsersAllowed();
            try {
                boolean isBackupEnabled = false;
                boolean isSyncEnabled = false;
                for (User user : ldapUsers) {
                    for (CloudCustomisableDetails customisableDetails : cloud.getCloudCustomisableDetails()) {
                        if (customisableDetails.getName().equalsIgnoreCase(SYNC_ENABLED)) {
                            isSyncEnabled = true;
                        }
                        if (!customisableDetails.getName().equalsIgnoreCase(BACKUP_ENABLED)) continue;
                        isBackupEnabled = true;
                    }
                    Person userInAD = this.ldapService.getPersonByUserNameForSync(user.getUserName());
                    if (userInAD != null) {
                        if (isBackupEnabled && "sync".equalsIgnoreCase(userInAD.getAdGroupType())) {
                            isBackupEnabled = false;
                        }
                        if (isSyncEnabled && "backup".equalsIgnoreCase(userInAD.getAdGroupType())) {
                            isSyncEnabled = false;
                        }
                        logger.debug("...UserName : " + userInAD.getFullName() + " acount status " + userInAD.isAccountStatus());
                        user.setDepartment(userInAD.getDepartment());
                        user.setDisplayName(userInAD.getDisplayName());
                        user.setLocation(userInAD.getLocation());
                        user.setAccountStatus(userInAD.isAccountStatus());
                        if (!userInAD.isAccountStatus()) {
                            logger.debug("...UserName : " + userInAD.getFullName() + " acount status " + userInAD.isAccountStatus() + " setting false");
                            if (user.isActive()) {
                                logger.debug("In AD user is not active but user is active so change the status");
                                user.setActive(false);
                                this.saveAuditHistory(cloud, cloudId, user);
                            }
                        } else if (!user.isActive() && (long)noOfUsersAllowed > countOfPresentUsers) {
                            logger.debug("In AD user is active but user is not active in db so change the status");
                            user.setActive(true);
                            this.saveStatisticToDatabase(cloud, "unblocked", "AUTO", user.getUserName(), "AD Sync", System.currentTimeMillis(), PCActionTypes.AD_USER_MIGRATION.getActionTypeValue());
                        }
                        user.setBackupEnabled(isBackupEnabled);
                        user.setSyncEnabled(isSyncEnabled);
                        if (!isBackupEnabled && !isSyncEnabled && user.isActive()) {
                            user.setActive(false);
                            this.saveAuditHistory(cloud, cloudId, user);
                        }
                        if (user.isActive()) {
                            if ((long)noOfUsersAllowed > countOfPresentUsers) {
                                logger.debug("...Inside new logic...");
                                this.updateUserInfo(cloud.getCloudId(), cloud.getCloudName(), user);
                                ++countOfPresentUsers;
                                continue;
                            }
                            logger.debug("...User limit reached....");
                            continue;
                        }
                        this.updateUserInfo(cloud.getCloudId(), cloud.getCloudName(), user);
                        continue;
                    }
                    logger.debug("...User not found in ad and no exception also so block the user..");
                    if (!user.isActive()) continue;
                    user.setActive(false);
                    this.updateUserInfo(cloud.getCloudId(), cloud.getCloudName(), user);
                    this.saveAuditHistory(cloud, cloudId, user);
                }
            }
            catch (BaseException e) {
                logger.trace(BASE_EXCEPTION + (Object)((Object)e));
                logger.error(BASE_EXCEPTION + e.getMessage());
                if (e == null || e.getErrorStatus() != 400) break block16;
                logger.debug("Ad connection so stop sync failed reason :" + e.getMessage());
                throw e;
            }
        }
    }

    private boolean checkADCredentialsHaveGroupName(List<AdCredentials> adCredentials) {
        boolean results = false;
        for (AdCredentials adCredentail : adCredentials) {
            if (!StringUtils.isEmpty((String)adCredentail.getAdGroupName())) continue;
            logger.debug("In adcredntials " + adCredentail.getAdUrl() + " group name is empty so checkADCredentialsHaveGroupName return true");
            results = true;
            break;
        }
        return results;
    }

    private void saveAuditHistory(Cloud cloud, int cloudId, User user) {
        this.saveStatisticToDatabase(cloud, "Blocked", "AUTO", user.getUserName(), "AD Sync", System.currentTimeMillis(), PCActionTypes.AD_USER_MIGRATION.getActionTypeValue());
        List<Device> blockedDevices = this.blockUnblockDevicebyUserName(cloudId, cloud.getCloudName(), user.getUserName(), true);
        if (blockedDevices != null) {
            for (Device device : blockedDevices) {
                logger.debug("....blocking devices....");
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloud.getCloudName(), "blocked Device:" + device.getDeviceName() + " of User:", "AUTO", user.getUserName(), "AD Sync", System.currentTimeMillis(), PCActionTypes.DEVICE_BLOCK.getActionTypeValue());
            }
        }
    }

    private void changeUserStatusByADStatus(Cloud cloud, int cloudId, User user, Person userInAD) {
        if (!userInAD.isAccountStatus()) {
            if (user.isActive()) {
                user.setActive(false);
                logger.debug("In AD user is not active but user is active in DB so change the status" + user.isActive());
                this.updateStatusInDevice(cloud, cloudId, user);
            }
        } else if (!user.isActive()) {
            logger.debug("In AD user is active but user is in active so change the status");
            user.setActive(true);
            this.saveStatisticToDatabase(cloud, "unblocked", "AUTO", user.getUserName(), "AD Sync", System.currentTimeMillis(), PCActionTypes.AD_USER_MIGRATION.getActionTypeValue());
        }
    }

    private void updateStatusInDevice(Cloud cloud, int cloudId, User user) {
        this.saveStatisticToDatabase(cloud, "Blocked", "AUTO", user.getUserName(), "AD Sync", System.currentTimeMillis(), PCActionTypes.AD_USER_MIGRATION.getActionTypeValue());
        List<Device> blockedDevices = this.blockUnblockDevicebyUserName(cloudId, cloud.getCloudName(), user.getUserName(), true);
        if (blockedDevices != null) {
            for (Device device : blockedDevices) {
                logger.debug("....blocking devices....");
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloud.getCloudName(), "blocked Device:" + device.getDeviceName() + " of User:", "AUTO", user.getUserName(), "AD Sync", System.currentTimeMillis(), PCActionTypes.DEVICE_BLOCK.getActionTypeValue());
            }
        }
    }

    private void saveStatisticToDatabase(Cloud cloud, String action, String actionByUser, String actionOnUser, String actionUsingObject, long timeStamp, int actionType) {
        AuditHistory audit = new AuditHistory();
        audit.setAction(action);
        audit.setActionByUserName(actionByUser);
        audit.setActionOnObject(actionOnUser);
        audit.setTimestamp(timeStamp);
        audit.setActionUsingObject(actionUsingObject);
        audit.setActionType(actionType);
        this.auditHistoryDao.saveAudit(cloud.getCloudId(), cloud.getCloudName(), audit);
    }

    @Override
    public List<SearchUserElement> searchUsersWithDevices(int cloudId, String userName, User currentUser) {
        ArrayList<SearchUserElement> userElementList = new ArrayList<SearchUserElement>();
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(userName.split(",")));
        HashSet<String> removeSet = new HashSet<String>();
        removeSet.addAll(list);
        list.clear();
        list.addAll(removeSet);
        List users = null;
        users = currentUser.isReadOnlyAdmin() && !CollectionUtils.isEmpty((Collection)currentUser.getBackupPoliciesAdmin()) ? this.userDao.searchUsersForPolicyAdmin(cloudId, list, currentUser.getBackupPoliciesAdmin()) : this.userDao.searchUsers(cloudId, list);
        for (User user : users) {
            if (user == null) continue;
            List devicesList = this.deviceDao.getAllDeviceByUserName(cloudId, user.getUserName());
            ArrayList<String> deviceNameList = new ArrayList<String>();
            if (devicesList != null) {
                for (Device device : devicesList) {
                    deviceNameList.add(device.getDeviceName());
                }
            }
            SearchUserElement ue = new SearchUserElement();
            BeanUtils.copyProperties((Object)user, (Object)ue);
            ue.setShareEnabled(user.isShareEnabled());
            ue.setDeviceNameList(deviceNameList);
            userElementList.add(ue);
        }
        return userElementList;
    }

    @Override
    public List<UserElement> getUserListByNames(int cloudId, List<String> userNames, String currentUserName) throws Exception {
        ArrayList<UserElement> userElementList = new ArrayList<UserElement>();
        for (String userName : userNames) {
            if (StringUtils.isEmpty((String)userName)) continue;
            User user = this.userDao.getUserByName(cloudId, userName);
            UserElement ue = new UserElement();
            if (userName.equalsIgnoreCase(currentUserName)) {
                ue.setUserName(userName);
                ue.setStatus("CurrentUser");
            } else if (user != null) {
                ue.setUserName(user.getUserName());
                ue.setEmailId(user.getEmailId());
                ue.setActive(user.isActive());
                ue.setDeleted(user.isDeleted());
                ue.setLastModifiedTimestamp(user.getLastModifiedTimestamp());
                if (ue.isActive()) {
                    ue.setStatus(PCHelperConstant.USER_STATUS.ACTIVE.toString());
                } else if (!ue.isActive() && !ue.isDeleted()) {
                    ue.setStatus(PCHelperConstant.USER_STATUS.BLOCKED.toString());
                } else {
                    ue.setStatus(PCHelperConstant.USER_STATUS.DELETED.toString());
                }
            } else {
                ue.setUserName(userName);
                ue.setStatus("INVALID");
            }
            userElementList.add(ue);
        }
        userElementList.removeAll(Collections.singleton(null));
        Collections.sort(userElementList, new Comparator<UserElement>(){

            @Override
            public int compare(UserElement u1, UserElement u2) {
                if (u1 == null || u2 == null || u1.getUserName() == null || u2.getUserName() == null) {
                    return -1;
                }
                return new CompareToBuilder().append((Object)u1.getStatus(), (Object)u2.getStatus()).append((Object)u1.getUserName().toLowerCase(), (Object)u2.getUserName().toLowerCase()).toComparison();
            }
        });
        return userElementList;
    }

    @Override
    public User getOneADUser(int cloudId, String cloudName) {
        return this.userDao.getOneADUser(cloudId, cloudName);
    }

    @Override
    public void saveMigrationStatus(int cloudId, MigrationStatus migrationStatus) {
        this.migrationStatusDao.saveMigrationStatus(cloudId, migrationStatus);
    }

    public MigrationStatusDao getMigrationStatusDao() {
        return this.migrationStatusDao;
    }

    public void setMigrationStatusDao(MigrationStatusDao migrationStatusDao) {
        this.migrationStatusDao = migrationStatusDao;
    }

    @Override
    public List<String> getUserNamesByBackupPoliciesAdmin(int cloudId, List<String> backupPoliciesAdmin) {
        return this.userDao.getUserNamesByBackupPoliciesAdmin(cloudId, backupPoliciesAdmin);
    }

    @Override
    public boolean createExcelForUsers(CloudLicenseTo cl, int cloudId, String userName) {
        ArrayList<UserElement> userList = new ArrayList();
        if (StringUtils.isEmpty((String)userName)) {
            userList = this.getAllUsers(cloudId, cl.getCloud().getCloudName());
        } else {
            userList = this.searchUserbyUsernameOrDisplaynameOrEmailId(cloudId, userName);
            logger.debug(userName);
        }
        if (CollectionUtils.isEmpty(userList)) {
            logger.debug("Invalid users.....");
            return false;
        }
        this.createUsersExcelForXlsx(cl, cloudId, userList);
        return true;
    }

    private boolean isODBEnabled(List<CloudCustomisableDetails> licenseDetails) {
        boolean isODBEnabled = false;
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !"ODB Enabled".equalsIgnoreCase(license.getName())) continue;
            isODBEnabled = true;
            break;
        }
        return isODBEnabled;
    }

    private boolean isBackupEnabled(List<CloudCustomisableDetails> licenseDetails) {
        boolean isBackupEnabled = false;
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !BACKUP_ENABLED.equalsIgnoreCase(license.getName())) continue;
            isBackupEnabled = true;
            break;
        }
        return isBackupEnabled;
    }

    private boolean isO365Enabled(List<CloudCustomisableDetails> licenseDetails) {
        boolean isO365Enabled = false;
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !"OneDrive Backup Enabled".equalsIgnoreCase(license.getName())) continue;
            isO365Enabled = true;
            break;
        }
        return isO365Enabled;
    }

    private boolean isSyncEnabled(List<CloudCustomisableDetails> licenseDetails) {
        boolean isSyncEnabled = false;
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !SYNC_ENABLED.equalsIgnoreCase(license.getName())) continue;
            isSyncEnabled = true;
            break;
        }
        return isSyncEnabled;
    }

    private void createUsersExcelForXlsx(CloudLicenseTo cl, int cloudId, List<UserElement> userList) {
        if (!userList.isEmpty()) {
            try (XSSFWorkbook workbook = new XSSFWorkbook();){
                List<List> recordToAdd = this.updateUserElementValuesToExcel(cl, userList);
                this.createExcelForUserXlsx(recordToAdd, workbook);
                this.writeExcelForUserXlsx(workbook);
            }
            catch (Exception e) {
                logger.trace(EXCEPTION + e);
                logger.error(EXCEPTION + e.getMessage());
            }
        }
    }

    private List<List> updateUserElementValuesToExcel(CloudLicenseTo cl, List<UserElement> userList) {
        List list = cl.getCloud().getCloudCustomisableDetails();
        boolean isODBEnabled = this.isODBEnabled(list);
        boolean isBackupEnabled = this.isBackupEnabled(list);
        boolean isSyncEnabled = this.isSyncEnabled(list);
        boolean isO365Enabled = this.isO365Enabled(list);
        ArrayList<List> recordToAdd = new ArrayList<List>();
        List<String> headerRow = this.createHeaderRowForUserXlsx(isODBEnabled, isBackupEnabled, isSyncEnabled, isO365Enabled);
        recordToAdd.add(headerRow);
        for (UserElement userElement : userList) {
            List<String> firstRow = this.loadDataOnRowForUserXlsx(userElement, isODBEnabled, isBackupEnabled, isSyncEnabled, isO365Enabled);
            recordToAdd.add(firstRow);
        }
        return recordToAdd;
    }

    List<String> createHeaderRowForUserXlsx(boolean isODBEnabled, boolean isBackupEnabled, boolean isSyncEnabled, boolean isO365Enabled) {
        ArrayList<String> headerRow = new ArrayList<String>();
        headerRow.add("User ID");
        headerRow.add("Display Name");
        headerRow.add("Email ID");
        headerRow.add("Department");
        headerRow.add("Location");
        headerRow.add("User Type");
        headerRow.add("User Status");
        headerRow.add("Is Local User");
        headerRow.add("Created Timestamp");
        headerRow.add("Last Logged In Time");
        if (isODBEnabled) {
            headerRow.add("Odb Login Id");
            headerRow.add("Backup Target Assigned");
            headerRow.add("Reason");
        }
        if (isBackupEnabled) {
            headerRow.add("Backup Policy Name");
            headerRow.add("Is Backup Enabled");
            headerRow.add("Backup Policies Admin");
        }
        if (isSyncEnabled) {
            headerRow.add("Sync Policy Name");
            headerRow.add("Is Sync Enabled");
            headerRow.add("Sync Policies Admin");
        }
        if (isO365Enabled) {
            headerRow.add("O365 Policy Name");
            headerRow.add("Is O365 Backup Enabled");
        }
        return headerRow;
    }

    List<String> loadDataOnRowForUserXlsx(UserElement userElement, boolean isODBEnabled, boolean isBackupEnabled, boolean isSyncEnabled, boolean isO365Enabled) {
        long dateLong;
        ArrayList<String> firstRow = new ArrayList<String>();
        firstRow.add(userElement.getUserName());
        if (!StringUtils.isEmpty((String)userElement.getDisplayName())) {
            firstRow.add(userElement.getDisplayName());
        } else {
            firstRow.add("");
        }
        if (!StringUtils.isEmpty((String)userElement.getEmailId())) {
            firstRow.add(userElement.getEmailId());
        } else {
            firstRow.add("");
        }
        if (!StringUtils.isEmpty((String)userElement.getDepartment())) {
            firstRow.add(userElement.getDepartment());
        } else {
            firstRow.add("");
        }
        try {
            if (!StringUtils.isEmpty((String)userElement.getLocation())) {
                firstRow.add(userElement.getLocation());
            } else {
                firstRow.add("");
            }
        }
        catch (Exception e) {
            logger.error(EXCEPTION + e.getMessage());
            logger.error(EXCEPTION + e);
        }
        if (userElement.isAdmin()) {
            firstRow.add("Admin");
        } else if (userElement.isReadOnlyAdmin()) {
            firstRow.add("Read Only Admin");
        } else if (userElement.isGuest()) {
            firstRow.add("Guest User");
        } else {
            firstRow.add("User");
        }
        if (!userElement.isDeleted()) {
            if (userElement.isActive()) {
                firstRow.add("Active");
            } else {
                firstRow.add("Blocked");
            }
        } else {
            firstRow.add("Deleted");
        }
        if (userElement.isLocalUser()) {
            firstRow.add("Y");
        } else {
            firstRow.add("N");
        }
        try {
            String createdTimeDate = userElement.getCreatedTimestamp();
            if (!StringUtils.isEmpty((String)createdTimeDate)) {
                dateLong = Long.parseLong(createdTimeDate);
                firstRow.add(this.getDate(dateLong));
            } else {
                firstRow.add("");
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
        try {
            String lastLoggedInDateInString = userElement.getLastLoggedInTime();
            if (!StringUtils.isEmpty((String)lastLoggedInDateInString)) {
                dateLong = Long.parseLong(lastLoggedInDateInString);
                firstRow.add(this.getDate(dateLong));
            } else {
                firstRow.add("");
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
        if (isODBEnabled) {
            firstRow.add(userElement.getOdbLoginId());
            if (userElement.isBackupTargetAssigned()) {
                firstRow.add("Yes");
            } else {
                firstRow.add("No");
            }
            if (!userElement.isBackupTargetAssigned()) {
                firstRow.add(this.getCommentsForErrorCode(userElement.getBackupTargetErrorCode()));
            } else {
                firstRow.add("");
            }
        }
        if (isBackupEnabled) {
            firstRow.add(userElement.getPolicyName());
            if (userElement.isBackupEnabled()) {
                firstRow.add("Y");
            } else {
                firstRow.add("N");
            }
            BackupPoliciesAdminList backupPolicyAdminList = userElement.getBackupPoliciesAdminList();
            if (backupPolicyAdminList != null) {
                List backupPoliciesAdmin = backupPolicyAdminList.getBackupPoliciesAdmin();
                String backupPolicies = backupPoliciesAdmin.stream().collect(Collectors.joining(","));
                firstRow.add(backupPolicies);
            } else {
                firstRow.add("");
            }
        }
        if (isSyncEnabled) {
            firstRow.add(userElement.getSyncPolicyName());
            firstRow.add("Y");
            SyncPoliciesAdminList syncPolicyAdminList = userElement.getSyncPoliciesAdminList();
            if (syncPolicyAdminList != null) {
                List syncPoliciesAdmin = syncPolicyAdminList.getSyncPoliciesAdmin();
                String syncPolicies = syncPoliciesAdmin.stream().collect(Collectors.joining(","));
                firstRow.add(syncPolicies);
            } else {
                firstRow.add("");
            }
        }
        if (isO365Enabled) {
            firstRow.add(userElement.getOdbPolicyName());
            firstRow.add("Y");
        }
        return firstRow;
    }

    void createExcelForUserXlsx(List<List> l1, XSSFWorkbook workbook) throws Exception {
        XSSFSheet firstSheet = workbook.createSheet("FIRST SHEET");
        int rownum = 0;
        try {
            for (int j = 0; j < l1.size(); ++j) {
                XSSFRow row = firstSheet.createRow(rownum);
                List l2 = l1.get(j);
                for (int k = 0; k < l2.size(); ++k) {
                    Cell cell = row.createCell(k);
                    cell.setCellValue((String)l2.get(k));
                    if (rownum != 0) continue;
                    XSSFCellStyle cellStyle = workbook.createCellStyle();
                    cellStyle.setFillForegroundColor((short)51);
                    cellStyle.setFillPattern((short)1);
                    XSSFFont font = workbook.createFont();
                    font.setFontName("Arial");
                    font.setFontHeightInPoints((short)10);
                    font.setBoldweight((short)10);
                    cellStyle.setFont((Font)font);
                    cell.setCellStyle((CellStyle)cellStyle);
                }
                ++rownum;
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
    }

    void writeExcelForUserXlsx(XSSFWorkbook workbook) {
        try (FileOutputStream fos = new FileOutputStream(new File(PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "/reports/Users.xlsx"));){
            XSSFCellStyle hsfstyle = workbook.createCellStyle();
            hsfstyle.setBorderBottom((short)1);
            hsfstyle.setFillBackgroundColor((short)245);
            workbook.write((OutputStream)fos);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
    }

    private String getDate(long dateVal) {
        String date = "";
        try {
            SimpleDateFormat df2 = new SimpleDateFormat(MM_DD_YYYY_HH_MM_SS);
            Date dateD = new Date(dateVal);
            date = df2.format(dateD);
        }
        catch (NumberFormatException e) {
            logger.trace(NUMBER_FORMAT_EXCEPTION + e);
            logger.error(NUMBER_FORMAT_EXCEPTION + e.getMessage());
        }
        return date;
    }

    private String generatePassWordhash(String passHash) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        byte[] digesta = null;
        try {
            MessageDigest mda = MessageDigest.getInstance("SHA-512", "BC");
            digesta = mda.digest(passHash.getBytes());
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            logger.trace("getSHA512hash : " + e);
            logger.trace(e.getMessage());
        }
        return Hex.encodeHexString((byte[])digesta);
    }

    @Override
    public void removeUsersByName(int cloudId, List<String> userNames) {
        this.userDao.deleteUsersByName(cloudId, userNames);
        this.deletedUserDao.removeDeletedUser(cloudId, userNames);
    }

    @Override
    public boolean createUserFromAAD(int cloudId, String cloudName, AADUserElement aadUserElement, String migratedBy, boolean isSyncEnabled, boolean isBackupEnabled, boolean isO365BackupEnabled) throws Exception {
        boolean userMigrated = false;
        try {
            User user = new User();
            UUID uuid = UUID.randomUUID();
            String recoveryKey = String.valueOf(uuid);
            user.setSecurityRecoveryKey(recoveryKey);
            user.setActive(true);
            user.setAdmin(false);
            user.setBackupEnabled(isBackupEnabled);
            user.setSyncEnabled(isSyncEnabled);
            user.setOnedriveBkpEnabled(isO365BackupEnabled);
            user.setFirstLogin(true);
            user.setShareEnabled(true);
            user.setUserName(aadUserElement.getUserPrincipalName());
            if (StringUtils.isEmpty((String)aadUserElement.getMail())) {
                user.setEmailId(aadUserElement.getUserPrincipalName());
            } else {
                user.setEmailId(aadUserElement.getMail());
            }
            user.setCreatedTimestamp(String.valueOf(System.currentTimeMillis()));
            user.setDisplayName(aadUserElement.getDisplayName());
            user.setMigratedBy(migratedBy);
            user.setlocalUser(false);
            user.setLocation(aadUserElement.getOfficeLocation());
            user.setDepartment(aadUserElement.getDepartment());
            user.setAccountStatus(true);
            user.setUserNameLowerCase(aadUserElement.getUserName().toLowerCase());
            user.setAadLoginId(aadUserElement.getUserPrincipalName());
            if (!StringUtils.isEmpty((String)aadUserElement.getDefaultPolicy())) {
                user.setPolicyName(aadUserElement.getDefaultPolicy());
            }
            if (!StringUtils.isEmpty((String)aadUserElement.getDefaultSyncPolicy())) {
                user.setSyncPolicyName(aadUserElement.getDefaultSyncPolicy());
            }
            if (!StringUtils.isEmpty((String)aadUserElement.getDefaultOdbPolicy())) {
                user.setOdbPolicyName(aadUserElement.getDefaultOdbPolicy());
            }
            UserElement userElement = new UserElement();
            BeanUtils.copyProperties((Object)user, (Object)userElement);
            UserElement createduserElement = this.createUser(cloudId, cloudName, userElement, true, this.userDao);
            if (createduserElement != null) {
                userMigrated = true;
                MigrationStatus migrationStatus = new MigrationStatus();
                migrationStatus.setMigratedBy(migratedBy);
                migrationStatus.setMigratededTimestamp(System.currentTimeMillis());
                migrationStatus.setMigrated(true);
                migrationStatus.setUserName(user.getUserName());
                migrationStatus.setEmailId(user.getEmailId());
                this.migrationStatusDao.saveMigrationStatus(cloudId, migrationStatus);
            }
        }
        catch (Exception e) {
            logger.error(EXCEPTION + e);
            logger.debug(EXCEPTION + e.getMessage());
            throw new Exception(e);
        }
        return userMigrated;
    }

    @Override
    public SyncPolicyElement getSyncPolicyElement(int cloudId, String cloudName, String syncPolicyName) {
        SyncPolicyElement syncPolicyElement = this.getSyncPolicyElement(cloudId, this.syncPolicyDao.getSyncPolicy(cloudId, cloudName, syncPolicyName));
        return syncPolicyElement;
    }

    @Override
    public List<User> getUsersWithoutDevices(int cloudId) {
        List users = this.userDao.getAllOneDriveBkpEnabledUsers(cloudId);
        if (CollectionUtils.isEmpty((Collection)users)) {
            logger.debug("...no users found for odbBkp........");
            return new ArrayList<User>();
        }
        ArrayList<User> usersWithoutDrive = new ArrayList<User>();
        for (User user : users) {
            Device device = this.deviceDao.getOneDriveDeviceforUser(cloudId, user.getUserName());
            if (device != null) continue;
            usersWithoutDrive.add(user);
            if (usersWithoutDrive.size() < 100) continue;
            return usersWithoutDrive;
        }
        return usersWithoutDrive;
    }

    @Override
    public boolean createTextForBlackListAndMappedUser(int cloudId, String cloudName, boolean isAllUser, boolean secAdmin) {
        try {
            logger.debug("...isAllUser..." + isAllUser + "....secAdmin..." + secAdmin);
            if (secAdmin) {
                if (isAllUser) {
                    Object users;
                    ArrayList<String> mappedUserList = new ArrayList<String>();
                    ArrayList usersList = new ArrayList();
                    int i = 0;
                    while (!CollectionUtils.isEmpty((Collection)(users = this.userDao.getAllUsers(cloudId, cloudName, i)))) {
                        usersList.addAll(users);
                        ++i;
                    }
                    for (User userData : usersList) {
                        this.getListOfUserName(mappedUserList, userData);
                    }
                    return this.createTextFileForOdb(mappedUserList, "Mapped Users");
                }
                ArrayList<String> blackListUserList = new ArrayList<String>();
                List blackListUsers = this.userDao.getAllO365BlockedListUser(cloudId);
                logger.debug("........" + blackListUsers.size());
                ArrayList<String> blackListUsersNames = new ArrayList<String>();
                for (Object blackListUserData : blackListUsers) {
                    blackListUsersNames.add(blackListUserData.getUserName());
                }
                List userList = this.userDao.getAllUsersForNames(cloudId, blackListUsersNames);
                for (User user : userList) {
                    this.getListOfUserName(blackListUserList, user);
                }
                return this.createTextFileForOdb(blackListUserList, "Black List Users");
            }
            boolean muxedEnabled = PCHelperConstant.isMuxedEnabled();
            logger.debug(".muxedEnabled..." + muxedEnabled);
            List blackListUsers = this.userDao.getAllBackupTargetNotAssignedUser(cloudId);
            ArrayList<String> blackListUsersNames = new ArrayList<String>();
            for (User blackListUserData : blackListUsers) {
                if (blackListUserData == null) continue;
                if (!muxedEnabled) {
                    if (!StringUtils.isEmpty((String)blackListUserData.getOdbLoginId())) {
                        if (blackListUsersNames.contains(blackListUserData.getOdbLoginId())) continue;
                        blackListUsersNames.add(blackListUserData.getOdbLoginId());
                        continue;
                    }
                    if (blackListUsersNames.contains(blackListUserData.getEmailId())) continue;
                    blackListUsersNames.add(blackListUserData.getEmailId());
                    continue;
                }
                if (StringUtils.isNotEmpty((String)blackListUserData.getOdbLoginId()) && !blackListUsersNames.contains(blackListUserData.getOdbLoginId())) {
                    blackListUsersNames.add(blackListUserData.getOdbLoginId());
                }
                if (blackListUserData.getBackupTargetErrorCode() != 0) continue;
                blackListUserData.setBackupTargetErrorCode(204);
                this.userDao.saveUser(cloudId, cloudName, blackListUserData);
            }
            return this.createTextFileForOdb(blackListUsersNames, "size=50000");
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            return false;
        }
    }

    private void getListOfOdbOrEmailIdFromUser(List<String> odbOrEmailIdList, User userData) {
        odbOrEmailIdList.add(userData.getEmailId());
    }

    private void getListOfUserName(List<String> odbOrEmailIdList, User userData) {
        odbOrEmailIdList.add(userData.getUserName());
    }

    private boolean createTextFileForOdb(List<String> odbOrEmailIdList, String excelHeader) {
        boolean result = false;
        if (!CollectionUtils.isEmpty(odbOrEmailIdList)) {
            try {
                FileWriter fileWriter = new FileWriter("/var/www/odbInfo/BlackList_And_Active_User.txt");
                if (StringUtils.isNotEmpty((String)excelHeader)) {
                    fileWriter.write(excelHeader);
                }
                for (String emailId : odbOrEmailIdList) {
                    fileWriter.write("\n" + emailId);
                }
                fileWriter.close();
                result = true;
            }
            catch (IOException e1) {
                logger.error(EXCEPTION + e1);
                logger.debug(EXCEPTION + e1.getMessage());
            }
        }
        return result;
    }

    @Override
    public BackupPolicy getBackupPolicy(int cloudId, String policyName) {
        return this.userDao.getBackupPolicyByPolicyName(cloudId, policyName);
    }

    @Override
    public SyncPolicy getSyncPolicyByPolicyName(int cloudId, String policyName) {
        return this.userDao.getSyncPolicyByPolicyName(cloudId, policyName);
    }

    @Override
    public long getSyncPolicyMappedUserCountbyPolicyName(int cloudId, String policyName) {
        return this.userDao.getSyncPolicyMappedUserCountbyPolicyName(cloudId, policyName);
    }

    @Override
    public void mapODBIdsByFilePath(UserListElement userListElement) {
        if (userListElement != null && !CollectionUtils.isEmpty((Collection)userListElement.getUserList())) {
            for (UserElement userElement : userListElement.getUserList()) {
                try {
                    User userByUserNameOrEmail = this.userDao.getUserByUserNameOrEmail(1, userElement.getEmailId());
                    if (userByUserNameOrEmail == null) continue;
                    userByUserNameOrEmail.setOdbLoginId(userElement.getOdbLoginId());
                    logger.debug("Updating " + userElement.getEmailId() + " ODB Id as :" + userElement.getOdbLoginId());
                }
                catch (Exception e) {
                    logger.trace(EXCEPTION + e);
                    logger.error(EXCEPTION + e.getMessage());
                }
            }
        } else {
            logger.debug("userListElement is empty......");
        }
    }

    @Override
    public void mapODBIdAndErrorCode(UserListElement userListElement) {
        if (userListElement != null && !CollectionUtils.isEmpty((Collection)userListElement.getUserList())) {
            for (UserElement userElement : userListElement.getUserList()) {
                try {
                    boolean muxedEnabled = PCHelperConstant.isMuxedEnabled();
                    logger.debug(muxedEnabled + "................" + userElement.getOdbLoginId());
                    List userList = !muxedEnabled ? this.userDao.getUserByODBLoginIdOrEmailId(1, userElement.getOdbLoginId()) : this.userDao.getUserByODBLoginId(1, userElement.getOdbLoginId());
                    for (User userByUserNameOrEmail : userList) {
                        if (userByUserNameOrEmail == null) continue;
                        if (StringUtils.isNotEmpty((String)userByUserNameOrEmail.getOdbLoginId()) && userByUserNameOrEmail.getOdbLoginId().equals(userElement.getOdbLoginId())) {
                            this.updateUserBkpTargetStatus(userElement, userByUserNameOrEmail);
                            continue;
                        }
                        if (!StringUtils.isEmpty((String)userByUserNameOrEmail.getOdbLoginId()) || !userByUserNameOrEmail.getEmailId().equals(userElement.getOdbLoginId())) continue;
                        this.updateUserBkpTargetStatus(userElement, userByUserNameOrEmail);
                    }
                }
                catch (Exception e) {
                    logger.trace(EXCEPTION + e);
                    logger.error(EXCEPTION + e.getMessage());
                }
            }
        } else {
            logger.debug("userListElement is empty......");
        }
    }

    private void updateUserBkpTargetStatus(UserElement userElement, User userByUserNameOrEmail) {
        int backupTargetErrorCode = userElement.getBackupTargetErrorCode();
        boolean backupTargetAssigned = false;
        if (userElement.getBackupTargetErrorCode() == 0) {
            backupTargetAssigned = true;
            logger.debug("Updating " + userElement.getEmailId() + " ODB Id as :" + userElement.getOdbLoginId());
        }
        this.userDao.updateUserBkpTargetStatus(1, userByUserNameOrEmail.getUserName(), backupTargetErrorCode, backupTargetAssigned);
    }

    private boolean isAADEnabled(List<CloudCustomisableDetails> list) {
        boolean isAADEnabled = false;
        for (CloudCustomisableDetails customisableDetails : list) {
            if (!"AAD Enabled".equals(customisableDetails.getName())) continue;
            isAADEnabled = true;
            break;
        }
        return isAADEnabled;
    }

    @Override
    public UserElement getUserByUserName(Cloud cloud, String userName) {
        ArrayList<MiniCloudElement> cloudElements = new ArrayList<MiniCloudElement>();
        UserElement usrElement = new UserElement();
        int cloudId = cloud.getCloudId();
        String cloudName = cloud.getCloudName();
        User user = this.userDao.getUserByUserName(cloudId, userName);
        if (user == null && this.isAADEnabled(cloud.getCloudCustomisableDetails())) {
            user = this.userDao.getUserByUserNameOrAADLoginId(cloudId, userName);
        }
        if (user != null) {
            SyncPolicyElement syncPolicyElement;
            BackupPolicyElement backupPolicyElement;
            logger.debug("USer not null :" + user.getUserName());
            List ucacList = this.userMiniCloudMappingDao.getAccessControlMappingsByUser(cloudId, cloudName, user.getUserId());
            if (!CollectionUtils.isEmpty((Collection)ucacList)) {
                for (UserCloudAccessControl ucac : ucacList) {
                    MiniCloudElement cloudElement = new MiniCloudElement();
                    MiniCloud cloud1 = this.miniCloudDao.getMiniCloudByID(cloudId, cloudName, ucac.getMiniCloudFK());
                    if (cloud == null) continue;
                    BeanUtils.copyProperties((Object)cloud1, (Object)cloudElement);
                    cloudElements.add(cloudElement);
                }
            }
            if (StringUtils.isEmpty((String)user.getLastModifiedTimestamp())) {
                usrElement.setLastModifiedTimestamp(user.getCreatedTimestamp());
            }
            MiniCloudElementList miniCloudElementList = new MiniCloudElementList();
            miniCloudElementList.setMiniClouds(cloudElements);
            usrElement.setMiniCloudElementList(miniCloudElementList);
            BeanUtils.copyProperties((Object)user, (Object)usrElement);
            usrElement.setShareEnabled(user.isShareEnabled());
            PciAuthorizationTokens authorizationTokens = this.pciAuthorizationTokensDao.getPciAuthorizationTokensForUserId(cloudId, cloudName, user.getUserId());
            if (!StringUtils.isEmpty((String)usrElement.getPolicyName()) && (backupPolicyElement = this.getBackupPolicyElement(cloudId, this.backupPolicyDao.getBackupPolicy(cloudId, cloudName, user.getPolicyName()))) != null) {
                usrElement.setBackupPolicyElement(this.getBackupPolicyElement(cloudId, this.backupPolicyDao.getBackupPolicy(cloudId, cloudName, user.getPolicyName())));
            }
            if (!StringUtils.isEmpty((String)usrElement.getSyncPolicyName()) && (syncPolicyElement = this.getSyncPolicyElement(cloudId, this.syncPolicyDao.getSyncPolicy(cloudId, cloudName, user.getSyncPolicyName()))) != null) {
                usrElement.setSyncPolicyElement(this.getSyncPolicyElement(cloudId, this.syncPolicyDao.getSyncPolicy(cloudId, cloudName, user.getSyncPolicyName())));
            }
            if (user.isReadOnlyAdmin()) {
                BackupPoliciesAdminList backupPolicyAdminList = new BackupPoliciesAdminList();
                backupPolicyAdminList.setBackupPoliciesAdmin(user.getBackupPoliciesAdmin());
                usrElement.setBackupPoliciesAdminList(backupPolicyAdminList);
                SyncPoliciesAdminList syncPolicyAdminList = new SyncPoliciesAdminList();
                syncPolicyAdminList.setSyncPoliciesAdmin(user.getSyncPoliciesAdmin());
                usrElement.setSyncPoliciesAdminList(syncPolicyAdminList);
            }
            if (authorizationTokens != null) {
                usrElement.setExternalStorageAuthorized(true);
            } else {
                usrElement.setExternalStorageAuthorized(false);
            }
        } else {
            return null;
        }
        return usrElement;
    }

    @Override
    public UserElement getUserByAADLoginId(Cloud cloud, String aadLoginId) {
        int cloudId = cloud.getCloudId();
        String cloudName = cloud.getCloudName();
        ArrayList<MiniCloudElement> cloudElements = new ArrayList<MiniCloudElement>();
        UserElement usrElement = new UserElement();
        User user = this.userDao.getUserByAADLoginId(cloudId, aadLoginId);
        if (user != null) {
            SyncPolicyElement syncPolicyElement;
            BackupPolicyElement backupPolicyElement;
            logger.debug("USer not null :" + user.getUserName());
            List ucacList = this.userMiniCloudMappingDao.getAccessControlMappingsByUser(cloudId, cloudName, user.getUserId());
            if (!CollectionUtils.isEmpty((Collection)ucacList)) {
                for (UserCloudAccessControl ucac : ucacList) {
                    MiniCloudElement cloudElement = new MiniCloudElement();
                    MiniCloud cloud1 = this.miniCloudDao.getMiniCloudByID(cloudId, cloudName, ucac.getMiniCloudFK());
                    if (cloud == null) continue;
                    BeanUtils.copyProperties((Object)cloud1, (Object)cloudElement);
                    cloudElements.add(cloudElement);
                }
            }
            if (StringUtils.isEmpty((String)user.getLastModifiedTimestamp())) {
                usrElement.setLastModifiedTimestamp(user.getCreatedTimestamp());
            }
            MiniCloudElementList miniCloudElementList = new MiniCloudElementList();
            miniCloudElementList.setMiniClouds(cloudElements);
            usrElement.setMiniCloudElementList(miniCloudElementList);
            BeanUtils.copyProperties((Object)user, (Object)usrElement);
            usrElement.setShareEnabled(user.isShareEnabled());
            PciAuthorizationTokens authorizationTokens = this.pciAuthorizationTokensDao.getPciAuthorizationTokensForUserId(cloudId, cloudName, user.getUserId());
            if (!StringUtils.isEmpty((String)usrElement.getPolicyName()) && (backupPolicyElement = this.getBackupPolicyElement(cloudId, this.backupPolicyDao.getBackupPolicy(cloudId, cloudName, user.getPolicyName()))) != null) {
                usrElement.setBackupPolicyElement(this.getBackupPolicyElement(cloudId, this.backupPolicyDao.getBackupPolicy(cloudId, cloudName, user.getPolicyName())));
            }
            if (!StringUtils.isEmpty((String)usrElement.getSyncPolicyName()) && (syncPolicyElement = this.getSyncPolicyElement(cloudId, this.syncPolicyDao.getSyncPolicy(cloudId, cloudName, user.getSyncPolicyName()))) != null) {
                usrElement.setSyncPolicyElement(this.getSyncPolicyElement(cloudId, this.syncPolicyDao.getSyncPolicy(cloudId, cloudName, user.getSyncPolicyName())));
            }
            if (user.isReadOnlyAdmin()) {
                BackupPoliciesAdminList backupPolicyAdminList = new BackupPoliciesAdminList();
                backupPolicyAdminList.setBackupPoliciesAdmin(user.getBackupPoliciesAdmin());
                usrElement.setBackupPoliciesAdminList(backupPolicyAdminList);
                SyncPoliciesAdminList syncPolicyAdminList = new SyncPoliciesAdminList();
                syncPolicyAdminList.setSyncPoliciesAdmin(user.getSyncPoliciesAdmin());
                usrElement.setSyncPoliciesAdminList(syncPolicyAdminList);
            }
            if (authorizationTokens != null) {
                usrElement.setExternalStorageAuthorized(true);
            } else {
                usrElement.setExternalStorageAuthorized(false);
            }
        } else {
            return null;
        }
        return usrElement;
    }

    private String getCommentsForErrorCode(int errorCode) {
        String comments = "";
        if (errorCode == 0) {
            return "Newly created user";
        }
        if (errorCode == 201) {
            comments = "User not present in SharePoint";
        }
        if (errorCode == 202) {
            comments = "User OneDrive license invalid";
        }
        if (errorCode == 203) {
            comments = "Insufficient space in OneDrive subscription to use for backup";
        }
        if (errorCode == 404) {
            comments = "User site not found. Make sure the email ID provided is valid";
        }
        if (errorCode == 403) {
            comments = "OneDrive permission denied";
        }
        if (errorCode == 204) {
            comments = "OneDrive target not assigned";
        }
        return comments;
    }
}

