/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.udc.service.impl;

import com.parablu.bluvault.udc.service.EventHubManagementService;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.BackupFolderElement;
import com.parablu.pcbd.dao.AuditHistoryDao;
import com.parablu.pcbd.dao.BackupFoldersDao;
import com.parablu.pcbd.dao.BackupPolicyDao;
import com.parablu.pcbd.dao.DeviceDao;
import com.parablu.pcbd.dao.EventHubDao;
import com.parablu.pcbd.dao.InclusionFilterDao;
import com.parablu.pcbd.domain.AuditHistory;
import com.parablu.pcbd.domain.BackupBatch;
import com.parablu.pcbd.domain.BackupFolders;
import com.parablu.pcbd.domain.EventHub;
import com.parablu.pcbd.domain.Schedule;
import com.parablu.pcsd.dao.SyncPolicyDao;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventHubManagementServiceImpl
implements EventHubManagementService {
    private static Logger logger = LoggerFactory.getLogger(EventHubManagementServiceImpl.class);
    private static final String STARTED = "STARTED";
    @Resource
    private EventHubDao eventHubDao;
    @Resource
    private DeviceDao deviceDao;
    @Resource
    SyncPolicyDao syncPolicyDao;
    @Resource
    BackupPolicyDao backupPolicyDao;
    @Resource
    private BackupFoldersDao backupFoldersDao;
    @Resource
    private InclusionFilterDao inclusionFilterDao;
    @Resource
    private AuditHistoryDao auditHistoryDao;

    public EventHubDao getEventHubDao() {
        return this.eventHubDao;
    }

    public void setEventHubDao(EventHubDao eventHubDao) {
        this.eventHubDao = eventHubDao;
    }

    @Override
    public void saveAction(int cloudId, String cloudName, EventHub eventHub) {
        this.eventHubDao.saveAction(cloudId, cloudName, eventHub);
    }

    @Override
    public void changeStatus(int cloudId, String cloudName, EventHub eventHub) {
        this.eventHubDao.changeStatus(cloudId, cloudName, eventHub);
    }

    @Override
    public List<String> getActionsByUserNameAndAction(int cloudId, String cloudName, EventHub eventHub) {
        List eventHubList = this.eventHubDao.getActionsByUserNameAndActionByDeviceUUID(cloudId, cloudName, eventHub);
        return eventHubList.stream().filter(line -> Objects.nonNull(line.getAction())).map(line -> line.getAction()).collect(Collectors.toList());
    }

    @Override
    public void deleteAction(int cloudId, String cloudName, EventHub eventHub) {
        this.eventHubDao.deleteAction(cloudId, cloudName, eventHub);
    }

    @Override
    public void deleteAllLogEvents(int cloudId, String cloudName, EventHub eventHub) {
        this.eventHubDao.deleteAction(cloudId, cloudName, eventHub);
        eventHub.setAction(PCHelperConstant.EVENTHUB_ACTION.PULL_HISTORICAL_LOGS.toString());
        this.eventHubDao.deleteAction(cloudId, cloudName, eventHub);
    }

    @Override
    public boolean checkActionIsPresent(int cloudId, String cloudName, EventHub eventHub) {
        return this.eventHubDao.checkActionIsPresent(cloudId, cloudName, eventHub);
    }

    @Override
    public void saveActionFromBackupFolder(int cloudId, String cloudName, BackupFolderElement backupFolderElement, String userName) {
        BackupFolders existingBackupFolders = this.backupFoldersDao.getBackupFolders(cloudId, cloudName, backupFolderElement.getFolderPath());
        List backupPolicyList = this.backupPolicyDao.getAllBackupPolicies(cloudId);
        backupPolicyList.forEach(backupPolicy -> {
            if (backupPolicy.getBackupFolders().contains(existingBackupFolders)) {
                this.backupPolicyDao.updatePolicyModifiedTime(cloudId, backupPolicy.getId());
            }
        });
    }

    @Override
    public void saveActionFromBackupScheduler(int cloudId, String cloudName, Schedule schedule, String userName) {
        List backupPolicyList = this.backupPolicyDao.getAllBackupPolicies(cloudId);
        backupPolicyList.forEach(backupPolicy -> backupPolicy.getSchedules().forEach(schedules -> {
            if (schedules.getScheduleName().equals(schedule.getScheduleName())) {
                this.backupPolicyDao.updatePolicyModifiedTime(cloudId, backupPolicy.getId());
            }
        }));
    }

    @Override
    public List<String> getActionForDevice(int cloudId, String cloudName, EventHub eventHub, long timeStampOfPolicyModified, long devicePolicyUpdatedTime) {
        logger.debug("Inisde getActionForDevice ..............");
        List eventHubList = this.eventHubDao.getActionsByUserNameAndActionByDeviceUUID(cloudId, cloudName, eventHub);
        List<String> actions = eventHubList.stream().filter(action -> Objects.nonNull(action.getAction())).map(action -> action.getAction()).collect(Collectors.toList());
        if (actions.contains(PCHelperConstant.EVENTHUB_ACTION.BACKUPPOLICY_REFRESH.toString())) {
            logger.debug("Actions contains backupPolicy refresh so return");
            return actions;
        }
        return this.checkPolicyModifiedAndReturnActions(cloudId, cloudName, eventHub, actions, timeStampOfPolicyModified, devicePolicyUpdatedTime);
    }

    private List<String> checkPolicyModifiedAndReturnActions(int cloudId, String cloudName, EventHub eventHub, List<String> actions, long timeStampOfPolicyModified, long devicePolicyUpdatedTime) {
        logger.debug(devicePolicyUpdatedTime + "....device...usertime...." + timeStampOfPolicyModified);
        if (devicePolicyUpdatedTime < timeStampOfPolicyModified) {
            actions.add(PCHelperConstant.EVENTHUB_ACTION.BACKUPPOLICY_REFRESH.toString());
            eventHub.setAction(PCHelperConstant.EVENTHUB_ACTION.BACKUPPOLICY_REFRESH.toString());
            this.eventHubDao.saveAction(cloudId, cloudName, eventHub);
        }
        return actions;
    }

    @Override
    public void deleteAllActionByDeviceUUID(int cloudId, EventHub eventHub) {
        this.eventHubDao.deleteAllActionByDeviceUUID(cloudId, eventHub);
    }

    @Override
    public void deleteActionBasedOnBackupBatchStatus(int cloudId, String cloudName, String DeviceUUID, String action, BackupBatch backupBatch) {
        if (action.equalsIgnoreCase(STARTED) || action.equalsIgnoreCase("STARTED/COMPLETED")) {
            this.eventHubDao.deleteActionBasedOnBackupBatchStatus(cloudId, DeviceUUID, PCHelperConstant.EVENTHUB_ACTION.START_BACKUP.toString());
        }
    }

    void saveStatisticToDatabase(int cloudId, String cloudName, String action, String actionByUser, String actionOnUser, String actionUsingObject, long timeStamp, int actionType) {
        AuditHistory audit = new AuditHistory();
        audit.setAction(action);
        audit.setActionByUserName(actionByUser);
        audit.setActionOnObject(actionOnUser);
        audit.setTimestamp(timeStamp);
        audit.setActionUsingObject(actionUsingObject);
        audit.setActionType(actionType);
        this.auditHistoryDao.saveAudit(cloudId, cloudName, audit);
    }

    @Override
    public void updateBackupBatchForStopAndPauseBkp(int cloudId, String actionToDeviceUUID, String errorCode) {
        this.eventHubDao.updateBackupBatchForStopAndPauseBkp(cloudId, actionToDeviceUUID, errorCode);
    }
}

