/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.udc.controller;

import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.cloud.security.service.DeviceAndUserSecurityService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.cloud.security.to.DeviceStatusTo;
import com.parablu.helper.exceptions.BaseException;
import com.parablu.paracloud.util.CacheHelper;
import com.parablu.paracloud.util.TokenGenerator;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class SessionController
extends BaseController {
    private static Logger logger = LoggerFactory.getLogger(SessionController.class);
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private DeviceAndUserSecurityService deviceAndUserSecurityService;
    private static final String CLOUD_NAME = "cloudName";
    private static final String VERSION_NUMBER = "versionNumber";
    private static final String TOKEN = "token";

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/sessions"}, method={RequestMethod.GET})
    @ResponseBody
    public Object generateAuthenticationToken(@PathVariable(value="versionNumber") String versionNumber1, @PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling generate Authentication token ...");
        String cloudName = cloudName1;
        try {
            String token = request.getHeader(TOKEN);
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                logger.debug("Cloud License : " + response.getStatus());
                return this.toJSON(cl.getCloudLicenseStatus());
            }
            int cloudId = cl.getCloud().getCloudId();
            DeviceStatusTo code = this.deviceAndUserSecurityService.validateDevice(cloudId, cloudName = cl.getCloud().getCloudName(), token, cl.getCloud());
            if (!this.checkLicense(code.getStatus(), response)) {
                logger.debug("Device session expired : " + response.getStatus());
                return this.toJSON(cl.getCloudLicenseStatus());
            }
            String newtoken = TokenGenerator.generateToken();
            CacheHelper cacheHelper = new CacheHelper();
            cacheHelper.addValueToCache(newtoken, code.getUserName() + ":" + cloudName, 45);
            HashMap<String, String> responseMap = new HashMap<String, String>();
            responseMap.put(TOKEN, newtoken);
            responseMap.put(CLOUD_NAME, cloudName);
            response.setStatus(200);
            Map paramMap = request.getParameterMap();
            return this.toJSON(200, this.getMetadataElement(1, 1, 1L, request.getRequestURI(), paramMap), responseMap);
        }
        catch (DataIntegrityViolationException e) {
            response.setStatus(403);
            logger.trace(" DataIntegrityViolationException  :" + (Object)((Object)e));
            logger.error(" DataIntegrityViolationException  :" + e.getMessage());
            return this.toJSON(1209);
        }
        catch (DataAccessException e) {
            response.setStatus(401);
            logger.trace(" DataAccessException  :" + (Object)((Object)e));
            logger.error(" DataAccessException  :" + e.getMessage());
            return this.toJSON(1209);
        }
        catch (BaseException e) {
            response.setStatus(401);
            logger.trace(" BaseException  :" + (Object)((Object)e));
            logger.error(" BaseException  :" + e.getMessage());
            return this.toJSON(1210);
        }
        catch (Exception e) {
            response.setStatus(500);
            logger.trace(" Exception  :" + e);
            logger.error(" Exception  :" + e.getMessage());
            return this.toJSON(1203);
        }
    }
}

