/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.udc.controller;

import com.parablu.bluvault.udc.service.AlertHistoryService;
import com.parablu.bluvault.udc.service.MiniCloudAccessControlService;
import com.parablu.cloud.security.service.AuthorizationService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.helper.element.ErrorElement;
import com.parablu.helper.response.ResponseHandler;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.pcbd.domain.AuthorizationTokens;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.SearchIndex;
import com.parablu.pcbd.domain.User;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public abstract class BaseController
extends ResponseHandler {
    private static Logger logger = LoggerFactory.getLogger(BaseController.class);
    @Autowired
    protected ErrorElement errorElement;
    @Autowired
    protected AuthorizationService authorizationService;
    @Autowired
    private MiniCloudAccessControlService miniCloudAccessControlService;
    @Autowired
    protected AlertHistoryService ahservice;
    protected static final String XML_VIEW = "xmlview";
    protected static final String HTTP_ERROR_MESSAGE = "errorMessage";
    protected static final int BACKUP_USER = 0;
    protected static final int SYNC_USER = 1;
    protected static final String GZIP_VIEW = "xmlview";
    protected static final String JSON_VIEW = "jsonview";
    protected static final String APLLICATION_XML = "application/xml";

    public void setErrorElement(ErrorElement errorElement) {
        this.errorElement = errorElement;
    }

    protected void closeInputStreamIfExists(HttpServletRequest request) {
        try {
            if (request.getInputStream() != null) {
                request.getInputStream().close();
            }
        }
        catch (IOException e) {
            logger.debug("", (Throwable)e);
        }
    }

    protected boolean validateMiniCloudByName(HttpServletResponse response, int cloudId, String cloudName, User user, String[] sourceParams) {
        if (sourceParams.length != 1 && !this.miniCloudAccessControlService.validateMiniCloudOperationAccessForUser(cloudId, cloudName, user, sourceParams[1])) {
            response.setStatus(401);
            return false;
        }
        return true;
    }

    protected boolean validateMiniCloudByName(HttpServletResponse response, int cloudId, String cloudName, String user, String[] sourceParams) {
        if (sourceParams.length != 1 && !this.miniCloudAccessControlService.validateMiniCloudOperationAccessForUser(cloudId, cloudName, user, sourceParams[1])) {
            response.setStatus(401);
            return false;
        }
        return true;
    }

    public ErrorElement createErrorElement(String errorCode, String message) {
        if (StringUtils.hasText((String)message)) {
            this.errorElement.setMessage(message);
        } else {
            this.errorElement.setMessage("Invalid Request.");
        }
        if (StringUtils.hasText((String)errorCode)) {
            this.errorElement.setResponseCode(errorCode);
        } else {
            this.errorElement.setResponseCode("500");
        }
        return this.errorElement;
    }

    public ErrorElement createErrorElement() {
        this.errorElement.setMessage("Invalid Request.");
        this.errorElement.setResponseCode("500");
        return this.errorElement;
    }

    public void setSuccessResponseFields(HttpServletResponse response) {
        response.setStatus(200);
    }

    public boolean checkLicense(CloudLicenseTo cloudLicense, HttpServletResponse response) {
        if (cloudLicense == null) {
            logger.error("..... cloudlicense is null .... ");
            response.setStatus(400);
            return false;
        }
        int code = cloudLicense.getCloudLicenseStatus();
        logger.error("..... cloudlicense is not null  error code .... " + code);
        switch (code) {
            case 1500: {
                return true;
            }
            case 1501: {
                response.setStatus(416);
                return false;
            }
            case 1504: {
                response.setStatus(419);
                return false;
            }
            case 1520: {
                response.setStatus(420);
                return false;
            }
            case 1521: {
                response.setStatus(421);
                return false;
            }
            case 1509: {
                response.setStatus(401);
                return false;
            }
            case 1502: {
                response.setStatus(418);
                return false;
            }
            case 1503: {
                response.setStatus(417);
                return false;
            }
            case 1522: {
                response.setStatus(423);
                return false;
            }
            case 1525: {
                response.setStatus(403);
                return false;
            }
        }
        response.setStatus(400);
        return false;
    }

    public boolean checkLicense(int code, HttpServletResponse response) {
        switch (code) {
            case 1500: {
                return true;
            }
            case 1501: {
                response.setStatus(416);
                return false;
            }
            case 1502: {
                response.setStatus(418);
                return false;
            }
            case 1503: 
            case 1525: {
                response.setStatus(417);
                return false;
            }
            case 1535: {
                response.setStatus(417);
                return false;
            }
            case 1522: {
                response.setStatus(423);
                return false;
            }
            case 1504: {
                response.setStatus(419);
                return false;
            }
            case 1520: {
                response.setStatus(420);
                return false;
            }
            case 1521: {
                response.setStatus(421);
                return false;
            }
            case 1509: {
                response.setStatus(401);
                return false;
            }
        }
        return false;
    }

    protected void addSearchIndexToTable(Cloud cloud, List<SearchIndex> searchIndexs) {
        if (cloud.getContentSearchEnabled() == 1) {
            this.ahservice.addFilesToTable(searchIndexs, cloud.getCloudName());
        }
    }

    protected void addSearchIndexToTable(Cloud cloud, SearchIndex searchIndexs) {
        if (cloud.getContentSearchEnabled() == 1) {
            this.ahservice.addFileToTable(searchIndexs, cloud.getCloudName());
        }
    }

    protected boolean performAuthorization(int cloudId, String cloudName, String token, HttpServletResponse response) {
        int status = this.authorizationService.validateToken(cloudId, cloudName, token);
        logger.debug(cloudName + "  Validate ######  status " + status);
        switch (status) {
            case 0: {
                return true;
            }
            case 4: {
                logger.debug("  Validate ######  USER_BLOCKED ");
                response.setStatus(420);
                return false;
            }
            case 1: {
                logger.debug("  Validate ######  UNAUTHORIZED ");
                response.setStatus(401);
                return false;
            }
            case 2: {
                logger.debug("  Validate ######  TOKEN_EXPIRED ");
                response.setStatus(421);
                return false;
            }
            case 3: {
                logger.debug("  Validate ######  MULTIPLE_USER_LOGIN ");
                response.setStatus(424);
                return false;
            }
        }
        logger.debug("  Validate ######  HTTP_UNAUTHORIZED ");
        response.setStatus(401);
        return false;
    }

    protected boolean performAuthorization(int cloudId, String cloudName, String token, User user, HttpServletResponse response) {
        int status = this.authorizationService.validateToken(cloudId, cloudName, token, user);
        switch (status) {
            case 0: {
                return true;
            }
            case 4: {
                response.setStatus(420);
                return false;
            }
            case 1: {
                response.setStatus(401);
                return false;
            }
            case 2: {
                response.setStatus(421);
                return false;
            }
            case 3: {
                response.setStatus(424);
                return false;
            }
            case 5: {
                response.setStatus(400);
                return false;
            }
        }
        response.setStatus(401);
        logger.debug("HTTP Authorization error");
        return false;
    }

    protected boolean performAuthorization(int cloudId, String cloudName, AuthorizationTokens token, HttpServletResponse response) {
        int status = this.authorizationService.validateToken(cloudId, cloudName, token);
        switch (status) {
            case 0: {
                return true;
            }
            case 1: {
                response.setStatus(401);
                return false;
            }
            case 2: {
                response.setStatus(421);
                return false;
            }
            case 3: {
                response.setStatus(424);
                return false;
            }
        }
        response.setStatus(401);
        logger.debug("HTTP Authorization error");
        return false;
    }

    protected boolean checkIfUserIsValid(User user, int type, HttpServletResponse response) {
        if (type == 0) {
            if (user.isBackupEnabled() || user.isServerBackupEnabled()) {
                return true;
            }
        } else if (type == 1) {
            if (user.isSyncEnabled()) {
                return true;
            }
            logger.debug("Invalid user type");
            return false;
        }
        response.setStatus(401);
        return false;
    }

    protected boolean checkIfDeviceIsAttached(String cloudName, HttpServletResponse response) {
        if (new File(PCHelperConstant.getPropertyFileValueParabluFolderBasePath((String)cloudName)).exists()) {
            return true;
        }
        response.setStatus(427);
        return false;
    }

    protected String decodeBase64UTFString(String encodedString) {
        String decodedString = encodedString;
        try {
            decodedString = new String(Base64.decodeBase64((String)encodedString), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.debug("UnsupportedEncodingException", (Throwable)e);
        }
        return decodedString;
    }

    protected int getTokenValidationResponseStatusCode(HttpServletResponse response) {
        int status = response.getStatus();
        switch (status) {
            case 420: {
                return 1520;
            }
            case 401: {
                return 1210;
            }
            case 421: {
                return 1201;
            }
            case 3: {
                logger.debug("  Validate ######  MULTIPLE_USER_LOGIN ");
                response.setStatus(424);
                return 1213;
            }
        }
        return 1210;
    }
}

