/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.utility;

import com.google.common.collect.Iterables;
import java.io.File;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.jclouds.ContextBuilder;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.domain.Location;
import org.jclouds.openstack.swift.v1.SwiftApiMetadata;

public class BackBlaze {
    private static final String NUM_1048576 = "1048576";

    public static void main(String[] args) throws ConfigurationException {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String keyID = config.getProperty("keyID").toString();
        String applicationKey = config.getProperty("applicationKey").toString();
        String bucketName = config.getProperty("bucketName").toString();
        String folderName = config.getProperty("folderName").toString();
        String filePath = config.getProperty("filePath").toString();
        BackBlaze.uploadToCloud("b2", keyID, applicationKey, bucketName, new File(filePath), folderName);
    }

    private static boolean uploadToCloud(String provider, String identity, String passKey, String containerName, File file, String directoryName) {
        boolean uploadSuccess = false;
        String containerNameTemp = containerName;
        String fileName = file.getName();
        System.out.println("jar started..." + file.getAbsolutePath());
        try (BlobStoreContext context = null;){
            boolean blobExists;
            context = BackBlaze.getBlobStoreContext(provider, identity, passKey, NUM_1048576, 2);
            ApiMetadata apiMetadata = context.unwrap().getProviderMetadata().getApiMetadata();
            BlobStore blobStore = context.getBlobStore();
            Location location = null;
            if (apiMetadata instanceof SwiftApiMetadata) {
                location = (Location)Iterables.getFirst((Iterable)blobStore.listAssignableLocations(), null);
            }
            if (!(blobExists = BackBlaze.createContainerIfNotExists(containerNameTemp, blobStore, location))) {
                System.out.println("Container not exists :" + containerNameTemp);
                return false;
            }
            try {
                fileName = String.valueOf(directoryName) + "/" + fileName;
                String fileSize = BackBlaze.formatFileSizeIncludeKB(file.length() / 1024L);
                System.out.println("file Name :\"" + file.getName() + "\" and Size :" + fileSize + " started on :" + new Date());
                Blob blob = blobStore.blobBuilder(fileName).payload(file).contentLength(file.length()).build();
                if (file.length() > 0x500000L) {
                    "b2".equalsIgnoreCase(provider);
                }
                String putBlobStr = "";
                putBlobStr = file.length() > 0x500000L ? blobStore.putBlob(containerNameTemp, blob, PutOptions.Builder.multipart()) : blobStore.putBlob(containerNameTemp, blob);
                System.out.println("uploaded status :" + putBlobStr + " end time :" + new Date());
                uploadSuccess = true;
            }
            catch (Error ee) {
                ee.printStackTrace();
                System.out.println(String.valueOf(fileName) + " new......upload error .... " + ee.getMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println(String.valueOf(fileName) + " ....upload failed .... " + e.getMessage());
                uploadSuccess = false;
            }
        }
        return uploadSuccess;
    }

    public static String formatFileSizeIncludeKB(long size) {
        double k = size;
        double m = (double)size / 1024.0;
        double g = (double)size / 1024.0 / 1024.0;
        double t = (double)size / 1024.0 / 1024.0 / 1024.0;
        DecimalFormat dec = new DecimalFormat("0.00");
        String hrSize = t > 1.0 ? dec.format(t).concat(" TB") : (g > 1.0 ? dec.format(g).concat(" GB") : (m > 1.0 ? dec.format(m).concat(" MB") : dec.format(k).concat(" KB")));
        return hrSize;
    }

    private static boolean createContainerIfNotExists(String containerNameTemp, BlobStore blobStore, Location location) {
        boolean blobExists = false;
        try {
            boolean containerExists = blobStore.containerExists(containerNameTemp);
            if (containerExists) {
                blobExists = true;
            } else {
                boolean isContainerCreated = blobStore.createContainerInLocation(location, containerNameTemp);
                if (isContainerCreated) {
                    blobExists = true;
                }
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
            blobExists = false;
        }
        return blobExists;
    }

    private static BlobStoreContext getBlobStoreContext(String providerId, String identity, String passKey, String partSize, int numThreads) {
        Properties properties = new Properties();
        if (!StringUtils.isEmpty((CharSequence)identity)) {
            properties.setProperty(String.valueOf(providerId) + ".identity", identity);
        }
        if (!StringUtils.isEmpty((CharSequence)passKey)) {
            properties.setProperty(String.valueOf(providerId) + ".credential", passKey);
        }
        properties.setProperty("jclouds.mpu.parts.size", partSize);
        properties.setProperty("jclouds.mpu.parallel.degree", Integer.toString(numThreads));
        properties.setProperty("jclouds.proxyHost", "https://192.168.1.1");
        properties.setProperty("jclouds.proxyPort", "3128");
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(new AuthScope("https://192.168.1.1", 3128), (Credentials)new UsernamePasswordCredentials("", ""));
        ContextBuilder credentials = ContextBuilder.newBuilder((String)providerId).overrides(properties);
        return (BlobStoreContext)credentials.buildView(BlobStoreContext.class);
    }
}

