/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.utility;

import com.backblaze.b2.client.B2StorageClient;
import com.backblaze.b2.client.B2StorageClientFactory;
import com.backblaze.b2.client.contentHandlers.B2ContentFileWriter;
import com.backblaze.b2.client.contentHandlers.B2ContentSink;
import com.backblaze.b2.client.contentSources.B2ContentSource;
import com.backblaze.b2.client.contentSources.B2FileContentSource;
import com.backblaze.b2.client.exceptions.B2Exception;
import com.backblaze.b2.client.structures.B2Bucket;
import com.backblaze.b2.client.structures.B2CorsRule;
import com.backblaze.b2.client.structures.B2FileVersion;
import com.backblaze.b2.client.structures.B2GetDownloadAuthorizationRequest;
import com.backblaze.b2.client.structures.B2ListFileNamesRequest;
import com.backblaze.b2.client.structures.B2ListFileVersionsRequest;
import com.backblaze.b2.client.structures.B2Part;
import com.backblaze.b2.client.structures.B2UpdateBucketRequest;
import com.backblaze.b2.client.structures.B2UploadFileRequest;
import com.backblaze.b2.json.B2Json;
import com.backblaze.b2.json.B2JsonException;
import com.backblaze.b2.util.B2ExecutorUtils;
import com.backblaze.b2.util.B2IoUtils;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class B2
implements AutoCloseable {
    private static final String APP_NAME = "b2_4j";
    private static final String VERSION = "0.0.1";
    private static final String USER_AGENT = "b2_4j/0.0.1";
    private static final String USAGE = "USAGE:\n    b2 cancel_all_unfinished_large_files <bucketName>\n    b2 cancel_large_file <fileId>\n    b2 create_bucket <bucketName> [allPublic | allPrivate]\n    b2 delete_bucket <bucketName>\n    b2 delete_file_version <fileName> <fileId>\n    b2 download_file_by_id [--noProgress] <fileId> <localFileName>\n    b2 download_file_by_name [--noProgress] <bucketName> <fileName> <localFileName>\n    b2 finish_uploading_large_file [--noProgress] [--threads N] <bucketName> <largeFileId> <localFileName>\n    b2 get_download_authorization [--noProgress] <bucketName> <fileName>\n    b2 get_download_file_by_id_url [--noProgress] <fileId>\n    b2 get_download_file_by_name_url [--noProgress] <bucketName> <fileName>\n    b2 get_file_info <fileId>\n    b2 hide_file <bucketName> <fileName>\n    b2 list_buckets\n    b2 list_file_names <bucketName> [<startFileName>] [<maxPerFetch>]  // unlike the python b2 cmd, this will continue fetching, until done.\n    b2 list_file_versions <bucketName> [<startFileName>] [<startFileId>] [<maxPerFetch>]  // unlike the python b2 cmd, this will continue fetching, until done.\n    b2 list_parts <largeFileId>\n    b2 list_unfinished_large_files <bucketName>\n    b2 update_bucket <bucketName> [allPublic | allPrivate]\n    b2 update_bucket_cors_rules <bucketName> [rules | @rules.json]\n    b2 upload_file [--sha1 <sha1sum>] [--contentType <contentType>] [--info <key>=<value>]* \\\n        [--noProgress] [--threads N] <bucketName> <localFilePath> <b2FileName>\n    b2 upload_large_file [--sha1 <sha1sum>] [--contentType <contentType>] [--info <key>=<value>]* \\\n        [--noProgress] [--threads N] <bucketName> <localFilePath> <b2FileName>\n    b2 version\n";
    private final PrintStream out = System.out;
    private final B2StorageClient client;
    private boolean showProgress = true;
    private int numThreads = 6;
    private ExecutorService executor;

    private B2() {
        System.out.println(System.getenv("B2_APPLICATION_KEY"));
        this.client = B2StorageClientFactory.createDefaultFactory().create("", "", "B2ClientConfigTest/0.0.1");
    }

    private ExecutorService getExecutor() {
        if (this.executor == null) {
            this.executor = Executors.newFixedThreadPool(this.numThreads, B2ExecutorUtils.createThreadFactory((String)"b2_4j-%d"));
        }
        return this.executor;
    }

    @Override
    public void close() {
        B2IoUtils.closeQuietly((Closeable)this.client);
        if (this.executor != null) {
            B2ExecutorUtils.shutdownAndAwaitTermination((ExecutorService)this.executor, (int)10, (int)10);
            this.executor = null;
        }
    }

    private static void usageAndExit(String errMsg) {
        System.err.println("ERROR: " + errMsg);
        System.err.println();
        System.err.println(USAGE);
        System.exit(1);
    }

    public static void main(String[] args) throws B2Exception, IOException, B2JsonException {
        if (args.length == 0) {
            B2.usageAndExit("you must specify which command you want to run.");
        }
        String command = args[0];
        String[] remainingArgs = Arrays.copyOfRange(args, 1, args.length);
        Throwable throwable = null;
        Object var4_5 = null;
        try (B2 b2 = new B2();){
            if ("cancel_all_unfinished_large_files".equals(command)) {
                b2.cancel_all_unfinished_large_files(remainingArgs);
            } else if ("cancel_large_file".equals(command)) {
                b2.cancel_large_file(remainingArgs);
            } else if ("create_bucket".equals(command)) {
                b2.create_bucket(remainingArgs);
            } else if ("delete_bucket".equals(command)) {
                b2.delete_bucket(remainingArgs);
            } else if ("delete_file_version".equals(command)) {
                b2.delete_file_version(remainingArgs);
            } else if ("download_file_by_id".equals(command)) {
                b2.download_file_by_id(remainingArgs);
            } else if ("download_file_by_name".equals(command)) {
                b2.download_file_by_name(remainingArgs);
            } else if ("finish_uploading_large_file".equals(command)) {
                b2.finish_uploading_large_file(remainingArgs);
            } else if ("get_download_authorization".equals(command)) {
                b2.get_download_authorization(remainingArgs);
            } else if ("get_download_file_by_id_url".equals(command)) {
                b2.get_download_file_by_id_url(remainingArgs);
            } else if ("get_download_file_by_name_url".equals(command)) {
                b2.get_download_file_by_name_url(remainingArgs);
            } else if ("get_file_info".equals(command)) {
                b2.get_file_info(remainingArgs);
            } else if ("hide_file".equals(command)) {
                b2.hide_file(remainingArgs);
            } else if ("list_buckets".equals(command)) {
                b2.list_buckets(remainingArgs);
            } else if ("list_file_names".equals(command)) {
                b2.list_file_names(remainingArgs);
            } else if ("list_file_versions".equals(command)) {
                b2.list_file_versions(remainingArgs);
            } else if ("list_parts".equals(command)) {
                b2.list_parts(remainingArgs);
            } else if ("list_unfinished_large_files".equals(command)) {
                b2.list_unfinished_large_files(remainingArgs);
            } else if ("update_bucket".equals(command)) {
                b2.update_bucket(remainingArgs);
            } else if ("update_bucket_cors_rules".equals(command)) {
                b2.update_bucket_cors_rules(remainingArgs);
            } else if ("upload_file".equals(command)) {
                b2.upload_file(remainingArgs, false);
            } else if ("upload_large_file".equals(command)) {
                b2.upload_file(remainingArgs, true);
            } else if ("version".equals(command)) {
                b2.version(remainingArgs);
            } else {
                B2.usageAndExit("unsupported command '" + command + "'");
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void checkArgs(boolean isOk, String errMsg) {
        if (!isOk) {
            B2.usageAndExit(errMsg);
        }
    }

    private void checkArgCount(String[] args, int minCount, int maxCount) {
        this.checkArgs(args.length >= minCount, "too few arguments");
        this.checkArgs(args.length <= maxCount, "too many arguments");
    }

    private void checkArgCount(String[] args, int exactCount) {
        this.checkArgCount(args, exactCount, exactCount);
    }

    private void checkArgCountIsAtLeast(String[] args, int minCount) {
        this.checkArgCount(args, minCount, Integer.MAX_VALUE);
    }

    private String getArgOrDie(String[] args, String arg, int iArg, int iLastArg) {
        if (iArg > iLastArg) {
            B2.usageAndExit("missing argument for '" + arg + "'");
        }
        return args[iArg];
    }

    private String getArgOrNull(String[] args, int iArg) {
        if (iArg >= args.length) {
            return null;
        }
        return args[iArg];
    }

    private Integer getPositiveIntOrNull(String[] args, String arg, int iArg) {
        String asString = this.getArgOrNull(args, iArg);
        if (asString == null) {
            return null;
        }
        try {
            return Integer.parseInt(asString);
        }
        catch (NumberFormatException e) {
            B2.usageAndExit("argument for '" + arg + "' must be an integer");
            return 666;
        }
    }

    private int getIntArgOrDie(String[] args, String arg, int iArg, int iLastArg) {
        String asString = this.getArgOrDie(args, arg, iArg, iLastArg);
        try {
            return Integer.parseInt(asString);
        }
        catch (NumberFormatException e) {
            B2.usageAndExit("argument for '" + arg + "' must be an integer");
            return 666;
        }
    }

    private int getPositiveIntArgOrDie(String[] args, String arg, int iArg, int iLastArg) {
        int value = this.getIntArgOrDie(args, arg, iArg, iLastArg);
        if (value <= 0) {
            B2.usageAndExit("argument for '" + arg + "' must be a POSITIVE integer");
        }
        return value;
    }

    private void handleCommonArgsOrDie(String[] args, int iFirstArg, int iLastArg) {
        int iArg = iFirstArg;
        while (iArg <= iLastArg) {
            String arg = args[iArg];
            if ("--noProgress".equals(arg)) {
                this.showProgress = false;
            } else if ("--threads".equals(arg)) {
                this.numThreads = this.getPositiveIntArgOrDie(args, arg, ++iArg, iLastArg);
            } else {
                B2.usageAndExit("unexpected argument '" + arg + "'");
            }
            ++iArg;
        }
    }

    private B2Bucket getBucketByNameOrDie(String bucketName) throws B2Exception {
        for (B2Bucket bucket : this.client.buckets()) {
            if (!bucket.getBucketName().equals(bucketName)) continue;
            return bucket;
        }
        B2.usageAndExit("can't find bucket named '" + bucketName + "'");
        throw new RuntimeException("usageAndExit never returns!");
    }

    private B2FileVersion getUnfinishedLargeFileOrDie(String bucketId, String largeFileId) throws B2Exception {
        for (B2FileVersion version : this.client.unfinishedLargeFiles(bucketId)) {
            if (!version.getFileId().equals(largeFileId)) continue;
            return version;
        }
        B2.usageAndExit("can't find unfinished large file " + largeFileId);
        throw new RuntimeException("usageAndExit never returns!");
    }

    private B2UploadFileRequest makeUploadRequestFromArgs(String[] args) throws B2Exception {
        this.checkArgCountIsAtLeast(args, 3);
        int iLastArg = args.length - 1;
        String b2Path = args[iLastArg];
        String localPath = args[--iLastArg];
        String bucketName = args[--iLastArg];
        --iLastArg;
        String sha1 = null;
        String contentType = "b2/x-auto";
        TreeMap<String, String> infos = new TreeMap<String, String>();
        int iArg = 0;
        while (iArg <= iLastArg) {
            String arg = args[iArg];
            if ("--sha1".equals(arg)) {
                sha1 = this.getArgOrDie(args, arg, ++iArg, iLastArg);
            } else if ("--noProgress".equals(arg)) {
                this.showProgress = false;
            } else if ("--contentType".equals(arg)) {
                contentType = this.getArgOrDie(args, arg, ++iArg, iLastArg);
            } else if ("--threads".equals(arg)) {
                this.numThreads = this.getPositiveIntArgOrDie(args, arg, ++iArg, iLastArg);
            } else if ("--info".equals(arg)) {
                String pair;
                String[] vParts;
                if ((vParts = (pair = this.getArgOrDie(args, arg, ++iArg, iLastArg)).split("=")).length != 2 || vParts[0].isEmpty()) {
                    B2.usageAndExit("bad format for argument to '" + arg + "' (" + pair + ")");
                }
                infos.put(vParts[0], vParts[1]);
            } else {
                B2.usageAndExit("unexpected argument '" + arg + "'");
            }
            ++iArg;
        }
        B2Bucket bucket = this.getBucketByNameOrDie(bucketName);
        B2FileContentSource source = B2FileContentSource.builder((File)new File(localPath)).setSha1(sha1).build();
        return B2UploadFileRequest.builder((String)bucket.getBucketId(), (String)b2Path, (String)contentType, (B2ContentSource)source).setCustomFields(infos).build();
    }

    private void cancel_all_unfinished_large_files(String[] args) throws B2Exception {
        this.checkArgCount(args, 1);
        String bucketName = args[0];
        B2Bucket bucket = this.getBucketByNameOrDie(bucketName);
        for (B2FileVersion version : this.client.unfinishedLargeFiles(bucket.getBucketId())) {
            this.out.println("  about to cancel unfinished large file: " + version);
            this.client.cancelLargeFile(version.getFileId());
        }
    }

    private void cancel_large_file(String[] args) throws B2Exception {
        this.checkArgCount(args, 1);
        String largeFileId = args[0];
        this.client.cancelLargeFile(largeFileId);
    }

    private void create_bucket(String[] args) throws B2Exception {
        this.checkArgCount(args, 2);
        String bucketName = args[0];
        String bucketType = args[1];
        this.client.createBucket(bucketName, bucketType);
    }

    private void update_bucket(String[] args) throws B2Exception {
        this.checkArgCount(args, 2);
        String bucketName = args[0];
        String bucketType = args[1];
        B2Bucket bucket = this.getBucketByNameOrDie(bucketName);
        B2UpdateBucketRequest request = B2UpdateBucketRequest.builder((B2Bucket)bucket).setBucketType(bucketType).build();
        this.client.updateBucket(request);
    }

    private void update_bucket_cors_rules(String[] args) throws B2Exception, B2JsonException {
        this.checkArgCount(args, 2);
        String bucketName = args[0];
        String rulesString = args[1];
        List<B2CorsRule> corsRules = this.parseRules(rulesString);
        B2Bucket bucket = this.getBucketByNameOrDie(bucketName);
        B2UpdateBucketRequest request = B2UpdateBucketRequest.builder((B2Bucket)bucket).setCorsRules(corsRules).build();
        this.client.updateBucket(request);
    }

    private List<B2CorsRule> parseRules(String rulesString) throws B2JsonException {
        B2Json b2Json = B2Json.get();
        String rulesJson = rulesString.startsWith("@") ? this.readFile(rulesString.substring(1)) : rulesString;
        return b2Json.listFromJson(rulesJson, B2CorsRule.class);
    }

    /*
     * Loose catch block
     */
    private String readFile(String fileName) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                String string;
                ByteArrayOutputStream out;
                FileInputStream in;
                block18: {
                    block17: {
                        in = new FileInputStream(fileName);
                        out = new ByteArrayOutputStream();
                        B2IoUtils.copy((InputStream)in, (OutputStream)out);
                        string = out.toString();
                        if (out == null) break block17;
                        out.close();
                    }
                    if (in == null) break block18;
                    in.close();
                }
                return string;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (out != null) {
                                out.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (in != null) {
                                in.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("trouble reading from " + fileName + ": " + e.getMessage(), e);
        }
    }

    private void delete_bucket(String[] args) throws B2Exception {
        this.checkArgCount(args, 1);
        B2Bucket bucket = this.getBucketByNameOrDie(args[0]);
        this.client.deleteBucket(bucket.getBucketId());
    }

    private void delete_file_version(String[] args) throws B2Exception {
        this.checkArgCount(args, 2);
        String b2Path = args[0];
        String fileId = args[1];
        this.client.deleteFileVersion(b2Path, fileId);
    }

    private void download_file_by_id(String[] args) throws B2Exception {
        this.checkArgCount(args, 2, 3);
        int iLastArg = args.length - 1;
        String fileId = args[iLastArg - 1];
        String localFileName = args[iLastArg];
        this.handleCommonArgsOrDie(args, 0, iLastArg - 2);
        B2ContentFileWriter sink = B2ContentFileWriter.builder((File)new File(localFileName)).setVerifySha1ByRereadingFromDestination(true).build();
        this.client.downloadById(fileId, (B2ContentSink)sink);
    }

    private void get_download_authorization(String[] args) throws B2Exception, B2JsonException {
        this.checkArgCount(args, 3, 4);
        int iLastArg = args.length - 1;
        String bucketId = args[iLastArg - 2];
        String fileNamePrefix = args[iLastArg - 1];
        int validDurationInSecs = this.getPositiveIntArgOrDie(args, "validDurationInSecs", iLastArg, iLastArg);
        B2GetDownloadAuthorizationRequest request = B2GetDownloadAuthorizationRequest.builder((String)bucketId, (String)fileNamePrefix, (int)validDurationInSecs).setB2ContentDisposition("attachment; filename=\"helloHagi.txt\"").build();
        this.out.println("  downloadAuth:  " + B2Json.get().toJson((Object)this.client.getDownloadAuthorization(request)));
    }

    private void get_download_file_by_id_url(String[] args) throws B2Exception {
        this.checkArgCount(args, 1, 2);
        int iLastArg = args.length - 1;
        String fileId = args[iLastArg];
        this.handleCommonArgsOrDie(args, 0, iLastArg - 1);
        this.out.println("  url:  " + this.client.getDownloadByIdUrl(fileId));
    }

    private void download_file_by_name(String[] args) throws B2Exception {
        this.checkArgCount(args, 3, 4);
        int iLastArg = args.length - 1;
        String bucketName = args[iLastArg - 2];
        String b2Path = args[iLastArg - 1];
        String localFileName = args[iLastArg];
        this.handleCommonArgsOrDie(args, 0, iLastArg - 3);
        B2ContentFileWriter sink = B2ContentFileWriter.builder((File)new File(localFileName)).setVerifySha1ByRereadingFromDestination(true).build();
        this.client.downloadByName(bucketName, b2Path, (B2ContentSink)sink);
    }

    private void get_download_file_by_name_url(String[] args) throws B2Exception {
        this.checkArgCount(args, 2, 3);
        int iLastArg = args.length - 1;
        String bucketName = args[iLastArg - 1];
        String b2Path = args[iLastArg];
        this.handleCommonArgsOrDie(args, 0, iLastArg - 2);
        this.out.println("  url:  " + this.client.getDownloadByNameUrl(bucketName, b2Path));
    }

    private void finish_uploading_large_file(String[] args) throws B2Exception {
        this.checkArgCount(args, 3, 5);
        int iLastArg = args.length - 1;
        String bucketName = args[iLastArg - 2];
        String largeFileId = args[iLastArg - 1];
        String localPath = args[iLastArg];
        this.handleCommonArgsOrDie(args, 0, iLastArg - 3);
        B2Bucket bucket = this.getBucketByNameOrDie(bucketName);
        B2FileVersion largeFileVersion = this.getUnfinishedLargeFileOrDie(bucket.getBucketId(), largeFileId);
        B2FileContentSource source = B2FileContentSource.builder((File)new File(localPath)).setSha1(largeFileVersion.getContentSha1()).build();
        B2UploadFileRequest request = B2UploadFileRequest.builder((String)bucket.getBucketId(), (String)largeFileVersion.getFileName(), (String)largeFileVersion.getContentType(), (B2ContentSource)source).setCustomFields(largeFileVersion.getFileInfo()).build();
        this.client.finishUploadingLargeFile(largeFileVersion, request, this.getExecutor());
    }

    private void get_file_info(String[] args) throws B2Exception {
        this.checkArgCount(args, 1);
        String fileId = args[0];
        B2FileVersion version = this.client.getFileInfo(fileId);
        this.out.println(version);
        this.out.println("  fileInfo:  " + version.getFileInfo());
    }

    private void hide_file(String[] args) throws B2Exception {
        this.checkArgCount(args, 2);
        String bucketName = args[0];
        String b2Path = args[1];
        B2Bucket bucket = this.getBucketByNameOrDie(bucketName);
        this.client.hideFile(bucket.getBucketId(), b2Path);
    }

    private void list_buckets(String[] args) throws B2Exception {
        this.checkArgCount(args, 0);
        for (B2Bucket bucket : this.client.buckets()) {
            this.out.println(bucket);
        }
    }

    private void list_file_names(String[] args) throws B2Exception {
        this.checkArgCount(args, 1, 3);
        String bucketName = args[0];
        String startFileName = this.getArgOrNull(args, 1);
        Integer maxPerFetch = this.getPositiveIntOrNull(args, "maxPerFetch", 2);
        B2Bucket bucket = this.getBucketByNameOrDie(bucketName);
        B2ListFileNamesRequest.Builder builder = B2ListFileNamesRequest.builder((String)bucket.getBucketId()).setMaxFileCount(maxPerFetch);
        if (startFileName != null) {
            builder.setStartFileName(startFileName);
        }
        B2ListFileNamesRequest request = builder.build();
        for (B2FileVersion version : this.client.fileNames(request)) {
            this.out.println(version);
        }
    }

    private void list_file_versions(String[] args) throws B2Exception {
        this.checkArgCount(args, 1, 4);
        String bucketName = args[0];
        String startFileName = this.getArgOrNull(args, 1);
        String startFileId = this.getArgOrNull(args, 2);
        Integer maxPerFetch = this.getPositiveIntOrNull(args, "maxPerFetch", 3);
        if (startFileName != null) {
            this.checkArgs(startFileId != null, "if you specify startFileName, you must specify startFileId too");
        }
        B2Bucket bucket = this.getBucketByNameOrDie(bucketName);
        B2ListFileVersionsRequest.Builder builder = B2ListFileVersionsRequest.builder((String)bucket.getBucketId()).setMaxFileCount(maxPerFetch);
        if (startFileName != null) {
            builder.setStart(startFileName, startFileId);
        }
        B2ListFileVersionsRequest request = builder.build();
        for (B2FileVersion version : this.client.fileVersions(request)) {
            this.out.println(version);
        }
    }

    private void list_unfinished_large_files(String[] args) throws B2Exception {
        this.checkArgCount(args, 1);
        String bucketName = args[0];
        B2Bucket bucket = this.getBucketByNameOrDie(bucketName);
        for (B2FileVersion version : this.client.unfinishedLargeFiles(bucket.getBucketId())) {
            this.out.println(version);
            this.out.println("  fileInfo:  " + version.getFileInfo());
        }
    }

    private void list_parts(String[] args) throws B2Exception {
        this.checkArgCount(args, 1);
        String largeFileId = args[0];
        for (B2Part part : this.client.parts(largeFileId)) {
            this.out.println(part);
        }
    }

    private void upload_file(String[] args, boolean forceLarge) throws B2Exception, IOException {
        B2UploadFileRequest request = this.makeUploadRequestFromArgs(args);
        long contentLength = request.getContentSource().getContentLength();
        if (forceLarge || this.client.getFilePolicy().shouldBeLargeFile(contentLength)) {
            this.client.uploadLargeFile(request, this.getExecutor());
        } else {
            this.client.uploadSmallFile(request);
        }
    }

    private void version(String[] args) {
        this.checkArgCount(args, 0);
        this.out.println("b2 command line tool in java, version 0.0.1");
    }
}

