/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.utility;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.parablu.model.BackBlazeAuthorize;
import com.parablu.model.BackBlazeBucket;
import com.parablu.model.BackBlazeBuckets;
import com.parablu.model.BackBlazeStartLargeFile;
import com.parablu.model.BackBlazeUploadLargeFileUrl;
import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonStructure;
import javax.json.JsonWriter;
import javax.xml.bind.annotation.adapters.HexBinaryAdapter;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;

public class AuthorizeAccountAndUpload {
    public static String proxyHost = "";
    public static int proxyPort = 0;
    public static String proxyUserName = "";
    public static String proxyPassword = "";

    public static void main(String[] args) throws Exception {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String applicationKeyId = config.getProperty("keyID").toString();
        String applicationKey = config.getProperty("applicationKey").toString();
        String bucketName = config.getProperty("bucketName").toString();
        String folderName = config.getProperty("folderName").toString();
        String filePath = config.getProperty("filePath").toString();
        proxyHost = config.getProperty("proxyHost").toString();
        if (!StringUtils.isEmpty((String)config.getProperty("proxyPort").toString())) {
            proxyPort = Integer.parseInt(config.getProperty("proxyPort").toString());
        }
        proxyUserName = config.getProperty("proxyUserName").toString();
        proxyPassword = config.getProperty("proxyPassword").toString();
        System.out.println(proxyHost);
        System.out.println(proxyPort);
        System.out.println(proxyUserName);
        System.out.println(proxyPassword);
        File file = new File(filePath);
        String authorizeAcc = AuthorizeAccountAndUpload.AuthorizeAcc(applicationKeyId, applicationKey);
        ObjectMapper mapper = new ObjectMapper();
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        System.out.println(authorizeAcc);
        BackBlazeAuthorize authorize = (BackBlazeAuthorize)mapper.readValue(authorizeAcc, BackBlazeAuthorize.class);
        System.out.println(authorize.getApiUrl());
        String bucketList = AuthorizeAccountAndUpload.getBucketList(authorize.getApiUrl(), applicationKeyId, authorize.getAuthorizationToken());
        System.out.println(bucketList);
        BackBlazeBuckets aadUserElement = (BackBlazeBuckets)mapper.readValue(bucketList, BackBlazeBuckets.class);
        System.out.println(aadUserElement.getBuckets().size());
        BackBlazeBucket orElse = aadUserElement.getBuckets().stream().filter(buck -> buck.getBucketName().equalsIgnoreCase(bucketName)).findFirst().orElse(null);
        if (orElse != null) {
            String startLargeFile = AuthorizeAccountAndUpload.startLargeFileUpload(authorize.getApiUrl(), authorize.getAuthorizationToken(), orElse.getBucketId(), String.valueOf(folderName) + "/" + file.getName());
            BackBlazeStartLargeFile startLargeFileObj = (BackBlazeStartLargeFile)mapper.readValue(startLargeFile, BackBlazeStartLargeFile.class);
            String uploadLargeFilePartUrl = AuthorizeAccountAndUpload.getUploadLargeFilePartUrl(startLargeFileObj.getFileId(), authorize.getAuthorizationToken(), authorize.getApiUrl());
            BackBlazeUploadLargeFileUrl backBlazeUploadLargeFileUrl = (BackBlazeUploadLargeFileUrl)mapper.readValue(uploadLargeFilePartUrl, BackBlazeUploadLargeFileUrl.class);
            System.out.println("********************************** Uploaded started..." + new Date());
            Object[] uploadFileAsChunk = AuthorizeAccountAndUpload.uploadFileAsChunk(backBlazeUploadLargeFileUrl.getUploadUrl(), backBlazeUploadLargeFileUrl.getAuthorizationToken(), authorize.getRecommendedPartSize(), file);
            String uploadString = (String)uploadFileAsChunk[0];
            if (!StringUtils.isEmpty((String)uploadString)) {
                ArrayList partSha1Array = (ArrayList)uploadFileAsChunk[1];
                AuthorizeAccountAndUpload.finishLargeFile(partSha1Array, startLargeFileObj.getFileId(), authorize.getAuthorizationToken(), authorize.getApiUrl());
            }
            System.out.println("********************************** Uploaded ended..." + new Date());
        }
    }

    private static String AuthorizeAcc(String applicationKeyId, String applicationKey) {
        HttpURLConnection connection = null;
        String jsonResponse = "";
        String headerForAuthorizeAccount = "Basic " + Base64.getEncoder().encodeToString((String.valueOf(applicationKeyId) + ":" + applicationKey).getBytes());
        try {
            try {
                URL url = new URL("https://api.backblazeb2.com/b2api/v2/b2_authorize_account");
                Proxy proxy = AuthorizeAccountAndUpload.getProxy();
                connection = proxy == null ? (HttpURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection(proxy);
                connection.setRequestMethod("GET");
                connection.setRequestProperty("Authorization", headerForAuthorizeAccount);
                BufferedInputStream in = new BufferedInputStream(connection.getInputStream());
                jsonResponse = AuthorizeAccountAndUpload.myInputStreamReader(in);
                System.out.println(jsonResponse);
            }
            catch (Exception e) {
                e.printStackTrace();
                connection.disconnect();
            }
        }
        finally {
            connection.disconnect();
        }
        return jsonResponse;
    }

    private static String getBucketList(String apiUrl, String accountId, String accountAuthorizationToken) throws IOException {
        HttpURLConnection connection = null;
        String result = "";
        try {
            try {
                URL url = new URL(String.valueOf(apiUrl) + "/b2api/v2/b2_list_buckets");
                Proxy proxy = AuthorizeAccountAndUpload.getProxy();
                connection = proxy == null ? (HttpURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection(proxy);
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Authorization", accountAuthorizationToken);
                connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                connection.setRequestProperty("charset", "utf-8");
                String json = "{\"accountId\":\"" + accountId + "\", \"bucketTypes\": [\"allPrivate\",\"allPublic\"]}";
                byte[] postData = json.getBytes(StandardCharsets.UTF_8);
                System.out.println(json);
                connection.setRequestProperty("Content-Length", Integer.toString(postData.length));
                connection.setDoOutput(true);
                DataOutputStream writer = new DataOutputStream(connection.getOutputStream());
                writer.write(postData);
                result = AuthorizeAccountAndUpload.myInputStreamReader(connection.getInputStream());
                connection.getResponseMessage();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println(connection.getResponseMessage());
                connection.disconnect();
            }
        }
        finally {
            connection.disconnect();
        }
        return result;
    }

    private static String getUploadURL(String apiUrl, String accountAuthorizationToken, String bucketId) {
        HttpURLConnection connection = null;
        String result = "";
        String postParams = "{\"bucketId\":\"" + bucketId + "\"}";
        byte[] postData = postParams.getBytes(StandardCharsets.UTF_8);
        try {
            try {
                URL url = new URL(String.valueOf(apiUrl) + "/b2api/v2/b2_get_upload_url");
                Proxy proxy = AuthorizeAccountAndUpload.getProxy();
                connection = proxy == null ? (HttpURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection(proxy);
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Authorization", accountAuthorizationToken);
                connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                connection.setRequestProperty("charset", "utf-8");
                connection.setRequestProperty("Content-Length", Integer.toString(postData.length));
                connection.setDoOutput(true);
                DataOutputStream writer = new DataOutputStream(connection.getOutputStream());
                writer.write(postData);
                result = AuthorizeAccountAndUpload.myInputStreamReader(connection.getInputStream());
                System.out.println(result);
            }
            catch (Exception e) {
                e.printStackTrace();
                connection.disconnect();
            }
        }
        finally {
            connection.disconnect();
        }
        return result;
    }

    private static String upload(String uploadUrl, String uploadAuthorizationToken, String fileName, File file, String folderName) throws Exception {
        String jsonResponse = "";
        String sha1 = AuthorizeAccountAndUpload.createSha1(file);
        HttpURLConnection connection = null;
        try {
            try {
                int buff;
                URL url = new URL(uploadUrl);
                Proxy proxy = AuthorizeAccountAndUpload.getProxy();
                connection = proxy == null ? (HttpURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection(proxy);
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Authorization", uploadAuthorizationToken);
                connection.setRequestProperty("Content-Type", "application/octet-stream");
                connection.setRequestProperty("X-Bz-File-Name", String.valueOf(folderName) + "/" + fileName);
                connection.setRequestProperty("X-Bz-Content-Sha1", sha1);
                connection.setDoOutput(true);
                FileInputStream fis = new FileInputStream(file);
                BufferedInputStream fif = new BufferedInputStream(fis);
                byte[] b = new byte[8192];
                while ((buff = ((InputStream)fif).read(b)) != -1) {
                    connection.getOutputStream().write(b, 0, buff);
                    connection.getOutputStream().flush();
                    System.out.println(connection.getOutputStream().toString().length());
                }
                ((InputStream)fif).close();
                jsonResponse = AuthorizeAccountAndUpload.myInputStreamReader(connection.getInputStream());
                System.out.println(jsonResponse);
            }
            catch (Exception e) {
                e.printStackTrace();
                connection.disconnect();
            }
        }
        finally {
            connection.disconnect();
        }
        return jsonResponse;
    }

    public static String createSha1(File file) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        FileInputStream fis = new FileInputStream(file);
        int n = 0;
        byte[] buffer = new byte[8192];
        while (n != -1) {
            n = ((InputStream)fis).read(buffer);
            if (n <= 0) continue;
            digest.update(buffer, 0, n);
        }
        return new HexBinaryAdapter().marshal(digest.digest());
    }

    public static String myInputStreamReader(InputStream in) throws IOException {
        InputStreamReader reader = new InputStreamReader(in);
        StringBuilder sb = new StringBuilder();
        int c = reader.read();
        while (c != -1) {
            sb.append((char)c);
            c = reader.read();
        }
        reader.close();
        return sb.toString();
    }

    private static Object[] uploadFileAsChunk(String uploadUrl, String uploadAuthorizationToken, long minimumPartSize, File file) throws Exception {
        String jsonResponse = "";
        File localFile = file;
        long localFileSize = localFile.length();
        long totalBytesSent = 0L;
        long bytesSentForPart = minimumPartSize;
        byte[] buf = new byte[(int)minimumPartSize];
        Object[] objects = new Object[2];
        ArrayList<String> partSha1Array = new ArrayList<String>();
        HttpURLConnection connection = null;
        int partNo = 1;
        System.out.println("..........." + minimumPartSize);
        URL url = new URL(uploadUrl);
        System.out.println("uploadUrl.............." + uploadUrl);
        while (totalBytesSent < localFileSize) {
            block7: {
                System.out.println("starting chunk........" + new Date());
                if (localFileSize - totalBytesSent < minimumPartSize) {
                    bytesSentForPart = localFileSize - totalBytesSent;
                }
                try {
                    try {
                        Proxy proxy = AuthorizeAccountAndUpload.getProxy();
                        connection = proxy == null ? (HttpURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection(proxy);
                        FileInputStream fileInputStream = new FileInputStream(localFile);
                        fileInputStream.skip(totalBytesSent);
                        int numBytesReadIntoBuff = fileInputStream.read(buf, 0, (int)bytesSentForPart);
                        fileInputStream.close();
                        MessageDigest sha1Digest = MessageDigest.getInstance("SHA-1");
                        sha1Digest.update(buf, 0, (int)bytesSentForPart);
                        byte[] sha1Buf = sha1Digest.digest();
                        String hexSha1 = String.format("%040x", new BigInteger(1, sha1Buf));
                        partSha1Array.add(hexSha1);
                        connection = (HttpURLConnection)url.openConnection();
                        connection.setRequestMethod("POST");
                        connection.setRequestProperty("Authorization", uploadAuthorizationToken);
                        connection.setRequestProperty("X-Bz-Part-Number", new Integer(partNo).toString());
                        connection.setRequestProperty("Content-Length", new Long(bytesSentForPart).toString());
                        connection.setRequestProperty("X-Bz-Content-Sha1", (String)partSha1Array.get(partNo - 1));
                        connection.setDoOutput(true);
                        connection.setConnectTimeout(300000);
                        DataOutputStream dataOutputStream = new DataOutputStream(connection.getOutputStream());
                        dataOutputStream.write(buf, 0, (int)bytesSentForPart);
                        dataOutputStream.close();
                        jsonResponse = AuthorizeAccountAndUpload.myInputStreamReader(connection.getInputStream());
                        System.out.println(jsonResponse);
                        System.out.println("ended chunk........" + new Date());
                    }
                    catch (Exception fnfe) {
                        System.out.println("execption" + new Date());
                        fnfe.printStackTrace();
                        connection.disconnect();
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    connection.disconnect();
                    throw throwable;
                }
                connection.disconnect();
            }
            totalBytesSent += bytesSentForPart;
            ++partNo;
        }
        objects[0] = jsonResponse;
        objects[1] = partSha1Array;
        return objects;
    }

    private static String finishLargeFile(ArrayList<String> partSha1Arra, String fileId, String accountAuthorizationToken, String apiUrl) throws Exception {
        String jsonResponse = "";
        JsonArrayBuilder jsonArrayOfSha1Builder = Json.createArrayBuilder();
        Enumeration<String> enumerator = Collections.enumeration(partSha1Arra);
        while (enumerator.hasMoreElements()) {
            jsonArrayOfSha1Builder.add(enumerator.nextElement());
        }
        System.out.println(".....jsonArrayOfSha1Builder......." + jsonArrayOfSha1Builder);
        System.out.println(".....fileId......." + jsonArrayOfSha1Builder);
        JsonObject finishLargeFileJsonObj = Json.createObjectBuilder().add("fileId", fileId).add("partSha1Array", jsonArrayOfSha1Builder).build();
        StringWriter sw = new StringWriter();
        JsonWriter jw = Json.createWriter((Writer)sw);
        jw.write((JsonStructure)finishLargeFileJsonObj);
        jw.close();
        String postData = sw.toString();
        HttpURLConnection connection = null;
        try {
            URL url = new URL(String.valueOf(apiUrl) + "/b2api/v2/b2_finish_large_file");
            Proxy proxy = AuthorizeAccountAndUpload.getProxy();
            connection = proxy == null ? (HttpURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection(proxy);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Authorization", accountAuthorizationToken);
            connection.setRequestProperty("Charset", "UTF-8");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setDoOutput(true);
            DataOutputStream dataOutputStream = new DataOutputStream(connection.getOutputStream());
            dataOutputStream.writeBytes(postData);
            dataOutputStream.close();
            jsonResponse = AuthorizeAccountAndUpload.myInputStreamReader(connection.getInputStream());
            System.out.println(jsonResponse);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return jsonResponse;
    }

    private static String getChildList(String apiUrl, String accountAuthorizationToken, String bucketId) throws Exception {
        HttpURLConnection connection = null;
        String postParams = "{\"bucketId\":\"" + bucketId + "\"}";
        String jsonResponse = "";
        byte[] postData = postParams.getBytes(StandardCharsets.UTF_8);
        try {
            try {
                URL url = new URL(String.valueOf(apiUrl) + "/b2api/v2/b2_list_file_names");
                connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Authorization", accountAuthorizationToken);
                connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                connection.setRequestProperty("Charset", "UTF-8");
                connection.setRequestProperty("Content-Length", Integer.toString(postData.length));
                connection.setDoOutput(true);
                DataOutputStream writer = new DataOutputStream(connection.getOutputStream());
                writer.write(postData);
                jsonResponse = AuthorizeAccountAndUpload.myInputStreamReader(connection.getInputStream());
                System.out.println(jsonResponse);
            }
            catch (Exception e) {
                e.printStackTrace();
                connection.disconnect();
            }
        }
        finally {
            connection.disconnect();
        }
        return jsonResponse;
    }

    private static String startLargeFileUpload(String apiUrl, String accountAuthorizationToken, String bucketId, String fileName) throws Exception {
        String fileContentType = "application/zip";
        HttpURLConnection connection = null;
        String jsonResponse = "";
        JsonObject startLargeFileJsonObj = Json.createObjectBuilder().add("fileName", fileName).add("contentType", fileContentType).add("bucketId", bucketId).build();
        URL url = new URL(String.valueOf(apiUrl) + "/b2api/v2/b2_start_large_file");
        Proxy proxy = AuthorizeAccountAndUpload.getProxy();
        connection = proxy == null ? (HttpURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection(proxy);
        StringWriter sw = new StringWriter();
        JsonWriter jw = Json.createWriter((Writer)sw);
        jw.writeObject(startLargeFileJsonObj);
        jw.close();
        String postData = sw.toString();
        try {
            try {
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Authorization", accountAuthorizationToken);
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setRequestProperty("Charset", "UTF-8");
                connection.setRequestProperty("Content-Length", Integer.toString(postData.length()));
                connection.setDoOutput(true);
                DataOutputStream dataOutputStream = new DataOutputStream(connection.getOutputStream());
                dataOutputStream.writeBytes(postData);
                jsonResponse = AuthorizeAccountAndUpload.myInputStreamReader(connection.getInputStream());
                System.out.println(jsonResponse);
            }
            catch (Exception e) {
                e.printStackTrace();
                connection.disconnect();
            }
        }
        finally {
            connection.disconnect();
        }
        return jsonResponse;
    }

    private static String getUploadLargeFilePartUrl(String fileId, String accountAuthorizationToken, String apiUrl) {
        HttpURLConnection connection = null;
        String jsonResponse = "";
        JsonObject getUploadPartJsonObj = Json.createObjectBuilder().add("fileId", fileId).build();
        StringWriter sw = new StringWriter();
        JsonWriter jw = Json.createWriter((Writer)sw);
        jw.writeObject(getUploadPartJsonObj);
        jw.close();
        String postData = sw.toString();
        try {
            try {
                URL url = new URL(String.valueOf(apiUrl) + "/b2api/v2/b2_get_upload_part_url");
                Proxy proxy = AuthorizeAccountAndUpload.getProxy();
                connection = proxy == null ? (HttpURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection(proxy);
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Authorization", accountAuthorizationToken);
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setRequestProperty("Charset", "UTF-8");
                connection.setRequestProperty("Content-Length", Integer.toString(postData.length()));
                connection.setDoOutput(true);
                System.out.println(String.valueOf(connection.usingProxy()) + "...before writing......after...." + connection.getConnectTimeout());
                System.out.println("before ......after...." + connection.getConnectTimeout());
                System.out.println(String.valueOf(connection.usingProxy()) + "...before writing......after...." + connection.getConnectTimeout());
                DataOutputStream dataOutputStream = new DataOutputStream(connection.getOutputStream());
                dataOutputStream.writeBytes(postData);
                dataOutputStream.close();
                jsonResponse = AuthorizeAccountAndUpload.myInputStreamReader(connection.getInputStream());
                System.out.println(jsonResponse);
            }
            catch (Exception e) {
                e.printStackTrace();
                connection.disconnect();
            }
        }
        finally {
            connection.disconnect();
        }
        return jsonResponse;
    }

    private static Proxy getProxy() {
        if (StringUtils.isEmpty((String)proxyHost) || proxyPort <= 0) {
            return null;
        }
        if (!StringUtils.isEmpty((String)proxyUserName) && !StringUtils.isEmpty((String)proxyPassword)) {
            System.out.println("inside proxy......");
            Authenticator authenticator = new Authenticator(){

                @Override
                public PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(proxyUserName, proxyPassword.toCharArray());
                }
            };
            Authenticator.setDefault(authenticator);
        }
        return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
    }
}

