/*
 * Decompiled with CFR 0.152.
 */
package com.thetransactioncompany.cors;

import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class CORSResponseWrapper
extends HttpServletResponseWrapper {
    public static final Set<String> RESPONSE_HEADER_NAMES;

    public CORSResponseWrapper(HttpServletResponse response) {
        super(response);
    }

    public void reset() {
        HashMap<String, String> corsHeaders = new HashMap<String, String>();
        for (String headerName : this.getHeaderNames()) {
            if (!RESPONSE_HEADER_NAMES.contains(headerName)) continue;
            corsHeaders.put(headerName, this.getHeader(headerName));
        }
        super.reset();
        for (String headerName : corsHeaders.keySet()) {
            this.setHeader(headerName, (String)corsHeaders.get(headerName));
        }
    }

    static {
        HashSet<String> headerNames = new HashSet<String>();
        headerNames.add("Access-Control-Allow-Headers");
        headerNames.add("Access-Control-Allow-Methods");
        headerNames.add("Access-Control-Allow-Origin");
        headerNames.add("Access-Control-Allow-Credentials");
        headerNames.add("Access-Control-Expose-Headers");
        headerNames.add("Access-Control-Max-Age");
        headerNames.add("Vary");
        RESPONSE_HEADER_NAMES = Collections.unmodifiableSet(headerNames);
    }
}

