/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.binders;

import com.google.common.base.Throwables;
import com.jamesmurty.utils.XMLBuilder;
import java.util.Properties;
import javax.inject.Singleton;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;
import org.jclouds.s3.binders.BindBucketLoggingToXmlPayload;
import org.jclouds.s3.domain.AccessControlList;

@Singleton
public class BindACLToXMLPayload
implements Binder {
    public <R extends HttpRequest> R bindToRequest(R request, Object payload) {
        AccessControlList from = (AccessControlList)payload;
        Properties outputProperties = new Properties();
        outputProperties.put("omit-xml-declaration", "yes");
        try {
            String stringPayload = this.generateBuilder(from).asString(outputProperties);
            request.setPayload(stringPayload);
            request.getPayload().getContentMetadata().setContentType("text/xml");
            return request;
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e);
            throw new RuntimeException("error transforming acl: " + from, e);
        }
    }

    protected XMLBuilder generateBuilder(AccessControlList acl) throws ParserConfigurationException, FactoryConfigurationError {
        XMLBuilder rootBuilder = XMLBuilder.create((String)"AccessControlPolicy").attr("xmlns", "http://s3.amazonaws.com/doc/2006-03-01/");
        if (acl.getOwner() != null) {
            XMLBuilder ownerBuilder = rootBuilder.elem("Owner");
            ownerBuilder.elem("ID").text(acl.getOwner().getId());
            if (acl.getOwner().getDisplayName() != null) {
                ownerBuilder.elem("DisplayName").text(acl.getOwner().getDisplayName());
            }
        }
        BindBucketLoggingToXmlPayload.addGrants(rootBuilder.elem("AccessControlList"), acl.getGrants());
        return rootBuilder;
    }
}

