/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sqs.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;

public class MessageIdAndMD5 {
    private final String id;
    private final HashCode md5;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return MessageIdAndMD5.builder().fromMessage(this);
    }

    private MessageIdAndMD5(String id, HashCode md5) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.md5 = (HashCode)Preconditions.checkNotNull((Object)md5, (String)"md5 of %s", (Object)id);
    }

    public String getId() {
        return this.id;
    }

    public HashCode getMD5() {
        return this.md5;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MessageIdAndMD5 that = (MessageIdAndMD5)MessageIdAndMD5.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.id).add("md5", (Object)this.md5).toString();
    }

    public static class Builder {
        private String id;
        private HashCode md5;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder md5(HashCode md5) {
            this.md5 = md5;
            return this;
        }

        public MessageIdAndMD5 build() {
            return new MessageIdAndMD5(this.id, this.md5);
        }

        public Builder fromMessage(MessageIdAndMD5 in) {
            return this.id(in.getId()).md5(in.getMD5());
        }
    }
}

