/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azure.storage.util.storageurl;

import com.google.common.base.Supplier;
import java.net.URI;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.azure.storage.util.storageurl.StorageUrlSupplier;
import org.jclouds.azure.storage.util.storageurl.TrailingSlashUtil;
import org.jclouds.domain.Credentials;
import org.jclouds.location.Provider;

@Singleton
public class StorageAccountInVhost
implements StorageUrlSupplier {
    private final Supplier<URI> endpointSupplier;
    private final Supplier<Credentials> credentialsSupplier;

    @Inject
    public StorageAccountInVhost(@Provider Supplier<URI> endpointSupplier, @Provider Supplier<Credentials> credentialsSupplier) {
        this.endpointSupplier = endpointSupplier;
        this.credentialsSupplier = credentialsSupplier;
    }

    public URI get() {
        URI endpoint = (URI)this.endpointSupplier.get();
        String uri = endpoint == null ? this.buildUri() : TrailingSlashUtil.ensureTrailingSlash(endpoint);
        return URI.create(uri);
    }

    private String buildUri() {
        return "https://" + ((Credentials)this.credentialsSupplier.get()).identity + ".blob.core.windows.net/";
    }
}

