/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.net.URI;

public final class Task {
    private final String guid;
    private final StatusCode statusCode;
    private final Optional<String> message;
    private final Optional<URI> resultUrl;

    private Task(String guid, StatusCode statusCode, Optional<String> message, Optional<URI> resultUrl) {
        this.guid = (String)Preconditions.checkNotNull((Object)guid, (Object)"guid");
        this.statusCode = (StatusCode)((Object)Preconditions.checkNotNull((Object)((Object)statusCode), (String)"statusCode for %s", (Object)guid));
        this.message = (Optional)Preconditions.checkNotNull(message, (String)"message for %s", (Object)guid);
        this.resultUrl = (Optional)Preconditions.checkNotNull(resultUrl, (String)"resultUrl for %s", (Object)guid);
    }

    public String getGuid() {
        return this.guid;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public Optional<String> getMessage() {
        return this.message;
    }

    public Optional<URI> getResultUrl() {
        return this.resultUrl;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.guid});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Task that = (Task)Task.class.cast(obj);
        return Objects.equal((Object)this.guid, (Object)that.guid);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("guid", (Object)this.guid).add("statusCode", (Object)this.statusCode).add("message", this.message).add("resultUrl", this.resultUrl).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return Task.builder().from(this);
    }

    public static final class Builder {
        private String guid;
        private StatusCode statusCode;
        private Optional<String> message = Optional.absent();
        private Optional<URI> resultUrl = Optional.absent();

        public Builder guid(String guid) {
            this.guid = guid;
            return this;
        }

        public Builder statusCode(StatusCode statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public Builder message(String message) {
            this.message = Optional.fromNullable((Object)message);
            return this;
        }

        public Builder resultUrl(URI resultUrl) {
            this.resultUrl = Optional.fromNullable((Object)resultUrl);
            return this;
        }

        public Task build() {
            return new Task(this.guid, this.statusCode, this.message, this.resultUrl);
        }

        public Builder from(Task in) {
            return this.guid(in.guid).statusCode(in.statusCode).message((String)in.message.orNull()).resultUrl((URI)in.resultUrl.orNull());
        }
    }

    public static enum StatusCode {
        PENDING,
        IN_PROCESS,
        COMPLETE,
        ERROR;


        public static StatusCode fromValue(String statusCode) {
            return StatusCode.valueOf((String)Preconditions.checkNotNull((Object)statusCode, (Object)"statusCode"));
        }
    }
}

