/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public final class RoundRobinPool {
    private final String zoneId;
    private final String id;
    private final String name;
    private final String dname;

    private RoundRobinPool(String zoneId, String id, String name, String dname) {
        this.zoneId = (String)Preconditions.checkNotNull((Object)zoneId, (Object)"zoneId");
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.name = (String)Preconditions.checkNotNull((Object)name, (String)"name for %s", (Object)id);
        this.dname = (String)Preconditions.checkNotNull((Object)dname, (String)"dname for %s", (Object)id);
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDName() {
        return this.dname;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zoneId, this.id, this.name, this.dname});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RoundRobinPool that = (RoundRobinPool)RoundRobinPool.class.cast(obj);
        return Objects.equal((Object)this.zoneId, (Object)that.zoneId) && Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.dname, (Object)that.dname);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("zoneId", (Object)this.zoneId).add("id", (Object)this.id).add("name", (Object)this.name).add("dname", (Object)this.dname).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return RoundRobinPool.builder().from(this);
    }

    public static final class Builder {
        private String zoneId;
        private String id;
        private String name;
        private String dname;

        public Builder zoneId(String zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder dname(String dname) {
            this.dname = dname;
            return this;
        }

        public RoundRobinPool build() {
            return new RoundRobinPool(this.zoneId, this.id, this.name, this.dname);
        }

        public Builder from(RoundRobinPool in) {
            return this.zoneId(in.zoneId).id(in.id).name(in.name).dname(in.dname);
        }
    }

    public static enum RecordType {
        A(1),
        AAAA(28);

        private final int code;

        public String toString() {
            return String.valueOf(this.code);
        }

        private RecordType(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }
}

