/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;

public final class DirectionalPool {
    private final String zoneId;
    private final String id;
    private final Optional<String> name;
    private final String dname;
    private final Type type;
    private final TieBreak tieBreak;

    private DirectionalPool(String zoneId, String id, Optional<String> name, String dname, Type type, TieBreak tieBreak) {
        this.zoneId = (String)Preconditions.checkNotNull((Object)zoneId, (Object)"zoneId");
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.name = (Optional)Preconditions.checkNotNull(name, (String)"name for %s", (Object)id);
        this.dname = (String)Preconditions.checkNotNull((Object)dname, (String)"dname for %s", (Object)id);
        this.type = type;
        this.tieBreak = tieBreak;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public String getId() {
        return this.id;
    }

    public String getDName() {
        return this.dname;
    }

    public Optional<String> getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public TieBreak getTieBreak() {
        return this.tieBreak;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zoneId, this.id, this.name, this.dname});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DirectionalPool that = (DirectionalPool)DirectionalPool.class.cast(obj);
        return Objects.equal((Object)this.zoneId, (Object)that.zoneId) && Objects.equal((Object)this.id, (Object)that.id) && Objects.equal(this.name, that.name) && Objects.equal((Object)this.dname, (Object)that.dname);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("zoneId", (Object)this.zoneId).add("id", (Object)this.id).add("dname", (Object)this.dname).add("name", this.name.orNull()).add("type", (Object)this.type).add("tieBreak", (Object)this.tieBreak).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return DirectionalPool.builder().from(this);
    }

    public static final class Builder {
        private String zoneId;
        private String id;
        private Optional<String> name = Optional.absent();
        private String dname;
        private Type type = Type.GEOLOCATION;
        private TieBreak tieBreak = TieBreak.GEOLOCATION;

        public Builder zoneId(String zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder dname(String dname) {
            this.dname = dname;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.fromNullable((Object)name);
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        public Builder tieBreak(TieBreak tieBreak) {
            this.tieBreak = tieBreak;
            return this;
        }

        public DirectionalPool build() {
            return new DirectionalPool(this.zoneId, this.id, this.name, this.dname, this.type, this.tieBreak);
        }

        public Builder from(DirectionalPool in) {
            return this.zoneId(in.zoneId).id(in.id).name((String)in.name.orNull()).dname(in.dname).type(in.type).tieBreak(in.tieBreak);
        }
    }

    public static enum TieBreak {
        GEOLOCATION,
        SOURCEIP;

    }

    public static enum RecordType {
        IPV4(1),
        IPV6(28),
        TXT(16),
        SRV(33),
        PTR(12),
        RP(17),
        HINFO(13),
        NAPTR(35),
        MX(15);

        private final int code;

        private RecordType(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }

    public static enum Type {
        GEOLOCATION,
        SOURCEIP,
        MIXED;

    }
}

