#!/bin/bash
# DEVELOPER: Vaibhav K

export PATH=$PATH:/sbin



PARAMAIL_MACHINE="az-pbs-ebms1.wipro.com"
CUSTOMER_NAME="WIPRO"
WATCHDOG_IPS="10.234.20.55 10.234.12.24 10.234.20.68 10.234.20.56 10.234.20.57 10.234.20.58 10.234.20.20 10.234.20.71"
SSH_USERNAME="paracloud-support"
SSH_PORT="22"
SCRIPT_PATH=`pwd`
WATCHDOG_MAIL_ADDRESS="suresh@parablu.com"

function getmail_ids ()
{

		##Get mail ids
		for mail_id in ${WATCHDOG_MAIL_ADDRESS[@]}
                	do
                        	MAILARRAY+=({\"email\":\"$mail_id\"},)
        	done


	        tempids=$(echo -e "${MAILARRAY[*]}")
        	get_mail_id=$(echo $tempids | sed -e 's/.$//')



}

function other_machine_check ()
{

	getmail_ids
	##Connectivity check from other machines
	MSG_SUBJECT="ALERT: CONNECTIVITY CHECK [$CUSTOMER_NAME] `date`"

	for ping_ip in ${WATCHDOG_IPS[@]}
		do
			rm connectivity_check.log
			sleep 1s
			ssh -p $SSH_PORT $SSH_USERNAME@$ping_ip "cd $SCRIPT_PATH && ./connectivity_check.sh"
			sleep 2s
			scp -P $SSH_PORT $SSH_USERNAME@$ping_ip:$SCRIPT_PATH/connectivity_check.log .
			if [ $? -eq 0 ]; then
				if [ -f connectivity_check.log ]; then
					cat connectivity_check.log >> final_connectivity_check.log
					ssh -p $SSH_PORT $SSH_USERNAME@$ping_ip "cd $SCRIPT_PATH && rm connectivity_check.log"
					rm connectivity_check.log
				fi
			fi
		done

	####Send clubbed Mail
        if [ -f final_connectivity_check.log ]; then
                curl -k -X PUT -H "Content-Type: application/json" -d '{"bodyFilePath":"'"${SCRIPT_PATH}/final_connectivity_check.log"'","subjectData":"'"${MSG_SUBJECT}"'","recipents":['"${get_mail_id}"']}' https://$PARAMAIL_MACHINE/paramail/send/customMail/
                sleep 2s
                rm final_connectivity_check.log
        fi

}

function host_machine_check ()
{
	## Connectivity check from this machine
	bash connectivity_check.sh
	sleep 2s
        cat connectivity_check.log >> final_connectivity_check.log
        sleep 5s
        rm connectivity_check.log
}

rm connectivity_check.log
rm final_connectivity_check.log
host_machine_check
other_machine_check
