/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.model.datatype;

import com.sibvisions.util.Internalize;
import com.sibvisions.util.type.StringUtil;
import javax.rad.model.ModelException;
import javax.rad.model.datatype.DataType;
import javax.rad.model.ui.ICellEditor;
import javax.rad.util.ITranslator;

public class StringDataType
extends DataType {
    public static final int TYPE_IDENTIFIER = 12;
    private ITranslator translator;
    private boolean autoTrimEnd = false;

    public StringDataType() {
    }

    public StringDataType(int n) {
        this.setSize(n);
    }

    public StringDataType(ICellEditor iCellEditor) {
        this.setCellEditor(iCellEditor);
    }

    public StringDataType(int n, ICellEditor iCellEditor) {
        this.setSize(n);
        this.setCellEditor(iCellEditor);
    }

    public int getTypeIdentifier() {
        return 12;
    }

    public Class getTypeClass() {
        return String.class;
    }

    public Object convertAndCheckToTypeClass(Object object) throws ModelException {
        String string = (String)this.convertToTypeClass(object);
        if (string == null) {
            return null;
        }
        if (string.length() > this.getSize()) {
            throw new ModelException("String is too large! - length from " + string.length() + " to " + this.getSize());
        }
        if (this.isAutoTrimEnd()) {
            string = StringUtil.rtrim(string);
        }
        return Internalize.intern(string);
    }

    public String convertToString(Object object) {
        return (String)object;
    }

    public Object convertToTypeClass(Object object) throws ModelException {
        if (object == null) {
            return null;
        }
        if (object instanceof CharSequence) {
            String string = object.toString();
            if (string.length() == 0) {
                return null;
            }
            return string;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            if (byArray.length == 0) {
                return null;
            }
            String string = new String(byArray);
            if (string.length() == 0) {
                return null;
            }
            return string;
        }
        String string = object.toString();
        if (string.length() == 0) {
            return null;
        }
        return string;
    }

    public Object prepareValue(Object object) throws ModelException {
        if (this.translator == null) {
            return object;
        }
        return this.translator.translate((String)object);
    }

    public StringDataType clone() {
        return (StringDataType)super.clone();
    }

    public ITranslator getTranslator() {
        return this.translator;
    }

    public void setTranslator(ITranslator iTranslator) {
        this.translator = iTranslator;
    }

    public boolean isAutoTrimEnd() {
        return this.autoTrimEnd;
    }

    public void setAutoTrimEnd(boolean bl) {
        this.autoTrimEnd = bl;
    }
}

