/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.genui.container;

import java.util.ArrayList;
import java.util.List;
import javax.rad.genui.UIComponent;
import javax.rad.genui.UIContainer;
import javax.rad.genui.container.UIToolBar;
import javax.rad.ui.IComponent;
import javax.rad.ui.IContainer;
import javax.rad.ui.container.IToolBar;
import javax.rad.ui.container.IToolBarPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalToolBarPanel {
    private List<IToolBar> toolbars = new ArrayList<IToolBar>();
    private UIContainer<? extends IToolBarPanel> owner;
    private boolean bMovable = true;
    private boolean bBeforeNotified = false;
    private boolean bNotified = false;

    public InternalToolBarPanel(UIContainer<? extends IToolBarPanel> uIContainer) {
        this.owner = uIContainer;
    }

    public void addToolBar(IToolBar iToolBar, int n) {
        IToolBar iToolBar2 = iToolBar instanceof UIComponent ? (IToolBar)((UIComponent)((Object)iToolBar)).getUIResource() : iToolBar;
        if (iToolBar.getParent() != null) {
            ((IToolBarPanel)iToolBar.getParent()).removeToolBar(iToolBar2);
        }
        if (iToolBar instanceof UIComponent && this.isNotified() && !((UIComponent)((Object)iToolBar)).isBeforeNotified()) {
            ((UIComponent)((Object)iToolBar)).beforeAddNotify(this.owner);
        }
        iToolBar.setMovable(this.bMovable);
        if (n < 0) {
            this.toolbars.add(iToolBar);
        } else {
            this.toolbars.add(n, iToolBar);
        }
        IContainer iContainer = null;
        if (iToolBar instanceof UIComponent) {
            iContainer = iToolBar.getParent();
            iToolBar.setParent(this.owner);
        }
        try {
            if (iToolBar instanceof UIToolBar) {
                ((IToolBarPanel)this.owner.getUIResource()).addToolBar((IToolBar)((UIToolBar)iToolBar).getUIResource(), n);
            } else {
                ((IToolBarPanel)this.owner.getUIResource()).addToolBar(iToolBar, n);
            }
        }
        catch (RuntimeException runtimeException) {
            this.toolbars.remove(iToolBar);
            if (iToolBar instanceof UIComponent) {
                iToolBar.setParent(iContainer);
            }
            throw runtimeException;
        }
        catch (Error error) {
            this.toolbars.remove(iToolBar);
            if (iToolBar instanceof UIComponent) {
                iToolBar.setParent(iContainer);
            }
            throw error;
        }
        if (iToolBar instanceof UIComponent && this.isNotified() && !((UIComponent)((Object)iToolBar)).isNotified()) {
            ((UIComponent)((Object)iToolBar)).addNotify();
        }
    }

    public void removeToolBar(int n) {
        IToolBar iToolBar = this.toolbars.get(n);
        if (iToolBar instanceof UIToolBar) {
            ((IToolBarPanel)this.owner.getUIResource()).removeToolBar((IToolBar)((UIToolBar)iToolBar).getUIResource());
            if (((UIComponent)((Object)iToolBar)).isNotified()) {
                ((UIComponent)((Object)iToolBar)).removeNotify();
            }
        } else {
            ((IToolBarPanel)this.owner.getUIResource()).removeToolBar(iToolBar);
        }
        this.toolbars.remove(n);
        if (iToolBar instanceof UIComponent) {
            iToolBar.setParent(null);
        }
    }

    public void removeToolBar(IToolBar iToolBar) {
        if (iToolBar.getParent() == this.owner) {
            this.removeToolBar(this.indexOfToolBar(iToolBar));
        }
    }

    public int getToolBarCount() {
        return this.toolbars.size();
    }

    public IToolBar getToolBar(int n) {
        if (n < 0 || n >= this.toolbars.size()) {
            throw new ArrayIndexOutOfBoundsException("No such child: " + n);
        }
        return this.toolbars.get(n);
    }

    public int indexOfToolBar(IToolBar iToolBar) {
        return this.toolbars.indexOf(iToolBar);
    }

    public void setToolBarArea(int n) {
        ((IToolBarPanel)this.owner.getUIResource()).setToolBarArea(n);
    }

    public int getToolBarArea() {
        return ((IToolBarPanel)this.owner.getUIResource()).getToolBarArea();
    }

    public void setToolBarMovable(boolean bl) {
        this.bMovable = bl;
        int n = this.getToolBarCount();
        for (int i = 0; i < n; ++i) {
            this.getToolBar(i).setMovable(bl);
        }
    }

    public boolean isToolBarMovable() {
        return this.bMovable;
    }

    public void updateTranslation() {
        int n = this.toolbars.size();
        for (int i = 0; i < n; ++i) {
            IComponent iComponent = this.toolbars.get(i);
            if (!(iComponent instanceof UIComponent)) continue;
            ((UIComponent)iComponent).updateTranslation();
        }
    }

    public void beforeAddNotify(IComponent iComponent) {
        this.bBeforeNotified = true;
        int n = this.toolbars.size();
        for (int i = 0; i < n; ++i) {
            IComponent iComponent2 = this.toolbars.get(i);
            if (!(iComponent2 instanceof UIComponent) || ((UIComponent)iComponent2).isBeforeNotified()) continue;
            ((UIComponent)iComponent2).beforeAddNotify(this.owner);
        }
    }

    public boolean isBeforeNotified() {
        return this.bBeforeNotified;
    }

    public void addNotify() {
        this.bNotified = true;
        int n = this.toolbars.size();
        for (int i = 0; i < n; ++i) {
            IComponent iComponent = this.toolbars.get(i);
            if (!(iComponent instanceof UIComponent) || ((UIComponent)iComponent).isNotified()) continue;
            ((UIComponent)iComponent).addNotify();
        }
    }

    public boolean isNotified() {
        return this.bNotified;
    }

    public void removeNotify() {
        this.bBeforeNotified = false;
        this.bNotified = false;
        int n = this.toolbars.size();
        for (int i = 0; i < n; ++i) {
            IComponent iComponent = this.toolbars.get(i);
            if (!(iComponent instanceof UIComponent) || !((UIComponent)iComponent).isNotified()) continue;
            ((UIComponent)iComponent).removeNotify();
        }
    }
}

