/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.genui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.rad.genui.event.ResourceEvent;
import javax.rad.genui.event.ResourceHandler;
import javax.rad.ui.IResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UIResource<UI extends IResource>
implements IResource {
    protected UI uiResource;
    private HashMap<String, Object> hmObjects = null;
    private Map<String, ResourceHandler> hmpResourceHandler;

    protected UIResource(UI UI) {
        this.uiResource = UI;
    }

    @Override
    public Object getResource() {
        if (this.uiResource == null) {
            return null;
        }
        return this.uiResource.getResource();
    }

    public boolean equals(Object object) {
        if (object instanceof IResource) {
            return this.getResource().equals(((IResource)object).getResource());
        }
        return false;
    }

    public int hashCode() {
        return this.getResource().hashCode();
    }

    public String toString() {
        return this.getClass().getName() + "[" + String.valueOf(this.getResource()) + "]";
    }

    public UI getUIResource() {
        return this.uiResource;
    }

    public Object getObject(String string) {
        if (this.hmObjects == null) {
            return null;
        }
        return this.hmObjects.get(string);
    }

    public Collection<String> getObjectNames() {
        if (this.hmObjects == null) {
            return Collections.emptySet();
        }
        return new ArrayList<String>(this.hmObjects.keySet());
    }

    public Object putObject(String string, Object object) {
        if (object == null) {
            if (this.hmObjects == null) {
                return null;
            }
            Object object2 = this.hmObjects.remove(string);
            if (this.hmObjects.isEmpty()) {
                this.hmObjects = null;
            }
            this.fireResourceChanged(ResourceEvent.EventType.Object, string, object2, null);
            return object2;
        }
        if (this.hmObjects == null) {
            this.hmObjects = new HashMap();
        }
        Object object3 = this.hmObjects.put(string, object);
        this.fireResourceChanged(ResourceEvent.EventType.Object, string, object3, object);
        return object3;
    }

    protected void fireResourceChanged(ResourceEvent.EventType eventType, String string, Object object, Object object2) {
        if (this.hmpResourceHandler != null) {
            if (this.hmpResourceHandler.containsKey(null)) {
                this.hmpResourceHandler.get(null).dispatchEvent(new ResourceEvent(this, eventType, string, object, object2));
            }
            if (this.hmpResourceHandler.containsKey(string)) {
                this.hmpResourceHandler.get(string).dispatchEvent(new ResourceEvent(this, eventType, string, object, object2));
            }
        }
    }

    protected boolean hasResourceHandler() {
        return this.hmpResourceHandler != null && this.hmpResourceHandler.size() > 0;
    }

    public ResourceHandler eventResourceChanged() {
        return this.eventResourceChanged(null);
    }

    public ResourceHandler eventResourceChanged(String string) {
        ResourceHandler resourceHandler;
        if (this.hmpResourceHandler == null) {
            this.hmpResourceHandler = new HashMap<String, ResourceHandler>();
        }
        if ((resourceHandler = this.hmpResourceHandler.get(string)) == null) {
            resourceHandler = new ResourceHandler();
            this.hmpResourceHandler.put(string, resourceHandler);
        }
        return resourceHandler;
    }
}

