/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.genui;

import javax.rad.genui.UIFactoryManager;
import javax.rad.genui.UIFactoryResource;
import javax.rad.ui.IFont;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIFont
extends UIFactoryResource<IFont>
implements IFont {
    private static UIFont defaultFont = null;

    public UIFont(String string, int n, int n2) {
        super(UIFactoryManager.getFactory().createFont(string, n, n2));
    }

    protected UIFont(IFont iFont) {
        super(iFont);
    }

    @Override
    public String getName() {
        return ((IFont)this.getUIResource()).getName();
    }

    @Override
    public String getFamily() {
        return ((IFont)this.getUIResource()).getFamily();
    }

    @Override
    public String getFontName() {
        return ((IFont)this.getUIResource()).getFontName();
    }

    @Override
    public int getStyle() {
        return ((IFont)this.getUIResource()).getStyle();
    }

    @Override
    public int getSize() {
        return ((IFont)this.getUIResource()).getSize();
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof IFont) {
            IFont iFont = (IFont)object;
            return this.getName().equals(iFont.getName()) && this.getStyle() == iFont.getStyle() && this.getSize() == iFont.getSize();
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode() + this.getStyle() * 13 + this.getSize() * 31;
    }

    @Override
    public String toString() {
        String string;
        switch (this.getStyle()) {
            case 0: {
                string = "plain";
                break;
            }
            case 1: {
                string = "bold";
                break;
            }
            case 2: {
                string = "italic";
                break;
            }
            default: {
                string = "bolditalic";
            }
        }
        return this.getClass().getName() + "[" + this.getName() + ", " + string + ", " + this.getSize() + "]";
    }

    public IFont deriveFont(int n) {
        return new UIFont(this.getName(), n, this.getSize());
    }

    public IFont deriveFont(int n, int n2) {
        return new UIFont(this.getName(), n, n2);
    }

    public static UIFont getDefaultFont() {
        if (defaultFont == null) {
            IFont iFont = UIFactoryManager.getFactory().createLabel().getFont();
            if (iFont == null) {
                iFont = new UIFont("Dialog", 0, 12);
            }
            defaultFont = new UIFont(iFont);
        }
        return defaultFont;
    }

    public static String[] getAvailableFontFamilyNames() {
        return UIFactoryManager.getFactory().getAvailableFontFamilyNames();
    }
}

