/*
 * Decompiled with CFR 0.152.
 */
package javaQuery.j2ee;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URL;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;

public class ImageResize {
    private int[] imageProperties = new int[2];
    private String errorMsg;
    private String compressType;
    private String saveFileType;
    private int Compresswidth;
    private int Compressheight;
    private boolean image_path_flag = false;
    private File _deleteOriginal = null;

    public int[] imageWxH(String path) {
        try {
            BufferedImage image = null;
            if (path.contains("www") || path.startsWith("http")) {
                if (!(path = path.replace("https://", "http://")).startsWith("http")) {
                    path = "http://" + path;
                }
                image = ImageIO.read(new URL(path));
            } else {
                File f = new File(path);
                image = ImageIO.read(f);
            }
            this.imageProperties[0] = image.getWidth();
            this.imageProperties[1] = image.getHeight();
            image.flush();
        }
        catch (Exception e) {
            System.out.println("File not found");
        }
        return this.imageProperties;
    }

    public int[] compressImage(String _FileLink, String _Saveas, int width, int height) {
        if (width == 0 && height == 0) {
            this.compressType = "General";
        } else {
            this.Compresswidth = width;
            this.Compressheight = height;
            this.compressType = "Preferred";
        }
        if (_Saveas.equalsIgnoreCase("default")) {
            this.image_path_flag = true;
            _Saveas = _FileLink;
        }
        this.saveFileType = _Saveas.substring(_Saveas.lastIndexOf("."), _Saveas.length());
        try {
            BufferedImage originalImage = ImageIO.read(new File(_FileLink));
            BufferedImage resizeImageFile = null;
            int type = originalImage.getType() != 0 ? originalImage.getType() : 2;
            resizeImageFile = this.resizeImage(originalImage, type, this.compressType);
            if (this.saveFileType.equalsIgnoreCase(".png")) {
                if (this.image_path_flag) {
                    this._deleteOriginal = new File(_Saveas);
                    this._deleteOriginal.delete();
                }
                Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("png");
                ImageWriter writer = iter.next();
                ImageWriteParam iwp = writer.getDefaultWriteParam();
                FileImageOutputStream output = new FileImageOutputStream(new File(_Saveas));
                writer.setOutput(output);
                IIOImage image = new IIOImage(resizeImageFile, null, null);
                writer.write(null, image, iwp);
                writer.dispose();
                output.close();
            } else {
                if (this.image_path_flag) {
                    this._deleteOriginal = new File(_Saveas);
                    this._deleteOriginal.delete();
                }
                Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpeg");
                ImageWriter writer = iter.next();
                ImageWriteParam iwp = writer.getDefaultWriteParam();
                iwp.setCompressionMode(2);
                iwp.setCompressionQuality(0.9f);
                FileImageOutputStream output = new FileImageOutputStream(new File(_Saveas));
                writer.setOutput(output);
                IIOImage image = new IIOImage(resizeImageFile, null, null);
                writer.write(null, image, iwp);
                writer.dispose();
                output.close();
            }
            originalImage.flush();
            resizeImageFile.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorMsg = e.getMessage();
        }
        return this.imageProperties;
    }

    private BufferedImage resizeImage(BufferedImage originalImage, int type, String operation) {
        this.imageProperties[0] = originalImage.getWidth();
        this.imageProperties[1] = originalImage.getHeight();
        if (operation.equals("General")) {
            this.Compresswidth = originalImage.getWidth();
            this.Compressheight = originalImage.getHeight();
        }
        BufferedImage resizedImage = new BufferedImage(this.Compresswidth, this.Compressheight, type);
        Graphics2D g = resizedImage.createGraphics();
        g.setComposite(AlphaComposite.Src);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.drawImage(originalImage, 0, 0, this.Compresswidth, this.Compressheight, null);
        g.dispose();
        return resizedImage;
    }
}

