/*
 * Decompiled with CFR 0.152.
 */
package javaQuery.j2ee;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class GeoLocation {
    public static String IPAddress = "";
    public static String Latitude = "";
    public static String Longitude = "";
    public static String Country = "";
    public static String State = "";
    public static String City = "";
    public static String GoogleMap_URL = "";
    public static String GoogleMap_URL_Bubble = "";
    private String parseURL = "";

    public String getMACAddressWindows() {
        try {
            Process p = Runtime.getRuntime().exec("getmac /fo csv /nh");
            BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = in.readLine();
            String[] result = line.split(",");
            String MAC = result[0].replace('\"', ' ').trim();
            return MAC;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void MAPTargetByMobile(int mcc, int mnc, int lac, int cellid) {
        try {
            this.parseURL = "http://www.opencellid.org/cell/get?key=40e9b480922fba87c8e43bb2e580177c&mcc=" + mcc + "&mnc=" + mnc + "&lac=" + lac + "&cellid=" + cellid;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new URL(this.parseURL).openStream());
            NodeList status = doc.getElementsByTagName("rsp");
            if (status.getLength() > 0) {
                Element stat = (Element)status.item(0);
                String value = stat.getAttribute("stat");
                if (value.equalsIgnoreCase("ok")) {
                    NodeList target = doc.getElementsByTagName("cell");
                    if (target.getLength() > 0) {
                        Element targetDetails = (Element)target.item(0);
                        Latitude = targetDetails.getAttribute("lat");
                        Longitude = targetDetails.getAttribute("lon");
                    }
                } else {
                    Latitude = null;
                    Longitude = null;
                }
            } else {
                Latitude = null;
                Longitude = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Latitude = null;
            Longitude = null;
        }
    }

    public void MAPTargetByIP(String ipAddress, String GoogleMap_BubbleText) {
        if (!ipAddress.equals("127.0.0.1") && ipAddress.matches("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}")) {
            IPAddress = ipAddress;
            try {
                NodeList CityList;
                NodeList StateList;
                NodeList CountryList;
                NodeList LongitudeList;
                this.parseURL = "http://www.geoplugin.net/xml.gp?ip=" + ipAddress;
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = db.parse(new URL(this.parseURL).openStream());
                NodeList LatitudeList = doc.getElementsByTagName("geoplugin_latitude");
                if (LatitudeList.getLength() > 0) {
                    Element providerNameParent = (Element)LatitudeList.item(0);
                    NodeList getProviderName = providerNameParent.getChildNodes();
                    Latitude = getProviderName.item(0).getNodeValue();
                }
                if ((LongitudeList = doc.getElementsByTagName("geoplugin_longitude")).getLength() > 0) {
                    Element providerURLParent = (Element)LongitudeList.item(0);
                    NodeList getProviderURL = providerURLParent.getChildNodes();
                    Longitude = getProviderURL.item(0).getNodeValue();
                }
                if ((CountryList = doc.getElementsByTagName("geoplugin_countryName")).getLength() > 0) {
                    Element titleParent = (Element)CountryList.item(0);
                    NodeList gettitle = titleParent.getChildNodes();
                    Country = gettitle.item(0).getNodeValue();
                }
                if ((StateList = doc.getElementsByTagName("geoplugin_region")).getLength() > 0) {
                    Element authorNameParent = (Element)StateList.item(0);
                    NodeList getAuthorName = authorNameParent.getChildNodes();
                    State = getAuthorName.item(0).getNodeValue();
                }
                if ((CityList = doc.getElementsByTagName("geoplugin_city")).getLength() > 0) {
                    Element authorURLParent = (Element)CityList.item(0);
                    NodeList getAuthorURL = authorURLParent.getChildNodes();
                    City = getAuthorURL.item(0).getNodeValue();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (Latitude != null && !Latitude.equals("") && Longitude != null && !Longitude.equals("")) {
                GoogleMap_URL = "http://maps.google.com/maps?q=" + Latitude + ",+" + Longitude + "+(" + ipAddress + ")&iwloc=A&hl=en";
                if (GoogleMap_BubbleText != null && !GoogleMap_BubbleText.equals("")) {
                    GoogleMap_URL_Bubble = "http://maps.google.com/maps?q=" + Latitude + ",+" + Longitude + "+(" + GoogleMap_BubbleText + ")&iwloc=A&hl=en";
                }
            }
            Country = Country.replace("\u0101", "a");
            State = State.replace("\u0101", "a");
            City = City.replace("\u0101", "a");
        } else {
            System.out.println("Invalid IP Address!");
        }
    }
}

