/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.util.type;

import com.sibvisions.util.type.CommonUtil;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public final class ImageUtil {
    private ImageUtil() {
    }

    public static ImageIcon getScaledIcon(Icon icon, int n, int n2, boolean bl) {
        if (icon == null) {
            return null;
        }
        if (icon instanceof ImageIcon) {
            return ImageUtil.getScaledIcon((ImageIcon)icon, n, n2, bl);
        }
        BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics graphics = bufferedImage.getGraphics();
        icon.paintIcon(null, graphics, 0, 0);
        graphics.dispose();
        return new ImageIcon(ImageUtil.getScaledImage(bufferedImage, n, n2, bl));
    }

    public static ImageIcon getScaledIcon(ImageIcon imageIcon, int n, int n2, boolean bl) {
        if (imageIcon == null) {
            return null;
        }
        if (imageIcon.getIconWidth() <= n && imageIcon.getIconHeight() <= n2) {
            return imageIcon;
        }
        return new ImageIcon(ImageUtil.getScaledImage(imageIcon.getImage(), n, n2, bl));
    }

    public static Image getScaledImage(InputStream inputStream, int n, int n2, boolean bl) throws IOException {
        return ImageUtil.getScaledImage(ImageIO.read(inputStream), n, n2, bl);
    }

    public static Image getScaledImage(Image image, int n, int n2, boolean bl) {
        if (image instanceof BufferedImage) {
            return ImageUtil.getScaledImage(image, ((BufferedImage)image).getType(), n, n2, bl);
        }
        return ImageUtil.getScaledImage(image, 2, n, n2, bl);
    }

    public static Image getScaledImage(Image image, int n, int n2, int n3, boolean bl) {
        if (image == null) {
            return null;
        }
        int n4 = image.getWidth(null);
        int n5 = image.getHeight(null);
        if (n4 <= n2 && n5 <= n3) {
            return image;
        }
        if (bl) {
            if (n4 > n5) {
                n3 = n5 * n2 / n4;
            } else {
                n2 = n4 * n3 / n5;
            }
        }
        while (n4 > n2 || n5 > n3) {
            if (n4 > n2 && (n4 /= 2) < n2) {
                n4 = n2;
            }
            if (n5 > n3 && (n5 /= 2) < n3) {
                n5 = n3;
            }
            BufferedImage bufferedImage = new BufferedImage(Math.max(1, n4), Math.max(1, n5), n);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics2D.drawImage(image, 0, 0, n4, n5, null);
            graphics2D.dispose();
            image = bufferedImage;
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createScaledImage(InputStream inputStream, int n, int n2, boolean bl, OutputStream outputStream, String string) throws IOException {
        Image image = ImageUtil.getScaledImage(inputStream, n, n2, bl);
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(string);
        if (!iterator.hasNext()) {
            throw new RuntimeException("No image writer available for '" + string + "'!");
        }
        ImageWriter imageWriter = iterator.next();
        if (imageWriter == null) {
            throw new IOException("Output format '" + string + "' is not supported!");
        }
        ImageOutputStream imageOutputStream = null;
        try {
            ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
            if (imageWriteParam == null || imageWriteParam.canWriteCompressed()) {
                // empty if block
            }
            imageOutputStream = ImageIO.createImageOutputStream(outputStream);
            imageWriter.setOutput(imageOutputStream);
            imageWriter.write(null, new IIOImage((BufferedImage)image, null, null), imageWriteParam);
        }
        catch (Throwable throwable) {
            CommonUtil.close(imageOutputStream);
            imageWriter.dispose();
            throw throwable;
        }
        CommonUtil.close(imageOutputStream);
        imageWriter.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageFormat getImageFormat(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            int n = byteArrayInputStream.read();
            int n2 = byteArrayInputStream.read();
            int n3 = byteArrayInputStream.read();
            int n4 = byteArrayInputStream.read();
            if (n == 71 && n2 == 73 && n3 == 70) {
                ImageFormat imageFormat = ImageFormat.GIF;
                return imageFormat;
            }
            if (n == 255 && n2 == 216) {
                ImageFormat imageFormat = ImageFormat.JPG;
                return imageFormat;
            }
            if (n == 0 && n2 == 0 && n3 == 0 && n4 == 12) {
                ImageFormat imageFormat = ImageFormat.JPG2000;
                return imageFormat;
            }
            if (n == 255 && n2 == 79 && n3 == 255 && n4 == 81) {
                ImageFormat imageFormat = ImageFormat.JPG2000;
                return imageFormat;
            }
            if (n == 137 && n2 == 80 && n3 == 78 && n4 == 71) {
                ImageFormat imageFormat = ImageFormat.PNG;
                return imageFormat;
            }
            if (n == 215 && n2 == 205) {
                ImageFormat imageFormat = ImageFormat.WMF;
                return imageFormat;
            }
            if (n == 66 && n2 == 77) {
                ImageFormat imageFormat = ImageFormat.BMP;
                return imageFormat;
            }
            if (n == 77 && n2 == 77 && n3 == 0 && n4 == 42 || n == 73 && n2 == 73 && n3 == 42 && n4 == 0) {
                ImageFormat imageFormat = ImageFormat.TIFF;
                return imageFormat;
            }
            if (n == 151 && n2 == 74 && n3 == 66 && n4 == 50) {
                int n5 = byteArrayInputStream.read();
                int n6 = byteArrayInputStream.read();
                int n7 = byteArrayInputStream.read();
                int n8 = byteArrayInputStream.read();
                if (n5 == 13 && n6 == 10 && n7 == 26 && n8 == 10) {
                    ImageFormat imageFormat = ImageFormat.JBIG2;
                    return imageFormat;
                }
            }
            ImageFormat imageFormat = ImageFormat.UNKNOWN;
            return imageFormat;
        }
        finally {
            try {
                byteArrayInputStream.close();
            }
            catch (Exception exception) {}
            byteArrayInputStream = null;
        }
    }

    public static void save(ImageIcon imageIcon, ImageFormat imageFormat, OutputStream outputStream) throws IOException {
        if (imageIcon != null) {
            ImageUtil.save(imageIcon.getImage(), imageIcon.getIconWidth(), imageIcon.getIconHeight(), imageFormat, outputStream);
        }
    }

    public static void save(Image image, ImageFormat imageFormat, OutputStream outputStream) throws IOException {
        if (image != null) {
            ImageUtil.save(image, image.getWidth(null), image.getHeight(null), imageFormat, outputStream);
        }
    }

    private static void save(Image image, int n, int n2, ImageFormat imageFormat, OutputStream outputStream) throws IOException {
        String string;
        switch (imageFormat) {
            case JPG: 
            case JPG2000: {
                string = "jpg";
                break;
            }
            case BMP: {
                string = "bmp";
                break;
            }
            case GIF: {
                string = "gif";
                break;
            }
            default: {
                string = "png";
            }
        }
        if (image instanceof RenderedImage) {
            ImageIO.write((RenderedImage)((Object)image), string, outputStream);
        } else {
            BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
            bufferedImage.getGraphics().drawImage(image, 0, 0, null);
            ImageIO.write((RenderedImage)bufferedImage, string, outputStream);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ImageFormat {
        UNKNOWN,
        JPG,
        JPG2000,
        GIF,
        PNG,
        WMF,
        BMP,
        TIFF,
        JBIG2;

    }
}

