/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.util;

import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.type.StringUtil;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Reflective {
    private static final Object[] NULL_PARAMETER = new Object[1];
    private static HashMap<Class, Set<Class>> primitiveTypeClass = new HashMap();
    private static HashMap<Class, Class> autoboxClass = new HashMap();
    private static Hashtable<Long, WeakReference<Constructor<?>>> htConstructorCache = null;
    private static Hashtable<Long, WeakReference<Method>> htMethodCache = null;

    private Reflective() {
    }

    public static Class getAutoboxClass(Class clazz) {
        Class clazz2 = autoboxClass.get(clazz);
        if (clazz2 == null) {
            return clazz;
        }
        return clazz2;
    }

    @Deprecated
    public static Class getOuterBoxClass(Class clazz) {
        return Reflective.getAutoboxClass(clazz);
    }

    public static final Object construct(String string, Object ... objectArray) throws Throwable {
        return Reflective.construct(Class.forName(string), objectArray);
    }

    public static final Object construct(ClassLoader classLoader, String string, Object ... objectArray) throws Throwable {
        return Reflective.construct(Class.forName(string, true, classLoader), objectArray);
    }

    public static final Object construct(Class<?> clazz, Object ... objectArray) throws Throwable {
        return Reflective.construct(clazz, false, objectArray);
    }

    public static final Object construct(Class<?> clazz, boolean bl, Object ... objectArray) throws Throwable {
        try {
            Constructor constructor = Reflective.getConstructor(clazz, bl, objectArray);
            return constructor.newInstance(Reflective.convertParameters(constructor.getParameterTypes(), objectArray, constructor.isVarArgs()));
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause();
        }
    }

    public static final Object call(Object object, String string, Object ... objectArray) throws Throwable {
        return Reflective.call(object, object.getClass(), false, string, objectArray);
    }

    public static final Object call(Object object, boolean bl, String string, Object ... objectArray) throws Throwable {
        return Reflective.call(object, object.getClass(), bl, string, objectArray);
    }

    public static final Object call(Object object, Class<?> clazz, boolean bl, String string, Object ... objectArray) throws Throwable {
        Method method = Reflective.getMethodForCall(clazz, bl, string, objectArray);
        if (method != null) {
            return Reflective.call(object, method, objectArray);
        }
        throw new NoSuchMethodException(Reflective.getMethodDeclaration(clazz, string, objectArray));
    }

    public static final Object call(Object object, Method method, Object ... objectArray) throws Throwable {
        if (method == null) {
            throw new NullPointerException("Method can't be null!");
        }
        try {
            return method.invoke(object, Reflective.convertParameters(method.getParameterTypes(), objectArray, method.isVarArgs()));
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause();
        }
    }

    private static final boolean isParamListValid(Class<?>[] classArray, Object[] objectArray, boolean bl) {
        int n;
        int n2 = objectArray == null ? 0 : objectArray.length;
        int n3 = n = classArray == null ? 0 : classArray.length;
        if (bl) {
            --n;
        } else if (n == 1) {
            if (objectArray == null) {
                objectArray = NULL_PARAMETER;
                ++n2;
            } else if (Object[].class.isAssignableFrom(classArray[0])) {
                bl = true;
                --n;
            }
        }
        if (n2 == n || bl && n2 > n) {
            int n4;
            for (n4 = 0; n4 < n && (classArray[n4].isPrimitive() && (objectArray[n4] != null && primitiveTypeClass.get(classArray[n4]).contains(objectArray[n4].getClass()) || objectArray[n4] instanceof Parameter && primitiveTypeClass.get(classArray[n4]).contains(objectArray[n4].getClass())) || !classArray[n4].isPrimitive() && (objectArray[n4] == null || classArray[n4].isInstance(objectArray[n4]) || objectArray[n4] instanceof Parameter && ((Parameter)objectArray[n4]).clazz != null && classArray[n4].isAssignableFrom(((Parameter)objectArray[n4]).clazz))); ++n4) {
            }
            if (bl && n4 == n) {
                if (n2 == n + 1 && classArray[n].isInstance(objectArray[n4])) {
                    ++n4;
                } else {
                    Class<?> clazz = classArray[n].getComponentType();
                    boolean bl2 = clazz.isPrimitive();
                    Set<Class> set = primitiveTypeClass.get(clazz);
                    while (n4 < n2 && (bl2 && objectArray[n4] != null && set.contains(objectArray[n4].getClass()) || !bl2 && (objectArray[n4] == null || clazz.isInstance(objectArray[n4])))) {
                        ++n4;
                    }
                }
            }
            return n4 == n2;
        }
        return false;
    }

    private static final Object[] convertParameters(Class<?>[] classArray, Object[] objectArray, boolean bl) {
        int n = objectArray == null ? 0 : objectArray.length;
        int n2 = classArray == null ? 0 : classArray.length;
        boolean bl2 = bl = bl || objectArray != null && n2 == 1 && Object[].class.isAssignableFrom(classArray[0]);
        if (bl) {
            if (n != --n2 + 1 || !classArray[n2].isInstance(objectArray[n2])) {
                Object[] objectArray2 = new Object[n2 + 1];
                if (objectArray != null) {
                    for (int i = 0; i < n2; ++i) {
                        objectArray2[i] = objectArray[i];
                    }
                }
                if (bl || objectArray != null || n > n2) {
                    Class<?> clazz = classArray[n2].getComponentType();
                    Object object = Array.newInstance(clazz, objectArray == null && n2 == 0 ? 1 : Math.max(0, n - n2));
                    int n3 = 0;
                    for (int i = n2; i < n; ++i) {
                        Array.set(object, n3, objectArray[i]);
                        ++n3;
                    }
                    objectArray2[n2] = object;
                }
                return objectArray2;
            }
        } else {
            if (n2 == 1 && objectArray == null) {
                objectArray = NULL_PARAMETER;
                ++n;
            }
            for (int i = 0; i < n; ++i) {
                if (!(objectArray[i] instanceof Parameter)) continue;
                objectArray[i] = ((Parameter)objectArray[i]).value;
            }
        }
        return objectArray;
    }

    public static final String getMethodDeclaration(Class clazz, String string, Object ... objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string == null) {
            stringBuilder.append("new ");
        }
        stringBuilder.append(clazz.getCanonicalName());
        if (string != null) {
            stringBuilder.append('.');
            stringBuilder.append(string);
        }
        stringBuilder.append('(');
        for (int i = 0; objectArray != null && i < objectArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            if (objectArray instanceof Class[]) {
                stringBuilder.append(((Class[])objectArray)[i].getName());
                continue;
            }
            if (objectArray[i] == null) {
                stringBuilder.append("null");
                continue;
            }
            if (objectArray[i] instanceof Parameter) {
                if (((Parameter)objectArray[i]).clazz != null) {
                    stringBuilder.append(((Parameter)objectArray[i]).clazz.getName());
                    continue;
                }
                stringBuilder.append("null");
                continue;
            }
            stringBuilder.append(objectArray[i].getClass().getName());
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public static void setValue(Object object, String string, Object object2) throws Throwable {
        Field field = object.getClass().getDeclaredField(string);
        Reflective.setValue(object, field, object2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setValue(Object object, Field field, Object object2) throws Throwable {
        boolean bl = field.isAccessible();
        if (!bl) {
            field.setAccessible(true);
        }
        try {
            field.set(object, object2);
        }
        finally {
            if (!bl) {
                field.setAccessible(false);
            }
        }
    }

    public static Object getValue(Object object, String string) throws Throwable {
        Field field = object.getClass().getDeclaredField(string);
        return Reflective.getValue(object, field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getValue(Object object, Field field) throws Throwable {
        boolean bl = field.isAccessible();
        if (!bl) {
            field.setAccessible(true);
        }
        try {
            Object object2 = field.get(object);
            return object2;
        }
        finally {
            if (!bl) {
                field.setAccessible(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object invoke(Object object, Method method, Object ... objectArray) throws Throwable {
        boolean bl = method.isAccessible();
        if (!bl) {
            method.setAccessible(true);
        }
        try {
            Object object2 = method.invoke(object, objectArray);
            return object2;
        }
        finally {
            if (!bl) {
                method.setAccessible(false);
            }
        }
    }

    public static Object get(Object object, String string) throws Throwable {
        Class<?> clazz = object.getClass();
        long l = (long)clazz.hashCode() | (long)string.hashCode() << 32 & 0x7FFFFFFF00000000L;
        Method method = Reflective.getMethod(l);
        try {
            if (method == null) {
                method = clazz.getMethod(StringUtil.formatMethodName("get", string), new Class[0]);
                Reflective.putMethod(l, method);
            }
            return method.invoke(object, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause();
        }
    }

    public static void set(Object object, String string, Object object2) throws Throwable {
        Class<?> clazz = object.getClass();
        long l = (long)clazz.hashCode() | (long)string.hashCode() << 32 | Long.MIN_VALUE;
        Method method = Reflective.getMethod(l);
        try {
            if (method == null) {
                method = clazz.getMethod(StringUtil.formatMethodName("set", string), clazz.getMethod(StringUtil.formatMethodName("get", string), new Class[0]).getReturnType());
                Reflective.putMethod(l, method);
            }
            method.invoke(object, object2);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause();
        }
    }

    private static final Method getMethod(long l) {
        Long l2;
        WeakReference<Method> weakReference;
        if (htMethodCache != null && (weakReference = htMethodCache.get(l2 = Long.valueOf(l))) != null) {
            Method method = (Method)weakReference.get();
            if (method == null) {
                htMethodCache.remove(l2);
            }
            return method;
        }
        return null;
    }

    private static final Constructor<?> getConstructor(long l) {
        Long l2;
        WeakReference<Constructor<?>> weakReference;
        if (htConstructorCache != null && (weakReference = htConstructorCache.get(l2 = Long.valueOf(l))) != null) {
            Constructor constructor = (Constructor)weakReference.get();
            if (constructor == null) {
                htConstructorCache.remove(l2);
            }
            return constructor;
        }
        return null;
    }

    private static final void putMethod(long l, Method method) {
        if (htMethodCache == null) {
            htMethodCache = new Hashtable();
        }
        htMethodCache.put(l, new WeakReference<Method>(method));
    }

    private static final void putConstructor(long l, Constructor<?> constructor) {
        if (htConstructorCache == null) {
            htConstructorCache = new Hashtable();
        }
        htConstructorCache.put(l, new WeakReference(constructor));
    }

    public static final void printFields(Object object, boolean bl) {
        Field[] fieldArray = bl ? (object instanceof Class ? ((Class)object).getDeclaredFields() : object.getClass().getDeclaredFields()) : (object instanceof Class ? ((Class)object).getFields() : object.getClass().getFields());
        for (Field field : fieldArray) {
            try {
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                System.out.println(field.getName() + " = " + field.get(object));
            }
            catch (Throwable throwable) {
                System.out.println(field.getName() + " = " + throwable.getMessage());
            }
        }
    }

    public static final void printMethods(Object object, boolean bl) {
        Method[] methodArray = bl ? (object instanceof Class ? ((Class)object).getDeclaredMethods() : object.getClass().getDeclaredMethods()) : (object instanceof Class ? ((Class)object).getMethods() : object.getClass().getMethods());
        for (Method method : methodArray) {
            if (method.getReturnType() == null || method.getParameterTypes() != null && method.getParameterTypes().length != 0 || !method.getName().startsWith("get") && !method.getName().startsWith("is") && !method.getName().startsWith("has")) continue;
            try {
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                System.out.println(method.getName() + " = " + method.invoke(object, new Object[0]));
            }
            catch (Throwable throwable) {
                System.out.println(method.getName() + " = " + throwable.getMessage());
            }
        }
    }

    public static final boolean isParamTypeListValid(Class<?>[] classArray, Class[] classArray2, boolean bl) {
        int n = classArray2 == null ? 0 : classArray2.length;
        int n2 = classArray == null ? 0 : classArray.length;
        boolean bl2 = bl = bl || n2 > 0 && Object[].class.isAssignableFrom(classArray[n2 - 1]);
        if (bl) {
            --n2;
        }
        if (n == n2 || bl && n > n2) {
            int n3;
            for (n3 = 0; n3 < n2 && (classArray[n3].isPrimitive() && primitiveTypeClass.get(classArray[n3]).contains(Reflective.getAutoboxClass(classArray2[n3])) || !classArray[n3].isPrimitive() && classArray[n3].isAssignableFrom(Reflective.getAutoboxClass(classArray2[n3]))); ++n3) {
            }
            if (bl && n3 == n2) {
                if (n == n2 + 1 && classArray[n2].isAssignableFrom(classArray2[n3])) {
                    ++n3;
                } else {
                    Class<?> clazz = classArray[n2].getComponentType();
                    boolean bl3 = clazz.isPrimitive();
                    Set<Class> set = primitiveTypeClass.get(clazz);
                    while (n3 < n && (bl3 && set.contains(Reflective.getAutoboxClass(classArray2[n3])) || !bl3 && clazz.isAssignableFrom(Reflective.getAutoboxClass(classArray2[n3])))) {
                        ++n3;
                    }
                }
            }
            return n3 == n;
        }
        return false;
    }

    public static final Method getMethod(Class<?> clazz, String string, Class ... classArray) throws NoSuchMethodException {
        return Reflective.getMethod(clazz, false, string, classArray);
    }

    public static final Method getMethod(Class<?> clazz, boolean bl, String string, Class ... classArray) throws NoSuchMethodException {
        Method method;
        long l = (long)clazz.hashCode() | (long)string.hashCode() << 32 & 0xFFFFFF00000000L;
        if (classArray == null || classArray.length == 0) {
            method = Reflective.getMethod(l);
            if (method == null) {
                method = bl ? clazz.getDeclaredMethod(string, new Class[0]) : clazz.getMethod(string, new Class[0]);
                Reflective.putMethod(l, method);
            }
        } else {
            long l2 = l | (long)classArray.length << 56;
            method = Reflective.getMethod(l2);
            if (method == null || !method.getName().equals(string) || !Reflective.isParamTypeListValid(method.getParameterTypes(), classArray, method.isVarArgs())) {
                try {
                    method = bl ? clazz.getDeclaredMethod(string, classArray) : clazz.getMethod(string, classArray);
                    Reflective.putMethod(l2, method);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    Method[] methodArray = bl ? clazz.getDeclaredMethods() : clazz.getMethods();
                    method = null;
                    int n = methodArray.length;
                    for (int i = 0; i < n && method == null; ++i) {
                        if (!methodArray[i].getName().equals(string) || !Reflective.isParamTypeListValid(methodArray[i].getParameterTypes(), classArray, methodArray[i].isVarArgs())) continue;
                        method = methodArray[i];
                        Reflective.putMethod(l2, method);
                    }
                }
            }
        }
        if (method != null) {
            return method;
        }
        throw new NoSuchMethodException(Reflective.getMethodDeclaration(clazz, string, classArray));
    }

    public static final Method getMethodForCall(Class<?> clazz, String string, Object ... objectArray) throws Throwable {
        return Reflective.getMethodForCall(clazz, false, string, objectArray);
    }

    public static final Method getMethodForCall(Class<?> clazz, boolean bl, String string, Object ... objectArray) throws Throwable {
        long l = (long)clazz.hashCode() | (long)string.hashCode() << 32 & 0xFFFFFF00000000L;
        long l2 = l | (objectArray == null ? 0L : (long)objectArray.length) << 56;
        Method method = Reflective.getMethod(l2);
        if (method == null || !method.getName().equals(string) || !Reflective.isParamListValid(method.getParameterTypes(), objectArray, method.isVarArgs())) {
            Method[] methodArray = bl ? clazz.getDeclaredMethods() : clazz.getMethods();
            method = null;
            Method method2 = null;
            int n = methodArray.length;
            for (int i = 0; i < n && method2 == null; ++i) {
                Class<?>[] classArray = methodArray[i].getParameterTypes();
                if (!methodArray[i].getName().equals(string) || !Reflective.isParamListValid(classArray, objectArray, methodArray[i].isVarArgs())) continue;
                if (classArray.length > 0 && classArray[classArray.length - 1].isArray()) {
                    method2 = methodArray[i];
                    continue;
                }
                if (method != null) continue;
                method = methodArray[i];
            }
            if (method2 != null) {
                method = method2;
            }
            if (method != null) {
                Reflective.putMethod(l2, method);
            }
        }
        return method;
    }

    public static Constructor getConstructor(ClassLoader classLoader, String string, Object ... objectArray) throws Exception {
        return Reflective.getConstructor(Class.forName(string, true, classLoader), false, objectArray);
    }

    public static Constructor getConstructor(Class<?> clazz, boolean bl, Object ... objectArray) throws Exception {
        long l = clazz.hashCode();
        long l2 = l | (objectArray == null ? 0L : (long)objectArray.length) << 32;
        Constructor<?> constructor = Reflective.getConstructor(l2);
        if (constructor == null || !Reflective.isParamListValid(constructor.getParameterTypes(), objectArray, constructor.isVarArgs())) {
            Constructor<?>[] constructorArray = bl ? clazz.getDeclaredConstructors() : clazz.getConstructors();
            constructor = null;
            int n = constructorArray.length;
            for (int i = 0; i < n && constructor == null; ++i) {
                if (!Reflective.isParamListValid(constructorArray[i].getParameterTypes(), objectArray, constructorArray[i].isVarArgs())) continue;
                constructor = constructorArray[i];
                Reflective.putConstructor(l2, constructor);
            }
        }
        if (constructor != null) {
            return constructor;
        }
        throw new NoSuchMethodException(Reflective.getMethodDeclaration(clazz, null, objectArray));
    }

    public static Method[] getMethodsByReturnValue(Class<?> clazz, Class<?> clazz2, boolean bl) {
        Method[] methodArray = bl ? clazz.getDeclaredMethods() : clazz.getMethods();
        ArrayUtil<Method> arrayUtil = new ArrayUtil<Method>();
        for (int i = 0; i < methodArray.length; ++i) {
            Class<?>[] classArray = methodArray[i].getParameterTypes();
            if (classArray != null && classArray.length != 0 || !clazz2.isAssignableFrom(methodArray[i].getReturnType())) continue;
            arrayUtil.add(methodArray[i]);
        }
        return arrayUtil.toArray(new Method[arrayUtil.size()]);
    }

    static {
        primitiveTypeClass.put(Void.TYPE, new HashSet<Class>(Arrays.asList(Void.class)));
        primitiveTypeClass.put(Boolean.TYPE, new HashSet<Class>(Arrays.asList(Boolean.class)));
        primitiveTypeClass.put(Character.TYPE, new HashSet<Class>(Arrays.asList(Character.class)));
        primitiveTypeClass.put(Byte.TYPE, new HashSet<Class>(Arrays.asList(Byte.class)));
        primitiveTypeClass.put(Short.TYPE, new HashSet<Class>(Arrays.asList(Short.class, Byte.class)));
        primitiveTypeClass.put(Integer.TYPE, new HashSet<Class>(Arrays.asList(Integer.class, Character.class, Short.class, Byte.class)));
        primitiveTypeClass.put(Long.TYPE, new HashSet<Class>(Arrays.asList(Long.class, Integer.class, Character.class, Short.class, Byte.class)));
        primitiveTypeClass.put(Float.TYPE, new HashSet<Class>(Arrays.asList(Float.class)));
        primitiveTypeClass.put(Double.TYPE, new HashSet<Class>(Arrays.asList(Double.class, Float.class)));
        autoboxClass.put(Void.TYPE, Void.class);
        autoboxClass.put(Boolean.TYPE, Boolean.class);
        autoboxClass.put(Character.TYPE, Character.class);
        autoboxClass.put(Byte.TYPE, Byte.class);
        autoboxClass.put(Short.TYPE, Short.class);
        autoboxClass.put(Integer.TYPE, Integer.class);
        autoboxClass.put(Long.TYPE, Long.class);
        autoboxClass.put(Float.TYPE, Float.class);
        autoboxClass.put(Double.TYPE, Double.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Parameter {
        private Class<?> clazz;
        private Object value;

        public Parameter(Object object) {
            if (object != null) {
                this.clazz = object.getClass();
            }
            this.value = object;
        }

        public Parameter(Class<?> clazz, Object object) {
            if (clazz != null) {
                this.clazz = clazz;
            } else if (object != null) {
                this.clazz = object.getClass();
            }
            this.value = object;
            if (clazz != null && object != null && !clazz.isAssignableFrom(object.getClass())) {
                throw new IllegalArgumentException("Type-class class is not assignable from value class!");
            }
        }

        public Class<?> getTypeClass() {
            return this.clazz;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

