/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.util;

import com.sibvisions.util.ArrayUtil;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupHashtable<G, K, V> {
    private Hashtable<G, Hashtable<K, V>> htGroup = null;

    public synchronized void put(G g, K k, V v) {
        Hashtable<K, V> hashtable = null;
        if (this.htGroup == null) {
            this.htGroup = new Hashtable();
        } else {
            hashtable = this.htGroup.get(g);
        }
        if (hashtable == null) {
            hashtable = new Hashtable();
            this.htGroup.put(g, hashtable);
        }
        hashtable.put(k, v);
    }

    public synchronized void put(G g, Hashtable<K, V> hashtable) {
        if (this.htGroup == null) {
            this.htGroup = new Hashtable();
        }
        this.htGroup.put(g, hashtable);
    }

    public synchronized V get(G g, K k) {
        Hashtable<K, V> hashtable = this.get(g);
        if (hashtable == null) {
            return null;
        }
        return hashtable.get(k);
    }

    public synchronized Hashtable<K, V> get(G g) {
        if (this.htGroup == null) {
            return null;
        }
        return this.htGroup.get(g);
    }

    public synchronized boolean remove(G g) {
        if (this.htGroup != null) {
            return this.htGroup.remove(g) != null;
        }
        return false;
    }

    public synchronized V remove(G g, K k) {
        Hashtable<K, V> hashtable = this.get(g);
        if (hashtable == null) {
            return null;
        }
        return hashtable.remove(k);
    }

    public synchronized int size() {
        if (this.htGroup == null) {
            return 0;
        }
        return this.htGroup.size();
    }

    public synchronized int size(G g) {
        if (this.htGroup == null) {
            return 0;
        }
        Hashtable<K, V> hashtable = this.htGroup.get(g);
        if (hashtable == null) {
            return 0;
        }
        return hashtable.size();
    }

    public synchronized Enumeration<V> elements(G g) {
        Hashtable<K, V> hashtable = this.get(g);
        if (hashtable == null) {
            return null;
        }
        return hashtable.elements();
    }

    public synchronized Enumeration<K> keys(G g) {
        Hashtable<K, V> hashtable = this.get(g);
        if (hashtable == null) {
            return null;
        }
        return hashtable.keys();
    }

    public synchronized Enumeration<G> groups() {
        if (this.htGroup == null) {
            return null;
        }
        return this.htGroup.keys();
    }

    public synchronized List<V> removeKey(K k) {
        if (this.htGroup != null) {
            ArrayUtil<V> arrayUtil = new ArrayUtil<V>();
            Enumeration<Hashtable<K, V>> enumeration = this.htGroup.elements();
            while (enumeration.hasMoreElements()) {
                arrayUtil.add(enumeration.nextElement().remove(k));
            }
            if (!arrayUtil.isEmpty()) {
                return arrayUtil;
            }
        }
        return null;
    }

    public synchronized boolean containsGroup(G g) {
        if (this.htGroup == null) {
            return false;
        }
        return this.htGroup.containsKey(g);
    }

    public synchronized boolean containsValue(G g, V v) {
        Hashtable<K, V> hashtable = this.get(g);
        if (hashtable == null) {
            return false;
        }
        return hashtable.containsValue(v);
    }

    public synchronized boolean containsKey(G g, K k) {
        Hashtable<K, V> hashtable = this.get(g);
        if (hashtable == null) {
            return false;
        }
        return hashtable.containsKey(k);
    }

    public synchronized void clear() {
        if (this.htGroup != null) {
            this.htGroup.clear();
        }
    }

    public synchronized void clear(G g) {
        Hashtable<K, V> hashtable = this.get(g);
        if (hashtable != null) {
            hashtable.clear();
        }
    }
}

