/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui.swing.impl.container;

import com.sibvisions.rad.ui.awt.impl.AwtContainer;
import com.sibvisions.rad.ui.swing.ext.JVxUtil;
import com.sibvisions.rad.ui.swing.ext.focus.TabIndexFocusTraversalPolicy;
import com.sibvisions.rad.ui.swing.impl.container.InternalToolBarPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.lang.reflect.Method;
import javax.rad.ui.ICursor;
import javax.rad.ui.IImage;
import javax.rad.ui.container.IFrame;
import javax.rad.ui.container.IToolBar;
import javax.rad.ui.event.WindowHandler;
import javax.rad.ui.event.type.window.IWindowActivatedListener;
import javax.rad.ui.event.type.window.IWindowClosedListener;
import javax.rad.ui.event.type.window.IWindowClosingListener;
import javax.rad.ui.event.type.window.IWindowDeactivatedListener;
import javax.rad.ui.event.type.window.IWindowDeiconifiedListener;
import javax.rad.ui.event.type.window.IWindowIconifiedListener;
import javax.rad.ui.event.type.window.IWindowOpenedListener;
import javax.rad.ui.menu.IMenuBar;
import javax.rad.util.TranslationMap;
import javax.swing.JRootPane;
import javax.swing.JToolBar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SwingAbstractFrame<C extends Container>
extends AwtContainer<C>
implements IFrame {
    protected WindowHandler<IWindowOpenedListener> eventWindowOpened = null;
    protected WindowHandler<IWindowClosingListener> eventWindowClosing = null;
    protected WindowHandler<IWindowClosedListener> eventWindowClosed = null;
    protected WindowHandler<IWindowActivatedListener> eventWindowActivated = null;
    protected WindowHandler<IWindowDeactivatedListener> eventWindowDeactivated = null;
    protected WindowHandler<IWindowIconifiedListener> eventWindowIconified = null;
    protected WindowHandler<IWindowDeiconifiedListener> eventWindowDeiconified = null;
    protected IImage iconImage = null;
    protected IMenuBar menuBar = null;
    private InternalToolBarPanel toolBarPanel = new InternalToolBarPanel();
    private TranslationMap translation;
    protected boolean bDisposed = false;
    protected boolean bWindowListener = false;

    public SwingAbstractFrame(C c) {
        super(c);
        this.toolBarPanel.setToolBarOwner(this);
        this.toolBarPanel.setBackground(null);
        this.toolBarPanel.setForeground(null);
        this.toolBarPanel.setFont(null);
        this.toolBarPanel.setCursor(null);
        try {
            Method method = c.getClass().getMethod("getRootPane", new Class[0]);
            JRootPane jRootPane = (JRootPane)method.invoke(c, new Object[0]);
            jRootPane.setContentPane(this.toolBarPanel);
        }
        catch (Exception exception) {
            ((Container)this.resource).setLayout(new BorderLayout());
            ((Container)this.resource).add((Component)this.toolBarPanel, "Center");
        }
        ((Container)this.resource).setFocusTraversalPolicy(new TabIndexFocusTraversalPolicy());
    }

    @Override
    public boolean isDisposed() {
        return this.bDisposed;
    }

    @Override
    public IImage getIconImage() {
        return this.iconImage;
    }

    @Override
    public IMenuBar getMenuBar() {
        return this.menuBar;
    }

    @Override
    public void setTranslation(TranslationMap translationMap) {
        this.translation = translationMap;
    }

    @Override
    public TranslationMap getTranslation() {
        return this.translation;
    }

    @Override
    public void addToolBar(IToolBar iToolBar) {
        this.addToolBar(iToolBar, -1);
    }

    @Override
    public void addToolBar(IToolBar iToolBar, int n) {
        this.toolBarPanel.addUIToolBar(iToolBar, n);
    }

    @Override
    public void removeToolBar(IToolBar iToolBar) {
        this.toolBarPanel.removeUIToolBar(iToolBar);
    }

    @Override
    public void removeToolBar(int n) {
        this.toolBarPanel.removeUIToolBar(n);
    }

    @Override
    public void removeAllToolBars() {
        int n;
        while ((n = this.toolBarPanel.getUIToolBarCount()) > 0) {
            this.removeToolBar(n - 1);
        }
    }

    @Override
    public int getToolBarCount() {
        return this.toolBarPanel.getUIToolBarCount();
    }

    @Override
    public IToolBar getToolBar(int n) {
        return this.toolBarPanel.getUIToolBar(n);
    }

    @Override
    public int indexOfToolBar(IToolBar iToolBar) {
        return this.toolBarPanel.indexOfUIToolBar(iToolBar);
    }

    @Override
    public void setToolBarArea(int n) {
        this.toolBarPanel.setUIArea(n);
    }

    @Override
    public int getToolBarArea() {
        return this.toolBarPanel.getUIArea();
    }

    @Override
    public WindowHandler<IWindowOpenedListener> eventWindowOpened() {
        if (this.eventWindowOpened == null) {
            this.eventWindowOpened = new WindowHandler<IWindowOpenedListener>(IWindowOpenedListener.class);
            this.addWindowListener();
        }
        return this.eventWindowOpened;
    }

    @Override
    public WindowHandler<IWindowClosingListener> eventWindowClosing() {
        if (this.eventWindowClosing == null) {
            this.eventWindowClosing = new WindowHandler<IWindowClosingListener>(IWindowClosingListener.class);
            this.addWindowListener();
        }
        return this.eventWindowClosing;
    }

    @Override
    public WindowHandler<IWindowClosedListener> eventWindowClosed() {
        if (this.eventWindowClosed == null) {
            this.eventWindowClosed = new WindowHandler<IWindowClosedListener>(IWindowClosedListener.class);
            this.addWindowListener();
        }
        return this.eventWindowClosed;
    }

    @Override
    public WindowHandler<IWindowIconifiedListener> eventWindowIconified() {
        if (this.eventWindowIconified == null) {
            this.eventWindowIconified = new WindowHandler<IWindowIconifiedListener>(IWindowIconifiedListener.class);
            this.addWindowListener();
        }
        return this.eventWindowIconified;
    }

    @Override
    public WindowHandler<IWindowDeiconifiedListener> eventWindowDeiconified() {
        if (this.eventWindowDeiconified == null) {
            this.eventWindowDeiconified = new WindowHandler<IWindowDeiconifiedListener>(IWindowDeiconifiedListener.class);
            this.addWindowListener();
        }
        return this.eventWindowDeiconified;
    }

    @Override
    public WindowHandler<IWindowActivatedListener> eventWindowActivated() {
        if (this.eventWindowActivated == null) {
            this.eventWindowActivated = new WindowHandler<IWindowActivatedListener>(IWindowActivatedListener.class);
            this.addWindowListener();
        }
        return this.eventWindowActivated;
    }

    @Override
    public WindowHandler<IWindowDeactivatedListener> eventWindowDeactivated() {
        if (this.eventWindowDeactivated == null) {
            this.eventWindowDeactivated = new WindowHandler<IWindowDeactivatedListener>(IWindowDeactivatedListener.class);
            this.addWindowListener();
        }
        return this.eventWindowDeactivated;
    }

    protected abstract void addWindowListenerToResource();

    @Override
    public void setCursor(ICursor iCursor) {
        super.setCursor(iCursor);
        if (iCursor == null) {
            JVxUtil.setGlobalCursor((Component)this.resource, null);
        } else {
            JVxUtil.setGlobalCursor((Component)this.resource, (Cursor)iCursor.getResource());
        }
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }

    @Override
    protected void setLayoutIntern(LayoutManager layoutManager) {
        this.toolBarPanel.setLayout(layoutManager);
    }

    @Override
    protected void addIntern(Component component, Object object, int n) {
        this.toolBarPanel.add(component, object, n);
    }

    @Override
    protected void removeIntern(Component component) {
        this.toolBarPanel.remove(component);
    }

    @Override
    public void dispose() {
        this.bDisposed = true;
    }

    protected void addToolBarIntern(JToolBar jToolBar, int n) {
        this.toolBarPanel.addToolBar(jToolBar, n);
    }

    protected void removeToolBarIntern(JToolBar jToolBar) {
        this.toolBarPanel.removeToolBar(jToolBar);
    }

    protected void addWindowListener() {
        if (!this.bWindowListener) {
            this.bWindowListener = true;
            this.addWindowListenerToResource();
        }
    }
}

