/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui.swing.ext.layout;

import com.sibvisions.rad.ui.swing.ext.JVxUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.HashMap;
import java.util.Map;

public class JVxGridLayout
implements LayoutManager2 {
    private final Map<Component, CellConstraints> constraintMap;
    private Insets margins = new Insets(0, 0, 0, 0);
    private int rows;
    private int columns;
    private int horizontalGap = 0;
    private int verticalGap = 0;
    private int[] xPosition = null;
    private int[] yPosition = null;

    public JVxGridLayout() {
        this(0, 0);
    }

    public JVxGridLayout(int n, int n2) {
        this.rows = n2;
        this.columns = n;
        this.constraintMap = new HashMap<Component, CellConstraints>();
    }

    public void addLayoutComponent(String string, Component component) {
        throw new UnsupportedOperationException("Use #addLayoutComponent(Component, Object) instead.");
    }

    public void removeLayoutComponent(Component component) {
        this.constraintMap.remove(component);
    }

    public Dimension preferredLayoutSize(Container container) {
        int n = 0;
        int n2 = 0;
        int n3 = this.columns;
        int n4 = this.rows;
        for (Map.Entry<Component, CellConstraints> entry : this.constraintMap.entrySet()) {
            int n5;
            Component component = entry.getKey();
            if (!component.isVisible()) continue;
            CellConstraints cellConstraints = entry.getValue();
            Insets insets = cellConstraints.getInsets();
            Dimension dimension = JVxUtil.getPreferredSize(component);
            int n6 = (dimension.width + cellConstraints.gridWidth - 1) / cellConstraints.gridWidth + insets.left + insets.right;
            if (n6 > n) {
                n = n6;
            }
            if ((n5 = (dimension.height + cellConstraints.gridHeight - 1) / cellConstraints.gridHeight + insets.top + insets.bottom) > n2) {
                n2 = n5;
            }
            if (this.columns <= 0 && cellConstraints.gridX + cellConstraints.gridWidth > n3) {
                n3 = cellConstraints.gridX + cellConstraints.gridWidth;
            }
            if (this.rows > 0 || cellConstraints.gridY + cellConstraints.gridHeight <= n4) continue;
            n4 = cellConstraints.gridY + cellConstraints.gridHeight;
        }
        Insets insets = container.getInsets();
        return new Dimension(n * n3 + insets.left + insets.right + this.margins.left + this.margins.right + this.horizontalGap * (n3 - 1), n2 * n4 + insets.bottom + insets.top + this.margins.top + this.margins.bottom + this.verticalGap * (n4 - 1));
    }

    public Dimension minimumLayoutSize(Container container) {
        return new Dimension(0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Dimension dimension = container.getSize();
            Insets insets = container.getInsets();
            int n = this.columns;
            int n2 = this.rows;
            if (this.columns <= 0 || this.rows <= 0) {
                for (Map.Entry<Component, CellConstraints> entry : this.constraintMap.entrySet()) {
                    Component component = entry.getKey();
                    if (!component.isVisible()) continue;
                    CellConstraints cellConstraints = entry.getValue();
                    if (this.columns <= 0 && cellConstraints.gridX + cellConstraints.gridWidth > n) {
                        n = cellConstraints.gridX + cellConstraints.gridWidth;
                    }
                    if (this.rows > 0 || cellConstraints.gridY + cellConstraints.gridHeight <= n2) continue;
                    n2 = cellConstraints.gridY + cellConstraints.gridHeight;
                }
            }
            if (n > 0 && n2 > 0) {
                int n3;
                int n4 = insets.left + this.margins.left;
                int n5 = insets.top + this.margins.top;
                int n6 = (n - 1) * this.horizontalGap;
                int n7 = (n2 - 1) * this.verticalGap;
                int n8 = dimension.width - n4 - insets.right - this.margins.right - n6;
                int n9 = dimension.height - n5 - insets.bottom - this.margins.bottom - n7;
                int n10 = n8 / n;
                int n11 = n9 / n2;
                int n12 = n8 - n10 * n;
                int n13 = n9 - n11 * n2;
                int n14 = 0;
                if (n12 > 0) {
                    n14 = (n / n12 + 1) / 2;
                }
                int n15 = 0;
                if (n13 > 0) {
                    n15 = (n2 / n13 + 1) / 2;
                }
                if (this.xPosition == null || this.xPosition.length != n + 1) {
                    this.xPosition = new int[n + 1];
                }
                this.xPosition[0] = n4;
                int n16 = 0;
                for (n3 = 0; n3 < n; ++n3) {
                    this.xPosition[n3 + 1] = this.xPosition[n3] + n10 + this.horizontalGap;
                    if (n12 <= 0 || n16 * n / n12 + n14 != n3) continue;
                    int n17 = n3 + 1;
                    this.xPosition[n17] = this.xPosition[n17] + 1;
                    ++n16;
                }
                if (this.yPosition == null || this.yPosition.length != n2 + 1) {
                    this.yPosition = new int[n2 + 1];
                }
                this.yPosition[0] = n5;
                n3 = 0;
                for (int i = 0; i < n2; ++i) {
                    this.yPosition[i + 1] = this.yPosition[i] + n11 + this.verticalGap;
                    if (n13 <= 0 || n3 * n2 / n13 + n15 != i) continue;
                    int n18 = i + 1;
                    this.yPosition[n18] = this.yPosition[n18] + 1;
                    ++n3;
                }
                for (Map.Entry<Component, CellConstraints> entry : this.constraintMap.entrySet()) {
                    Component component = entry.getKey();
                    if (!component.isVisible()) continue;
                    CellConstraints cellConstraints = entry.getValue();
                    Insets insets2 = cellConstraints.insets;
                    int n19 = JVxGridLayout.getPosition(this.xPosition, cellConstraints.gridX, n10, this.horizontalGap) + insets2.left;
                    int n20 = JVxGridLayout.getPosition(this.yPosition, cellConstraints.gridY, n11, this.verticalGap) + insets2.top;
                    component.setBounds(n19, n20, JVxGridLayout.getPosition(this.xPosition, cellConstraints.gridX + cellConstraints.gridWidth, n10, this.horizontalGap) - this.horizontalGap - n19 - insets2.right, JVxGridLayout.getPosition(this.yPosition, cellConstraints.gridY + cellConstraints.gridHeight, n11, this.verticalGap) - this.verticalGap - n20 - insets2.bottom);
                }
            }
        }
    }

    private static int getPosition(int[] nArray, int n, int n2, int n3) {
        if (n < 0) {
            return nArray[0] + n * (n2 + n3);
        }
        if (n >= nArray.length) {
            return nArray[nArray.length - 1] + (n - nArray.length + 1) * (n2 + n3);
        }
        return nArray[n];
    }

    public void addLayoutComponent(Component component, Object object) {
        JVxGridLayout.checkNotNull(object, "The constraints must not be null.");
        if (!(object instanceof CellConstraints)) {
            throw new IllegalArgumentException("Illegal constraint type " + object.getClass());
        }
        this.setConstraints(component, (CellConstraints)object);
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public void invalidateLayout(Container container) {
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int n) {
        this.columns = n;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int n) {
        this.rows = n;
    }

    public CellConstraints getConstraints(Component component) {
        return this.constraintMap.get(component);
    }

    public CellConstraints getConstraints(int n, int n2) {
        return new CellConstraints(n, n2, 1, 1);
    }

    public CellConstraints getConstraints(int n, int n2, int n3, int n4) {
        return new CellConstraints(n, n2, n3, n4);
    }

    public CellConstraints getConstraints(int n, int n2, int n3, int n4, Insets insets) {
        return new CellConstraints(n, n2, n3, n4, insets);
    }

    public void setConstraints(Component component, CellConstraints cellConstraints) {
        JVxGridLayout.checkNotNull(component, "The component must not be null.");
        JVxGridLayout.checkNotNull(cellConstraints, "The constraints must not be null.");
        this.constraintMap.put(component, (CellConstraints)cellConstraints.clone());
    }

    public Insets getMargins() {
        return this.margins;
    }

    public void setMargins(Insets insets) {
        this.margins = insets == null ? new Insets(0, 0, 0, 0) : insets;
    }

    public int getHorizontalGap() {
        return this.horizontalGap;
    }

    public void setHorizontalGap(int n) {
        this.horizontalGap = n;
    }

    public int getVerticalGap() {
        return this.verticalGap;
    }

    public void setVerticalGap(int n) {
        this.verticalGap = n;
    }

    public static void checkNotNull(Object object, String string) {
        if (object == null) {
            throw new NullPointerException(string);
        }
    }

    public static class CellConstraints
    implements Cloneable {
        private int gridX;
        private int gridY;
        private int gridWidth;
        private int gridHeight;
        private Insets insets;

        public CellConstraints() {
            this(0, 0);
        }

        public CellConstraints(int n, int n2) {
            this(n, n2, 1, 1, null);
        }

        public CellConstraints(int n, int n2, int n3, int n4) {
            this(n, n2, n3, n4, null);
        }

        public CellConstraints(int n, int n2, int n3, int n4, Insets insets) {
            this.setGridX(n);
            this.setGridY(n2);
            this.setGridWidth(n3);
            this.setGridHeight(n4);
            this.setInsets(insets);
        }

        public int getGridX() {
            return this.gridX;
        }

        public void setGridX(int n) {
            if (n < 0) {
                throw new IndexOutOfBoundsException("The grid x must be a positive number.");
            }
            this.gridX = n;
        }

        public int getGridY() {
            return this.gridY;
        }

        public void setGridY(int n) {
            if (n < 0) {
                throw new IndexOutOfBoundsException("The grid y must be a positive number.");
            }
            this.gridY = n;
        }

        public int getGridWidth() {
            return this.gridWidth;
        }

        public void setGridWidth(int n) {
            if (n <= 0) {
                throw new IndexOutOfBoundsException("The grid width must be a positive number.");
            }
            this.gridWidth = n;
        }

        public int getGridHeight() {
            return this.gridHeight;
        }

        public void setGridHeight(int n) {
            if (n <= 0) {
                throw new IndexOutOfBoundsException("The grid height must be a positive number.");
            }
            this.gridHeight = n;
        }

        public Insets getInsets() {
            return this.insets;
        }

        public void setInsets(Insets insets) {
            this.insets = insets == null ? new Insets(0, 0, 0, 0) : insets;
        }

        public Object clone() {
            try {
                CellConstraints cellConstraints = (CellConstraints)super.clone();
                cellConstraints.insets = (Insets)this.insets.clone();
                return cellConstraints;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError();
            }
        }
    }
}

