/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui.swing.ext;

import com.sibvisions.rad.ui.ApplicationUtil;
import com.sibvisions.rad.ui.swing.ext.JVxToggleButton;
import com.sibvisions.rad.ui.swing.ext.JVxUtil;
import com.sibvisions.rad.ui.swing.ext.layout.JVxGridLayout;
import com.sibvisions.util.ArrayUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.rad.model.ui.ITranslatable;
import javax.rad.util.TranslationMap;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.SpinnerDateModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.PanelUI;

public class JVxCalendarPane
extends JPanel
implements ChangeListener,
PropertyChangeListener,
KeyListener,
MouseListener,
FocusListener,
Runnable,
ITranslatable {
    private JSpinner years = new JSpinner(new SpinnerDateModel());
    private JSpinner months = new JSpinner(new SpinnerDateModel());
    private JSpinner currentTime;
    private JSpinner timeMinutes = new JSpinner(new SpinnerDateModel());
    private JSpinner timeSeconds = new JSpinner(new SpinnerDateModel());
    private JSpinner timeMinutes12 = new JSpinner(new SpinnerDateModel());
    private JSpinner timeSeconds12 = new JSpinner(new SpinnerDateModel());
    private JLabel spacer = new JLabel();
    private JLabel[] weekDays = new JLabel[7];
    private JLabel[] weeks = new JLabel[6];
    private JToggleButton[] days = new JToggleButton[42];
    private GregorianCalendar calendar;
    private Date date = null;
    private String actionCommand = null;
    private TranslationMap translation = null;
    private int selectedIndex = -1;
    private boolean ignoreEvent = false;
    private boolean bTranslationEnabled = true;

    public JVxCalendarPane() {
        JComponent jComponent;
        int n;
        JVxGridLayout jVxGridLayout = new JVxGridLayout(3, 1);
        JPanel jPanel = new JPanel(jVxGridLayout);
        jPanel.setBackground(SystemColor.control);
        jPanel.add((Component)this.months, jVxGridLayout.getConstraints(0, 0));
        jPanel.add((Component)this.years, jVxGridLayout.getConstraints(1, 0));
        jPanel.add((Component)this.timeSeconds, jVxGridLayout.getConstraints(2, 0));
        jPanel.add((Component)this.timeMinutes, jVxGridLayout.getConstraints(2, 0));
        jPanel.add((Component)this.timeSeconds12, jVxGridLayout.getConstraints(2, 0));
        jPanel.add((Component)this.timeMinutes12, jVxGridLayout.getConstraints(2, 0));
        JPanel jPanel2 = new JPanel(new GridLayout(7, 8));
        jPanel2.setBackground(SystemColor.window);
        this.spacer.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, Color.gray));
        this.spacer.setOpaque(true);
        this.spacer.setBackground(SystemColor.control);
        this.spacer.setHorizontalAlignment(0);
        jPanel2.add(this.spacer);
        for (n = 0; n < 7; ++n) {
            jComponent = new JLabel();
            this.weekDays[n] = jComponent;
            jComponent.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.gray));
            jComponent.setOpaque(true);
            jComponent.setBackground(SystemColor.control);
            ((JLabel)jComponent).setHorizontalAlignment(0);
            if (n % 7 >= 5) {
                jComponent.setForeground(Color.red);
            }
            jPanel2.add(jComponent);
        }
        for (n = 0; n < 42; ++n) {
            if (n % 7 == 0) {
                jComponent = new JLabel();
                this.weeks[n / 7] = jComponent;
                jComponent.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, Color.gray));
                jComponent.setOpaque(true);
                jComponent.setBackground(SystemColor.control);
                ((JLabel)jComponent).setHorizontalAlignment(0);
                jPanel2.add(jComponent);
            }
            jComponent = new JVxToggleButton();
            if (ApplicationUtil.isMacOS()) {
                ((AbstractButton)jComponent).setIcon(JVxUtil.getIcon("/com/sibvisions/rad/ui/swing/ext/images/1x1.png"));
                ((AbstractButton)jComponent).setIconTextGap(0);
            }
            ((AbstractButton)jComponent).setMargin(new Insets(1, 4, 1, 4));
            ((AbstractButton)jComponent).setHorizontalAlignment(0);
            ((JVxToggleButton)jComponent).setBorderOnMouseEntered(true);
            jComponent.setFocusable(false);
            jComponent.addMouseListener(this);
            jComponent.addKeyListener(this);
            jPanel2.add(jComponent);
            this.days[n] = jComponent;
        }
        this.setFocusable(true);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "North");
        this.add((Component)jPanel2, "Center");
        this.years.setFont(this.spacer.getFont());
        this.months.setFont(this.spacer.getFont());
        this.timeSeconds.setFont(this.spacer.getFont());
        this.timeMinutes.setFont(this.spacer.getFont());
        this.timeSeconds12.setFont(this.spacer.getFont());
        this.timeMinutes12.setFont(this.spacer.getFont());
        this.createDateEditor(this.months, "MMMM");
        this.createDateEditor(this.years, "yyyy");
        this.createDateEditor(this.timeSeconds, "HH:mm:ss");
        this.createDateEditor(this.timeMinutes, "HH:mm");
        this.createDateEditor(this.timeSeconds12, "hh:mm:ss a");
        this.createDateEditor(this.timeMinutes12, "hh:mm a");
        this.years.addChangeListener(this);
        this.months.addChangeListener(this);
        this.timeSeconds.addChangeListener(this);
        this.timeMinutes.addChangeListener(this);
        this.timeSeconds12.addChangeListener(this);
        this.timeMinutes12.addChangeListener(this);
        this.currentTime = this.timeMinutes;
        this.setTimeVisible(true);
        this.setLocaleIntern();
    }

    public void run() {
        for (int i = 0; i < this.days.length; ++i) {
            this.days[i].removeMouseListener(this);
            this.days[i].addMouseListener(this);
        }
        this.years.setFont(this.spacer.getFont());
        this.months.setFont(this.spacer.getFont());
        this.timeSeconds.setFont(this.spacer.getFont());
        this.timeMinutes.setFont(this.spacer.getFont());
        this.timeSeconds12.setFont(this.spacer.getFont());
        this.timeMinutes12.setFont(this.spacer.getFont());
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (!this.ignoreEvent) {
            JSpinner jSpinner = (JSpinner)changeEvent.getSource();
            this.setDate((Date)jSpinner.getValue());
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!this.ignoreEvent && "value" == propertyChangeEvent.getPropertyName()) {
            this.calendar.setTime((Date)propertyChangeEvent.getNewValue());
            Object object = propertyChangeEvent.getSource();
            if (object == ((JSpinner.DateEditor)this.currentTime.getEditor()).getTextField()) {
                int n = this.calendar.get(11);
                int n2 = this.calendar.get(12);
                int n3 = this.calendar.get(13);
                int n4 = this.calendar.get(14);
                this.calendar.setTime(this.date);
                this.calendar.set(11, n);
                this.calendar.set(12, n2);
                this.calendar.set(13, n3);
                this.calendar.set(14, n4);
            } else if (object == ((JSpinner.DateEditor)this.months.getEditor()).getTextField()) {
                int n = this.calendar.get(2);
                this.calendar.setTime(this.date);
                this.calendar.set(2, n);
            } else {
                int n = this.calendar.get(1);
                this.calendar.setTime(this.date);
                this.calendar.set(1, n);
            }
            this.setDate(this.calendar.getTime());
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getSource() instanceof JVxToggleButton) {
            switch (keyEvent.getKeyCode()) {
                case 33: {
                    this.calendar.setTime(this.date);
                    this.calendar.add(2, -1);
                    this.setDate(this.calendar.getTime());
                    this.days[this.selectedIndex].requestFocus();
                    break;
                }
                case 34: {
                    this.calendar.setTime(this.date);
                    this.calendar.add(2, 1);
                    this.setDate(this.calendar.getTime());
                    this.days[this.selectedIndex].requestFocus();
                    break;
                }
                case 38: {
                    this.calendar.setTime(this.date);
                    this.calendar.add(5, -7);
                    this.setDate(this.calendar.getTime());
                    this.days[this.selectedIndex].requestFocus();
                    break;
                }
                case 40: {
                    this.calendar.setTime(this.date);
                    this.calendar.add(5, 7);
                    this.setDate(this.calendar.getTime());
                    this.days[this.selectedIndex].requestFocus();
                    break;
                }
                case 37: {
                    this.calendar.setTime(this.date);
                    this.calendar.add(5, -1);
                    this.setDate(this.calendar.getTime());
                    this.days[this.selectedIndex].requestFocus();
                    break;
                }
                case 39: {
                    this.calendar.setTime(this.date);
                    this.calendar.add(5, 1);
                    this.setDate(this.calendar.getTime());
                    this.days[this.selectedIndex].requestFocus();
                    break;
                }
            }
        }
        switch (keyEvent.getKeyCode()) {
            case 27: {
                Container container;
                for (container = this.getParent(); container != null && !(container instanceof JPopupMenu); container = container.getParent()) {
                }
                if (!(container instanceof JPopupMenu)) break;
                JPopupMenu jPopupMenu = (JPopupMenu)container;
                jPopupMenu.putClientProperty("JPopupMenu.firePopupMenuCanceled", Boolean.TRUE);
                jPopupMenu.setVisible(false);
                break;
            }
        }
        this.repaint();
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        switch (keyEvent.getKeyChar()) {
            case '\n': 
            case ' ': {
                this.processActionEvent(new ActionEvent(this, 1001, this.getActionCommand(), keyEvent.getWhen(), keyEvent.getModifiers()));
                break;
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        int n = ArrayUtil.indexOf(this.days, mouseEvent.getSource());
        if (this.selectedIndex == n) {
            this.days[n].setSelected(true);
            this.processActionEvent(new ActionEvent(this, 1001, this.getActionCommand(), mouseEvent.getWhen(), mouseEvent.getModifiers()));
        } else {
            this.calendar.setTime(this.date);
            this.calendar.add(5, n - this.selectedIndex);
            this.setDate(this.calendar.getTime());
            this.days[this.selectedIndex].requestFocus();
        }
    }

    public void focusGained(final FocusEvent focusEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ((JFormattedTextField)focusEvent.getSource()).selectAll();
            }
        });
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void setTranslation(TranslationMap translationMap) {
        if (this.translation != translationMap) {
            this.translation = translationMap;
            this.setLocaleIntern();
        }
    }

    public TranslationMap getTranslation() {
        return this.translation;
    }

    public void setTranslationEnabled(boolean bl) {
        this.bTranslationEnabled = bl;
    }

    public boolean isTranslationEnabled() {
        return this.bTranslationEnabled;
    }

    public void setUI(PanelUI panelUI) {
        super.setUI(panelUI);
        if (this.days != null) {
            SwingUtilities.invokeLater(this);
        }
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.setLocaleIntern();
    }

    public void requestFocus() {
        if (this.selectedIndex >= 0) {
            this.days[this.selectedIndex].requestFocus();
        } else {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
        }
        this.setFocusable(false);
    }

    public void addNotify() {
        super.addNotify();
        this.setFocusable(true);
    }

    private void createDateEditor(JSpinner jSpinner, String string) {
        JSpinner.DateEditor dateEditor = new JSpinner.DateEditor(jSpinner, string);
        jSpinner.setEditor(dateEditor);
        dateEditor.getTextField().setHorizontalAlignment(0);
        dateEditor.getTextField().removePropertyChangeListener(dateEditor);
        dateEditor.getTextField().addPropertyChangeListener(this);
        dateEditor.getTextField().addKeyListener(this);
        dateEditor.getTextField().addFocusListener(this);
    }

    private void setLocaleIntern() {
        this.ignoreEvent = true;
        Locale locale = this.translation != null && this.translation.getLanguage() != null ? new Locale(this.translation.getLanguage()) : this.getLocale();
        this.months.setLocale(locale);
        this.years.setLocale(locale);
        this.timeSeconds.setLocale(locale);
        this.timeMinutes.setLocale(locale);
        this.timeSeconds12.setLocale(locale);
        this.timeMinutes12.setLocale(locale);
        this.createDateEditor(this.months, "MMMM");
        this.createDateEditor(this.years, "yyyy");
        this.createDateEditor(this.timeSeconds, "HH:mm:ss");
        this.createDateEditor(this.timeMinutes, "HH:mm");
        this.createDateEditor(this.timeSeconds12, "hh:mm:ss a");
        this.createDateEditor(this.timeMinutes12, "hh:mm a");
        this.calendar = new GregorianCalendar(locale);
        String[] stringArray = new DateFormatSymbols(locale).getShortWeekdays();
        for (int i = 0; i < 7; ++i) {
            this.weekDays[i].setText(stringArray[(i + 1) % 7 + 1]);
        }
        this.setDateIntern();
    }

    public boolean isTimeVisible() {
        return this.currentTime.isVisible();
    }

    public void setTimeVisible(boolean bl) {
        this.timeSeconds.setVisible(false);
        this.timeMinutes.setVisible(false);
        this.timeSeconds12.setVisible(false);
        this.timeMinutes12.setVisible(false);
        this.currentTime.setVisible(bl);
        JVxGridLayout jVxGridLayout = (JVxGridLayout)this.years.getParent().getLayout();
        if (bl) {
            jVxGridLayout.setConstraints(this.months, jVxGridLayout.getConstraints(0, 0));
            jVxGridLayout.setConstraints(this.years, jVxGridLayout.getConstraints(1, 0));
        } else {
            jVxGridLayout.setConstraints(this.months, jVxGridLayout.getConstraints(0, 0, 2, 1));
            jVxGridLayout.setConstraints(this.years, jVxGridLayout.getConstraints(2, 0));
        }
    }

    public boolean isShowSeconds() {
        return this.currentTime == this.timeSeconds || this.currentTime == this.timeSeconds12;
    }

    public void setShowSeconds(boolean bl) {
        boolean bl2 = this.isTimeVisible();
        this.setTimeVisible(false);
        this.setCurrentTime(bl, this.isShowAmPm());
        this.setTimeVisible(bl2);
    }

    public boolean isShowAmPm() {
        return this.currentTime == this.timeSeconds12 || this.currentTime == this.timeMinutes12;
    }

    public void setShowAmPm(boolean bl) {
        boolean bl2 = this.isTimeVisible();
        this.setTimeVisible(false);
        this.setCurrentTime(this.isShowSeconds(), bl);
        this.setTimeVisible(bl2);
    }

    private void setCurrentTime(boolean bl, boolean bl2) {
        this.currentTime = bl && bl2 ? this.timeSeconds12 : (!bl && bl2 ? this.timeMinutes12 : (bl && !bl2 ? this.timeSeconds : this.timeMinutes));
    }

    private void setDateIntern() {
        this.ignoreEvent = true;
        if (this.date == null) {
            this.calendar.setTime(new Date());
            this.calendar.set(11, 0);
            this.calendar.set(12, 0);
            this.calendar.set(13, 0);
            this.calendar.set(14, 0);
            this.date = this.calendar.getTime();
        } else {
            this.calendar.setTime(this.date);
        }
        this.years.setValue(this.calendar.getTime());
        this.months.setValue(this.calendar.getTime());
        this.currentTime.setValue(this.calendar.getTime());
        int n = this.calendar.get(2);
        int n2 = this.calendar.get(5);
        this.calendar.add(5, -this.calendar.get(5) + 1);
        int n3 = this.calendar.get(7);
        if (n3 <= 2) {
            n3 += 7;
        }
        this.calendar.add(5, -n3 + 2);
        GregorianCalendar gregorianCalendar = (GregorianCalendar)this.calendar.clone();
        for (int i = 0; i < 42; ++i) {
            if (i % 7 == 0) {
                this.weeks[i / 7].setText(String.valueOf(gregorianCalendar.get(3)));
            }
            this.days[i].setText(String.valueOf(gregorianCalendar.get(5)));
            this.days[i].setEnabled(gregorianCalendar.get(2) == n);
            if (gregorianCalendar.get(2) == n) {
                if (i % 7 >= 5) {
                    this.days[i].setForeground(Color.red);
                } else {
                    this.days[i].setForeground(Color.black);
                }
            } else if (i % 7 >= 5) {
                this.days[i].setForeground(Color.red.darker());
            } else {
                this.days[i].setForeground(Color.lightGray);
            }
            if (gregorianCalendar.get(2) == n && gregorianCalendar.get(5) == n2) {
                this.selectedIndex = i;
                if (!this.days[i].isSelected()) {
                    this.days[i].setSelected(true);
                }
                this.days[i].setFocusable(true);
            } else if (this.days[i].isSelected()) {
                this.days[i].setSelected(false);
                this.days[i].setFocusable(false);
            }
            gregorianCalendar.add(5, 1);
        }
        this.ignoreEvent = false;
    }

    public Date getDate() {
        this.ignoreEvent = true;
        try {
            ((JSpinner.DateEditor)this.currentTime.getEditor()).getTextField().commitEdit();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        try {
            ((JSpinner.DateEditor)this.months.getEditor()).getTextField().commitEdit();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        try {
            ((JSpinner.DateEditor)this.years.getEditor()).getTextField().commitEdit();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        this.ignoreEvent = false;
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
        this.setDateIntern();
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(ActionListener.class, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        if (actionListener != null) {
            this.listenerList.remove(ActionListener.class, actionListener);
        }
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        ActionEvent actionEvent2 = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ActionListener.class) continue;
            ((ActionListener)objectArray[i + 1]).actionPerformed(actionEvent2);
        }
    }

    protected String translate(String string) {
        if (this.bTranslationEnabled && this.translation != null) {
            return this.translation.translate(string);
        }
        return string;
    }
}

