/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui;

import com.sibvisions.util.type.FileUtil;
import com.sibvisions.util.xml.XmlNode;
import com.sibvisions.util.xml.XmlWorker;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.jnlp.BasicService;
import javax.jnlp.ClipboardService;
import javax.jnlp.FileContents;
import javax.jnlp.FileOpenService;
import javax.jnlp.FileSaveService;
import javax.jnlp.PersistenceService;
import javax.jnlp.ServiceManager;
import javax.rad.io.FileHandle;
import javax.rad.io.IFileHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class WebstartImpl {
    private static final DataFlavor FLAVOR_TEXT = WebstartImpl.createDataFlavor("text/plain; charset=unicode; class=java.io.InputStream", "Plain Text");
    private static final DataFlavor FLAVOR_STRING = WebstartImpl.createDataFlavor(String.class, "Unicode String");

    private WebstartImpl() {
    }

    private static DataFlavor createDataFlavor(String string, String string2) {
        try {
            return new DataFlavor(string, string2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static DataFlavor createDataFlavor(Class<?> clazz, String string) {
        try {
            return new DataFlavor(String.class, "Unicode String");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean showDocument(String string) throws Exception {
        URL uRL;
        BasicService basicService = (BasicService)ServiceManager.lookup((String)"javax.jnlp.BasicService");
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            uRL = new URL("file://" + string);
        }
        return basicService.showDocument(uRL);
    }

    public static IFileHandle[] openFileDialog(boolean bl) throws Exception {
        FileOpenService fileOpenService = (FileOpenService)ServiceManager.lookup((String)"javax.jnlp.FileOpenService");
        if (bl) {
            FileContents[] fileContentsArray = fileOpenService.openMultiFileDialog(null, null);
            if (fileContentsArray != null) {
                IFileHandle[] iFileHandleArray = new FileHandle[fileContentsArray.length];
                for (int i = 0; i < fileContentsArray.length; ++i) {
                    iFileHandleArray[i] = new FileHandle(fileContentsArray[i].getName(), fileContentsArray[i].getInputStream());
                }
                return iFileHandleArray;
            }
            return null;
        }
        FileContents fileContents = fileOpenService.openFileDialog(null, null);
        if (fileContents != null) {
            return new FileHandle[]{new FileHandle(fileContents.getName(), fileContents.getInputStream())};
        }
        return null;
    }

    public static void saveFileDialog(IFileHandle iFileHandle) throws Exception {
        FileSaveService fileSaveService = (FileSaveService)ServiceManager.lookup((String)"javax.jnlp.FileSaveService");
        fileSaveService.saveFileDialog(null, null, iFileHandle.getInputStream(), iFileHandle.getFileName());
    }

    public static String getCodeBase() throws Exception {
        BasicService basicService = (BasicService)ServiceManager.lookup((String)"javax.jnlp.BasicService");
        return basicService.getCodeBase().toString();
    }

    public static void setClipboard(String string) throws Exception {
        ClipboardService clipboardService = (ClipboardService)ServiceManager.lookup((String)"javax.jnlp.ClipboardService");
        clipboardService.setContents((Transferable)new StringSelection(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getClipboard() throws Exception {
        ClipboardService clipboardService = (ClipboardService)ServiceManager.lookup((String)"javax.jnlp.ClipboardService");
        Transferable transferable = clipboardService.getContents();
        if (transferable != null) {
            Object object = transferable.getTransferData(FLAVOR_TEXT);
            if (object != null) {
                if (object instanceof Reader) {
                    StringBuilder stringBuilder = new StringBuilder();
                    char[] cArray = new char[256];
                    Reader reader = (Reader)object;
                    try {
                        int n;
                        while ((n = reader.read(cArray)) >= 0) {
                            stringBuilder.append(cArray, 0, n);
                        }
                    }
                    finally {
                        try {
                            reader.close();
                        }
                        catch (Exception exception) {}
                    }
                    return stringBuilder.toString();
                }
                if (object instanceof InputStream) {
                    return new String(FileUtil.getContent((InputStream)object));
                }
            } else {
                return (String)transferable.getTransferData(FLAVOR_STRING);
            }
        }
        return null;
    }

    public static Object getClipboard(DataFlavor dataFlavor) throws Exception {
        ClipboardService clipboardService = (ClipboardService)ServiceManager.lookup((String)"javax.jnlp.ClipboardService");
        Transferable transferable = clipboardService.getContents();
        if (transferable != null) {
            return transferable.getTransferData(dataFlavor);
        }
        return null;
    }

    public static void setProperty(String string, String string2) {
        try {
            FileContents fileContents;
            PersistenceService persistenceService = (PersistenceService)ServiceManager.lookup((String)"javax.jnlp.PersistenceService");
            URL uRL = new URL(WebstartImpl.getCodeBase());
            XmlWorker xmlWorker = new XmlWorker();
            XmlNode xmlNode = null;
            try {
                fileContents = persistenceService.get(uRL);
                xmlNode = xmlWorker.read(fileContents.getInputStream());
            }
            catch (FileNotFoundException fileNotFoundException) {
                persistenceService.create(uRL, 2048000L);
                fileContents = persistenceService.get(uRL);
            }
            if (xmlNode == null) {
                xmlNode = XmlNode.createXmlDeclaration();
            }
            xmlNode.setNode("/registry/" + string.replace("/", "_"), string2);
            OutputStream outputStream = fileContents.getOutputStream(true);
            xmlWorker.write(outputStream, xmlNode);
            outputStream.flush();
            outputStream.close();
            persistenceService.setTag(uRL, 0);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static String getProperty(String string) {
        try {
            PersistenceService persistenceService = (PersistenceService)ServiceManager.lookup((String)"javax.jnlp.PersistenceService");
            URL uRL = new URL(WebstartImpl.getCodeBase());
            XmlWorker xmlWorker = new XmlWorker();
            try {
                FileContents fileContents = persistenceService.get(uRL);
                XmlNode xmlNode = xmlWorker.read(fileContents.getInputStream());
                if (xmlNode != null && (xmlNode = xmlNode.getNode("/registry/" + string.replace("/", "_"))) != null) {
                    return xmlNode.getValue();
                }
                return null;
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

