/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.remote.serializer;

import com.sibvisions.rad.remote.UniversalSerializer;
import com.sibvisions.rad.remote.serializer.AbstractSizedSerializer;
import com.sibvisions.rad.remote.serializer.ITypeSerializer;
import com.sibvisions.rad.remote.serializer.TypeCache;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapSerializer
extends AbstractSizedSerializer
implements ITypeSerializer<Map> {
    private static final int TYPE_MAP_MIN = 45;
    private static final int TYPE_MAP_MAX = 47;
    private ArrayList<Class<? extends Map>> registeredMaps = new ArrayList();
    private HashMap<Class<? extends Map>, Integer> mapOrder = new HashMap();

    public MapSerializer() {
        this.registerMap(HashMap.class);
        this.registerMap(Hashtable.class);
        this.registerMap(Properties.class);
    }

    @Override
    public Class<Map> getTypeClass() {
        return Map.class;
    }

    @Override
    public int getMinValue() {
        return 45;
    }

    @Override
    public int getMaxValue() {
        return 47;
    }

    @Override
    public Map read(UniversalSerializer universalSerializer, DataInputStream dataInputStream, int n, TypeCache typeCache) throws Exception {
        Map<Object, Object> map;
        int n2 = this.readSize(dataInputStream, n, 45, 47);
        int n3 = dataInputStream.readUnsignedByte();
        try {
            map = this.registeredMaps.get(n3).newInstance();
        }
        catch (Exception exception) {
            map = new HashMap(n2);
        }
        for (int i = 0; i < n2; ++i) {
            map.put(universalSerializer.read(dataInputStream, typeCache), universalSerializer.read(dataInputStream, typeCache));
        }
        return map;
    }

    @Override
    public void write(UniversalSerializer universalSerializer, DataOutputStream dataOutputStream, Map map, TypeCache typeCache) throws Exception {
        this.writeSize(dataOutputStream, map.size(), 45, 47);
        Integer n = this.mapOrder.get(map.getClass());
        if (n == null) {
            dataOutputStream.writeByte(0);
        } else {
            dataOutputStream.writeByte(n);
        }
        for (Map.Entry entry : map.entrySet()) {
            universalSerializer.write(dataOutputStream, entry.getKey(), typeCache);
            universalSerializer.write(dataOutputStream, entry.getValue(), typeCache);
        }
    }

    public void registerMap(Class<? extends Map> clazz) {
        if (this.mapOrder.get(clazz) == null) {
            this.mapOrder.put(clazz, this.registeredMaps.size());
            this.registeredMaps.add(clazz);
        }
    }
}

