/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.remote.serializer;

import com.sibvisions.rad.remote.UniversalSerializer;
import com.sibvisions.rad.remote.serializer.ITypeSerializer;
import com.sibvisions.rad.remote.serializer.TypeCache;
import java.io.DataInputStream;
import java.io.DataOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatSerializer
implements ITypeSerializer<Float> {
    private static final int TYPE_FLOAT = 5;
    private static final int TYPE_FLOAT_0 = 6;
    private static final Float FLOAT_0 = Float.valueOf(0.0f);

    @Override
    public Class<Float> getTypeClass() {
        return Float.class;
    }

    @Override
    public int getMinValue() {
        return 5;
    }

    @Override
    public int getMaxValue() {
        return 6;
    }

    @Override
    public Float read(UniversalSerializer universalSerializer, DataInputStream dataInputStream, int n, TypeCache typeCache) throws Exception {
        if (n == 5) {
            return Float.valueOf(dataInputStream.readFloat());
        }
        return FLOAT_0;
    }

    @Override
    public void write(UniversalSerializer universalSerializer, DataOutputStream dataOutputStream, Float f, TypeCache typeCache) throws Exception {
        float f2 = f.floatValue();
        if (f2 == 0.0f) {
            dataOutputStream.writeByte(6);
        } else {
            dataOutputStream.writeByte(5);
            dataOutputStream.writeFloat(f2);
        }
    }
}

