/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.extractors;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.scribejava.core.extractors.AbstractJsonExtractor;
import com.github.scribejava.core.extractors.OAuth2AccessTokenJsonExtractor;
import com.github.scribejava.core.model.DeviceAuthorization;
import com.github.scribejava.core.model.Response;
import java.io.IOException;

public class DeviceAuthorizationJsonExtractor
extends AbstractJsonExtractor {
    protected DeviceAuthorizationJsonExtractor() {
    }

    public static DeviceAuthorizationJsonExtractor instance() {
        return InstanceHolder.INSTANCE;
    }

    public DeviceAuthorization extract(Response response) throws IOException {
        String body = response.getBody();
        if (response.getCode() != 200) {
            this.generateError(body);
        }
        return this.createDeviceAuthorization(body);
    }

    public void generateError(String rawResponse) throws IOException {
        OAuth2AccessTokenJsonExtractor.instance().generateError(rawResponse);
    }

    private DeviceAuthorization createDeviceAuthorization(String rawResponse) throws IOException {
        JsonNode verificationUriComplete;
        JsonNode response = OBJECT_MAPPER.readTree(rawResponse);
        DeviceAuthorization deviceAuthorization = new DeviceAuthorization(DeviceAuthorizationJsonExtractor.extractRequiredParameter(response, "device_code", rawResponse).textValue(), DeviceAuthorizationJsonExtractor.extractRequiredParameter(response, "user_code", rawResponse).textValue(), DeviceAuthorizationJsonExtractor.extractRequiredParameter(response, this.getVerificationUriParamName(), rawResponse).textValue(), DeviceAuthorizationJsonExtractor.extractRequiredParameter(response, "expires_in", rawResponse).intValue());
        JsonNode intervalSeconds = response.get("interval");
        if (intervalSeconds != null) {
            deviceAuthorization.setIntervalSeconds(intervalSeconds.asInt(5));
        }
        if ((verificationUriComplete = response.get("verification_uri_complete")) != null) {
            deviceAuthorization.setVerificationUriComplete(verificationUriComplete.asText());
        }
        return deviceAuthorization;
    }

    protected String getVerificationUriParamName() {
        return "verification_uri";
    }

    private static class InstanceHolder {
        private static final DeviceAuthorizationJsonExtractor INSTANCE = new DeviceAuthorizationJsonExtractor();

        private InstanceHolder() {
        }
    }
}

