/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.apis.examples;

import com.github.scribejava.apis.MicrosoftAzureActiveDirectoryApi;
import com.github.scribejava.core.builder.ServiceBuilder;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.core.oauth.OAuth20Service;
import java.io.IOException;
import java.util.Scanner;
import java.util.concurrent.ExecutionException;

public class MicrosoftAzureActiveDirectoryExample {
    private static final String NETWORK_NAME = "Microsoft Azure Active Directory";
    private static final String PROTECTED_RESOURCE_URL = "https://graph.windows.net/me?api-version=1.6";

    private MicrosoftAzureActiveDirectoryExample() {
    }

    public static void main(String ... args) throws IOException, InterruptedException, ExecutionException {
        String clientId = "785d433f-9431-4707-be92-46212b2294b2";
        String clientSecret = "J5K9Hico9S~Uk~64rwSSkt5d-D.-3.g6nj";
        OAuth20Service service = new ServiceBuilder("785d433f-9431-4707-be92-46212b2294b2").apiSecret("J5K9Hico9S~Uk~64rwSSkt5d-D.-3.g6nj").defaultScope("openid").callback("http://localhost:8965/app").build(MicrosoftAzureActiveDirectoryApi.instance());
        Scanner in = new Scanner(System.in, "UTF-8");
        System.out.println("=== Microsoft Azure Active Directory's OAuth Workflow ===");
        System.out.println();
        System.out.println("Fetching the Authorization URL...");
        String authorizationUrl = service.getAuthorizationUrl();
        System.out.println("Got the Authorization URL!");
        System.out.println("Now go and authorize ScribeJava here:");
        System.out.println(authorizationUrl);
        System.out.println("And paste the authorization code here");
        System.out.print(">>");
        String code = in.nextLine();
        System.out.println();
        System.out.println("Trading the Authorization Code for an Access Token...");
        OAuth2AccessToken accessToken = service.getAccessToken(code);
        System.out.println("Got the Access Token!");
        System.out.println("(The raw response looks like this: " + accessToken.getRawResponse() + "')");
        System.out.println();
        System.out.println("Now we're going to access a protected resource...");
        OAuthRequest request = new OAuthRequest(Verb.GET, PROTECTED_RESOURCE_URL);
        service.signRequest(accessToken, request);
        Throwable throwable = null;
        Object var10_11 = null;
        try (Response response = service.execute(request);){
            System.out.println("Got it! Lets see what we found...");
            System.out.println();
            System.out.println(response.getCode());
            System.out.println(response.getBody());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        System.out.println();
        System.out.println("Thats it man! Go and build something awesome with ScribeJava! :)");
    }
}

