/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.util.EntityUtils;

public class GetApi
extends BaseAdapter {
    private HttpResponse response = null;

    protected GetApi(String cloudName, String keyStorePath) {
        super(cloudName, keyStorePath);
    }

    public static void main(String[] args) {
        try {
            File downloadFile;
            System.out.println("@@@@@@@@@@@############start");
            if (args == null || args.length == 0 || args[0] == null && args[0] == "" || args[1] == null && args[1] == "" || args[2] == null && args[2] == "") {
                System.out.println("************ Please enter the ip address and proper cloudName and type**********");
                System.exit(0);
            }
            String IpAddress = args[0];
            String cloudName = args[1];
            String userType = args[2];
            boolean allUsers = false;
            if (IpAddress.endsWith("/")) {
                IpAddress = IpAddress.substring(0, IpAddress.length() - 1);
            }
            if (IpAddress.startsWith("http://")) {
                IpAddress = IpAddress.substring(7);
            }
            if (IpAddress.startsWith("https://")) {
                IpAddress = IpAddress.substring(8);
            }
            System.out.println("IP Address after trimming:" + IpAddress + " Cloud name:" + cloudName);
            if (userType.equalsIgnoreCase("all")) {
                allUsers = true;
            }
            if ((downloadFile = new File("BlackList_And_Active_User.txt")).exists()) {
                downloadFile.delete();
            }
            downloadFile.createNewFile();
            int responseCode = new GetApi(cloudName, "C:\\Program Files (x86)\\PBODBTask\\keystore.jks").downloadFile(IpAddress, downloadFile, allUsers);
            System.out.println("the final response code is:" + responseCode);
            System.out.println("******** $$$$$$$ File Downloaded Successfully ********");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Exception occured could not execute: 500");
        }
    }

    public int downloadFile(String ip, File downTempFile, boolean isAllusers) throws Exception {
        InputStream in = null;
        boolean fileTransferSuccess = true;
        HttpGet httpGet = null;
        String downloadFileUrl = "/paracloud/cloud" + this.cloudName + "/users/createExcelForBlackListAndMappedUser";
        try {
            URI uri = this.formHttpsUri(ip, downloadFileUrl);
            System.out.println("downloadFileUrl: " + uri);
            httpGet = new HttpGet(uri);
            httpGet.setHeader("Accept", "application/json");
            httpGet.setHeader("is-all-user", String.valueOf(isAllusers));
            this.response = this.httpclient.execute(httpGet);
        }
        catch (ClientProtocolException e) {
            System.out.println("client protocol exception " + e);
            this.closeResponseEntity();
            throw new CrawlAdapterException("client protocol exception " + e, e);
        }
        catch (FileNotFoundException e) {
            this.closeResponseEntity();
            throw new CrawlAdapterException("File Not found exception:" + e, e);
        }
        catch (IOException ex) {
            this.closeResponseEntity();
            throw new CrawlAdapterException(ex.getMessage(), ex);
        }
        if (this.response == null) {
            System.out.println("response is null......Failed : HTTP error code : 500");
            this.closeResponseEntity();
            return 500;
        }
        if (this.response.getStatusLine().getStatusCode() != 200) {
            throw new RuntimeException("Failed : HTTP error code : " + this.response.getStatusLine().getStatusCode());
        }
        return this.parseResponseEntityAndDownloadFileToTempFolder(downTempFile, in, fileTransferSuccess);
    }

    private boolean downloadFileFromServerUsingTheInputStream(InputStream in, File downloadTempFile, boolean fileTransferSuccess) {
        FileOutputStream out = null;
        boolean fileTransferSuccessTemp = fileTransferSuccess;
        try {
            boolean result;
            out = new FileOutputStream(downloadTempFile);
            byte[] buffer = new byte[1024];
            int len = 0;
            fileTransferSuccessTemp = result = this.downloadFileUsingInputStream(len, in, out, buffer, fileTransferSuccessTemp);
        }
        catch (FileNotFoundException e) {
            System.out.println("Exception while reading inputstream while download" + e);
            fileTransferSuccessTemp = false;
        }
        if (out != null) {
            try {
                ((OutputStream)out).close();
            }
            catch (IOException e) {
                System.out.println("Couldnt close inputStream " + e);
            }
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e) {
                System.out.println("Couldnt close inputStream " + e);
            }
        }
        return fileTransferSuccessTemp;
    }

    private boolean downloadFileUsingInputStream(int len, InputStream in, OutputStream out, byte[] buffer, boolean fileTransferSuccess) {
        boolean fileTransferSuccessTemp = fileTransferSuccess;
        int lenTemp = len;
        try {
            int gcSize = 0;
            int gcThreshold = 0x100000;
            while ((lenTemp = in.read(buffer)) > 0) {
                out.write(buffer, 0, lenTemp);
                if ((gcSize += lenTemp) <= gcThreshold) continue;
                gcSize = 0;
            }
        }
        catch (IOException e) {
            System.out.println("Exception while reading inputstream while download" + e);
            fileTransferSuccessTemp = false;
        }
        return fileTransferSuccessTemp;
    }

    private int parseResponseEntityAndDownloadFileToTempFolder(File downTempFile, InputStream in, boolean fileTransferSuccess) {
        HttpEntity resEntity = this.response.getEntity();
        InputStream inTemp = in;
        try {
            inTemp = resEntity.getContent();
        }
        catch (Exception e) {
            this.closeResponseEntity();
            System.out.println("FILE DOWNLOAD INTERNAL ERROR: 500 ");
            return 500;
        }
        boolean fileTransferSuccessTemp = fileTransferSuccess;
        fileTransferSuccessTemp = this.downloadFileFromServerUsingTheInputStream(inTemp, downTempFile, fileTransferSuccessTemp);
        this.closeResponseEntity();
        if (!fileTransferSuccessTemp) {
            return 500;
        }
        return 200;
    }

    public void closeResponseEntity() {
        block6: {
            try {
                System.out.println("inside closing response entity.....");
                if (this.response == null || this.response.getEntity() == null || !this.response.getEntity().isStreaming()) break block6;
                try {
                    if (this.response.getEntity().getContent() != null) {
                        this.response.getEntity().getContent().close();
                        EntityUtils.consume(this.response.getEntity());
                    }
                }
                catch (IOException e) {
                    System.out.println(e.getMessage());
                }
                catch (Exception e) {
                    System.out.println("Exception in closing response entity");
                }
            }
            catch (Exception e) {
                System.out.println("Exception in closing response entity outside");
            }
        }
    }
}

