/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;

public class BaseAdapter {
    protected HttpClient httpclient = null;
    private static Scheme sch = null;
    private static final int HTTPS_PORT = 443;
    protected static final int HTTP_CONNECTION_TIMEOUT = 60000;
    protected static final int HTTP_SO_TIMEOUT = 300000;
    protected static final int HTTP_SO_LINGER = 30;
    protected static final int HTTP_OK = 200;
    protected static final String URL_PATH_SEPERATOR = "/";
    protected String cloudName;
    protected static final String APPLICATION_XML = "application/xml";
    protected static final String CONTENT_TYPE = "Content-Type";
    protected static final String TEXT_XML = "text/xml";
    protected static final String CONTENT_ENCODING = "Content-Encoding";
    protected static final String GZIP_ENCODING = "gzip";
    protected static final String HTTP_PROTOCOL = "http";
    protected static final String HTTPS_PROTOCOL = "https";
    protected static final String PARACLOUD_URL = "/paracloud";
    protected static final String API_HOST_ADDRESS = "dns.parablu.com";
    protected static final String SUPPORT_HOST_ADDRESS = "supportapi.parablu.com";
    protected static final String PARACLOUD_BASE_REQUESTPARAMETER = "/cloud";
    private static final String URI_SYNTAX_EXCEPTION_HTTPS = "URISyntaxException https: ";
    protected static final String PMS_URL = "/paracloud";
    protected static final String PRIVACY_GATEWAY_URL = "/BluKryptBuilder";

    protected BaseAdapter(String keyStore) {
        this((String)null, keyStore);
    }

    protected BaseAdapter(String cloudName, String keyStorePath) {
        this.cloudName = URL_PATH_SEPERATOR + cloudName;
        this.httpclient = new DefaultHttpClient();
        HttpConnectionParams.setConnectionTimeout(this.httpclient.getParams(), 60000);
        HttpConnectionParams.setSoTimeout(this.httpclient.getParams(), 300000);
        HttpConnectionParams.setLinger(this.httpclient.getParams(), 30);
        if (sch == null) {
            BaseAdapter.initializeScheme(keyStorePath);
        }
        if (sch != null) {
            this.httpclient.getConnectionManager().getSchemeRegistry().register(sch);
        }
    }

    protected BaseAdapter(InputStream instream) {
        this(instream, null);
    }

    protected BaseAdapter(InputStream instream, String cloudName) {
        this.cloudName = URL_PATH_SEPERATOR + cloudName;
        this.httpclient = new DefaultHttpClient();
        HttpConnectionParams.setConnectionTimeout(this.httpclient.getParams(), 60000);
        HttpConnectionParams.setSoTimeout(this.httpclient.getParams(), 300000);
        HttpConnectionParams.setLinger(this.httpclient.getParams(), 30);
        if (sch == null) {
            BaseAdapter.initializeScheme(instream);
        }
        if (sch != null) {
            ClientConnectionManager ccm = this.httpclient.getConnectionManager();
            SchemeRegistry sr = ccm.getSchemeRegistry();
            sr.register(sch);
            this.httpclient = new DefaultHttpClient(ccm, this.httpclient.getParams());
        }
        IOUtils.closeQuietly(instream);
    }

    private static void initializeScheme(String keyStorePath) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (FileInputStream instream = new FileInputStream(new File(keyStorePath));){
                BaseAdapter.registerSchemeForKeystoreStream("JKS", instream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            System.out.println("Exception in initializeScheme: " + e);
        }
    }

    private static void initializeScheme(InputStream instream) {
        try {
            try {
                BaseAdapter.registerSchemeForKeystoreStream("BKS", instream);
            }
            catch (Exception e) {
                System.out.println("Exception in registerSchemeForKeystoreStream: " + e);
                IOUtils.closeQuietly(instream);
            }
        }
        finally {
            IOUtils.closeQuietly(instream);
        }
    }

    private static void registerSchemeForKeystoreStream(String keystoreType, InputStream instream) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, KeyManagementException, UnrecoverableKeyException {
        KeyStore trustStore = KeyStore.getInstance(keystoreType);
        trustStore.load(instream, "changeit".toCharArray());
        MySSLSocketFactory socketFactory = new MySSLSocketFactory(trustStore);
        socketFactory.setHostnameVerifier(new SkipX509HostnameVerifier());
        sch = new Scheme(HTTPS_PROTOCOL, socketFactory, 443);
    }

    protected URI formHttpsUri(String iP, String requestParams) throws Exception {
        URI uri;
        try {
            uri = new URI(HTTPS_PROTOCOL, iP, requestParams, null);
        }
        catch (URISyntaxException e) {
            throw new Exception(URI_SYNTAX_EXCEPTION_HTTPS + e);
        }
        return uri;
    }

    protected URI formHttpsUri(String iP, int port, String requestParams) throws Exception {
        URI uri;
        try {
            uri = new URI(HTTPS_PROTOCOL, null, iP, port, requestParams, null, null);
        }
        catch (URISyntaxException e) {
            throw new Exception(URI_SYNTAX_EXCEPTION_HTTPS + e);
        }
        return uri;
    }

    protected URI formHttpUri(String iP, int port, String requestParams) throws Exception {
        URI uri;
        try {
            uri = new URI(HTTP_PROTOCOL, null, iP, port, requestParams, null, null);
        }
        catch (URISyntaxException e) {
            throw new Exception(URI_SYNTAX_EXCEPTION_HTTPS + e);
        }
        return uri;
    }

    protected URI formHttpUri(String iP, String requestParams) throws Exception {
        URI uri;
        try {
            uri = new URI(HTTP_PROTOCOL, iP, requestParams, null);
        }
        catch (URISyntaxException e) {
            throw new Exception(URI_SYNTAX_EXCEPTION_HTTPS + e);
        }
        return uri;
    }
}

