/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.reflect;

import com.google.inject.TypeLiteral;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.sonatype.guice.bean.reflect.BeanProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BeanPropertySetter<T>
implements BeanProperty<T>,
PrivilegedAction<Void> {
    private static final String BEAN_SETTER_ERROR = "Error calling bean setter: %s reason: %s";
    private final Method method;

    BeanPropertySetter(Method method) {
        this.method = method;
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return this.method.getAnnotation(annotationType);
    }

    @Override
    public TypeLiteral<T> getType() {
        return TypeLiteral.get(this.method.getGenericParameterTypes()[0]);
    }

    @Override
    public String getName() {
        String name = this.method.getName();
        return Character.toLowerCase(name.charAt(3)) + name.substring(4);
    }

    @Override
    public <B> void set(B bean, T value) {
        if (!this.method.isAccessible()) {
            AccessController.doPrivileged(this);
        }
        try {
            this.method.invoke(bean, value);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(String.format(BEAN_SETTER_ERROR, this.method, e.getTargetException()));
        }
        catch (Throwable e) {
            throw new RuntimeException(String.format(BEAN_SETTER_ERROR, this.method, e));
        }
    }

    public int hashCode() {
        return this.method.hashCode();
    }

    public boolean equals(Object rhs) {
        if (this == rhs) {
            return true;
        }
        if (rhs instanceof BeanPropertySetter) {
            return this.method.equals(((BeanPropertySetter)rhs).method);
        }
        return false;
    }

    public String toString() {
        return this.method.toString();
    }

    @Override
    public Void run() {
        this.method.setAccessible(true);
        return null;
    }
}

